/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.NotificationSource;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.TraceMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.TraceMBeanProxyImpl;
import java.rmi.RemoteException;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.facilities.TraceLevel;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.NotificationSource;
import javax.slee.management.SbbNotification;
import javax.slee.management.TraceNotification;

public class Test1114228Test
extends AbstractSleeTCKTest {
    private TCKResourceListener resourceListener;
    private NotificationListener listener;
    private FutureResult result;
    private DeployableUnitID duID;
    private String testName = "Test1114228";
    private int assertionID = 1114228;
    private SbbID sbbID;
    private ServiceID serviceID;
    private ObjectName traceMBeanName;
    private TraceMBeanProxy tracembean;
    private int receivedTraceNotifications = 0;
    private int expectedTraceNotifications;
    private boolean passed = false;
    private SbbNotification sbbNotification;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        this.expectedTraceNotifications = 1;
        this.doTest11142228Test(TraceLevel.INFO);
        Test1114228Test test1114228Test = this;
        synchronized (test1114228Test) {
            this.wait(this.utils().getTestTimeout());
        }
        if (this.passed && this.expectedTraceNotifications == this.receivedTraceNotifications) {
            result.setPassed();
        } else {
            result.setFailed(1114228, "Expected number of trace messages not received, traces were not delivered by the TraceFacility (expected " + this.expectedTraceNotifications + ", received " + this.receivedTraceNotifications + ")");
        }
    }

    public void doTest11142228Test(TraceLevel traceLevel) throws Exception {
        TraceMBeanProxy traceMBeanProxy = this.utils().getTraceMBeanProxy();
        if (this.sbbID == null) {
            throw new TCKTestErrorException("sbbID not found for serviceDUPath");
        }
        if (this.serviceID == null) {
            throw new TCKTestErrorException("serviceID not found for serviceDUPath");
        }
        this.sbbNotification = new SbbNotification(this.serviceID, this.sbbID);
        try {
            this.getLog().fine("Starting to test: Set trace level of the tracer ");
            traceMBeanProxy.setTraceLevel((NotificationSource)this.sbbNotification, "com.foo", traceLevel);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            TCKTestResult.error("ERROR!", e);
        }
        String activityName = "Test1114228Test";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: " + this.testName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.getLog().fine("Installing and activating service");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        String duPath = this.utils().getTestParams().getProperty("serviceDUPath");
        this.duID = this.utils().install(duPath);
        this.utils().activateServices(this.duID, true);
        SleeManagementMBeanProxy proxy = this.utils().getSleeManagementMBeanProxy();
        this.traceMBeanName = proxy.getTraceMBean();
        this.listener = new TraceNotificationListenerImpl();
        this.tracembean = new TraceMBeanProxyImpl(this.traceMBeanName, this.utils().getMBeanFacade());
        this.tracembean.addNotificationListener(this.listener, null, null);
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof ServiceID) {
                this.getLog().fine("Setting serviceID value.");
                this.serviceID = (ServiceID)components[i];
                continue;
            }
            if (!(components[i] instanceof SbbID)) continue;
            this.getLog().fine("Setting sbbID value.");
            this.sbbID = (SbbID)components[i];
        }
    }

    public void tearDown() throws Exception {
        if (null != this.tracembean) {
            this.tracembean.removeNotificationListener(this.listener);
        }
        this.utils().getLog().fine("Disconnecting from resource");
        this.utils().getResourceInterface().clearActivities();
        this.utils().getLog().fine("Deactivating and uninstalling service");
        this.utils().deactivateAllServices();
        this.utils().uninstallAll();
    }

    public String getTestName() {
        String testName = "testName";
        return this.utils().getTestParams().getProperty(testName);
    }

    private boolean doNotficationSourcesCheck(SbbNotification theNotification) {
        String usageMBeanProperties;
        String alarmNotify;
        SbbNotification expectedSbbNotification = null;
        boolean passed = true;
        try {
            ServiceID notifyServiceID = theNotification.getService();
            this.getLog().fine("1114221: getService = " + notifyServiceID);
            if (notifyServiceID.getName().equals("Test1114228TestService")) {
                this.logSuccessfulCheck(1114221);
            } else {
                this.result.setFailed(1114221, "getService() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114221, "getService() failed");
            return false;
        }
        try {
            SbbID notifySbbID = theNotification.getSbb();
            this.getLog().fine("1114220: getService = " + notifySbbID);
            if (notifySbbID.getName().equals("Test1114228Test")) {
                this.logSuccessfulCheck(1114220);
            } else {
                this.result.setFailed(1114220, "getSbb() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114220, "getSbb() failed");
            return false;
        }
        try {
            String notification = theNotification.toString();
            this.getLog().fine("1114227: toString() : " + this.sbbNotification);
            this.logSuccessfulCheck(1114227);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114227, "Incorrect Notification Name");
            return false;
        }
        try {
            theNotification.hashCode();
            this.logSuccessfulCheck(1114230);
        }
        catch (Exception e) {
            this.result.setFailed(1114230, ".hashCode() failed");
            return false;
        }
        expectedSbbNotification = this.sbbNotification;
        try {
            boolean areEqual = theNotification.equals((Object)expectedSbbNotification);
            this.getLog().fine("1114223: theNotification.equals : " + theNotification + ", " + expectedSbbNotification);
            if (areEqual) {
                this.logSuccessfulCheck(1114223);
            } else {
                this.result.setFailed(1114223, ".equals() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114223, ".equals() failed");
            return false;
        }
        try {
            int areCompared = theNotification.compareTo((Object)expectedSbbNotification);
            if (areCompared == 0) {
                this.logSuccessfulCheck(0x110070);
            } else {
                this.result.setFailed(0x110070, ".compareTo() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(0x110070, ".compareTo() failed");
            return false;
        }
        try {
            alarmNotify = theNotification.getAlarmNotificationType();
            this.getLog().fine("1114226: getAlarmNotificationType = " + alarmNotify);
            if (alarmNotify.equals("javax.slee.management.alarm.sbb")) {
                this.logSuccessfulCheck(1114226);
            } else {
                passed = false;
                this.result.setFailed(1114226, "getAlarmNotificationType() failed");
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114226, "getAlarmNotificationType() failed");
            return false;
        }
        try {
            alarmNotify = theNotification.getTraceNotificationType();
            this.getLog().fine("1114222: getTraceNotificationType = " + alarmNotify);
            if (alarmNotify.equals("javax.slee.management.trace.sbb")) {
                this.logSuccessfulCheck(1114222);
            } else {
                this.result.setFailed(1114222, "getTraceNotificationType() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114222, "getTraceNotificationType() failed");
            return false;
        }
        try {
            alarmNotify = theNotification.getUsageNotificationType();
            this.getLog().fine("1114229: getUsageNotificationType = " + alarmNotify);
            if (alarmNotify.equals("javax.slee.management.usage.sbb")) {
                this.logSuccessfulCheck(1114229);
            } else {
                this.result.setFailed(1114222, "getTraceNotificationType() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114229, "getUsageNotificationType() failed");
            return false;
        }
        try {
            usageMBeanProperties = theNotification.getUsageMBeanProperties();
            this.getLog().fine("1114225: getUsageMBeanProperties = " + usageMBeanProperties);
            if (usageMBeanProperties.equals("serviceName=\"Test1114228TestService\",serviceVendor=\"jain.slee.tck\",serviceVersion=\"1.1\",sbbName=\"Test1114228Test\",sbbVendor=\"jain.slee.tck\",sbbVersion=\"1.1\"")) {
                this.logSuccessfulCheck(0x110071);
            } else {
                this.result.setFailed(0x110071, "getUsageNotificationType() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(0x110071, "getUsageNotificationType() failed");
            return false;
        }
        try {
            usageMBeanProperties = SbbNotification.getUsageMBeanProperties((ServiceID)this.serviceID, (SbbID)this.sbbID);
            this.getLog().fine("111414: getUsageMBeanProperties = " + usageMBeanProperties);
            if (usageMBeanProperties.equals("serviceName=\"Test1114228TestService\",serviceVendor=\"jain.slee.tck\",serviceVersion=\"1.1\",sbbName=\"Test1114228Test\",sbbVendor=\"jain.slee.tck\",sbbVersion=\"1.1\"")) {
                this.logSuccessfulCheck(111414);
            } else {
                this.result.setFailed(111414, "getUsageNotificationType() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(111414, "getUsageNotificationType() failed");
            return false;
        }
        return passed;
    }

    private void logSuccessfulCheck(int assertionID) {
        this.utils().getLog().info("Check for assertion " + assertionID + " OK");
    }

    public class TraceNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            try {
                if (notification instanceof TraceNotification) {
                    TraceNotification traceNotification = (TraceNotification)notification;
                    Test1114228Test.this.getLog().fine("Received Trace Notification from: " + traceNotification);
                    if (traceNotification.getNotificationSource() instanceof SbbNotification && traceNotification.getType().equals("javax.slee.management.trace.sbb")) {
                        NotificationSource notificationSource = traceNotification.getNotificationSource();
                        SbbNotification sbbNotification = (SbbNotification)notificationSource;
                        Test1114228Test.this.passed = Test1114228Test.this.doNotficationSourcesCheck(sbbNotification);
                        if (Test1114228Test.this.passed) {
                            Test1114228Test.this.logSuccessfulCheck(1114228);
                            Test1114228Test.this.receivedTraceNotifications++;
                        } else {
                            Test1114228Test.this.result.setFailed(1114228, "NotficationSources Check failed");
                        }
                    }
                }
            }
            catch (Exception e) {
                Test1114228Test.this.utils().getLog().warning(e);
                Test1114228Test.this.getLog().warning("1114228: FAILED. Received erroneous Trace Message: " + notification.getMessage());
            }
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1114228Test";
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1114228Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
                Test1114228Test.this.result.setPassed();
            }
            catch (TCKTestFailureException ex) {
                Test1114228Test.this.result.setFailed(ex);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1114228Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1114228Test.this.getLog().warning(exception);
            Test1114228Test.this.result.setError(exception);
        }
    }
}

