/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ProfileProvisioningMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.slee.InvalidArgumentException;
import javax.slee.profile.ProfileSpecificationID;

public class ProfileTableNamesTest
implements SleeTCKTest {
    private static final String PROFILE_DU_PATH_PARAM = "profileDUPath";
    private static final int ASSERTION_ID = 2426;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private ProfileUtils profileUtils;
    private Vector tablesAdded;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        char validChar;
        ProfileProvisioningMBeanProxy profileProvisioningProxy = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils).lookupProfileSpecificationID("SimpleProfile", "jain.slee.tck", "1.0");
        if (profileSpecID == null) {
            throw new TCKTestErrorException("No ProfileSpecification found.");
        }
        StringBuffer validNameBuf = new StringBuffer();
        for (validChar = ' '; validChar < '.'; validChar = (char)(validChar + '\u0001')) {
            validNameBuf.append(validChar);
        }
        for (validChar = '0'; validChar < '~'; validChar = (char)(validChar + '\u0001')) {
            validNameBuf.append(validChar);
        }
        String validName = validNameBuf.toString();
        try {
            this.utils.getLog().info("Attempting to create a profile table with the following valid name: " + validName);
            profileProvisioningProxy.createProfileTable(profileSpecID, validName);
            this.tablesAdded.addElement(validName);
            this.utils.getLog().info("The createProfileTable() method threw no Exception. Calling getProfileTables() to check whether the profile table was created");
            Collection profileTableNames = profileProvisioningProxy.getProfileTables();
            if (profileTableNames == null || !profileTableNames.contains(validName)) {
                throw new TCKTestFailureException(2426, "Failed to create a profile table with the following valid name: " + validName + ". createProfileTable() threw no Exception, " + "but the profile table name did not exist in the set of names returned by getProfileTables().");
            }
            this.utils.getLog().info("The profile table was created successfully");
        }
        catch (InvalidArgumentException e) {
            throw new TCKTestFailureException(2426, "Caught unexpected InvalidArgumentException when trying to create a profile table with the following valid name: " + validName, (Exception)((Object)e));
        }
        Vector<Character> invalidCharacters = new Vector<Character>();
        for (char invalidChar = '\u0000'; invalidChar < '\u001f'; invalidChar = (char)(invalidChar + '\u0001')) {
            invalidCharacters.addElement(new Character(invalidChar));
        }
        invalidCharacters.addElement(new Character('/'));
        invalidCharacters.addElement(new Character('\u007f'));
        Iterator invalidCharactersIter = invalidCharacters.iterator();
        while (invalidCharactersIter.hasNext()) {
            Character invalidCharacter = (Character)invalidCharactersIter.next();
            char unicodeValue = invalidCharacter.charValue();
            try {
                profileProvisioningProxy.createProfileTable(profileSpecID, invalidCharacter.toString());
                this.tablesAdded.addElement(invalidCharacter.toString());
                return TCKTestResult.failed(2426, "The SLEE did not throw the expected InvalidArgumentException when trying to create a profile table with an invalid name. The invalid name was a single character of unicode value " + unicodeValue);
            }
            catch (InvalidArgumentException e) {
                this.utils.getLog().info("Caught expected InvalidArgumentException for an invalid profile table name with a character of unicode value " + unicodeValue + ". Error message: " + e.getMessage());
            }
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.tablesAdded = new Vector();
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing the profile spec");
        String duPath = this.utils.getTestParams().getProperty(PROFILE_DU_PATH_PARAM);
        this.utils.install(duPath);
        this.profileUtils = new ProfileUtils(this.utils);
    }

    public void tearDown() throws Exception {
        if (this.profileUtils != null && this.tablesAdded != null && !this.tablesAdded.isEmpty()) {
            Iterator tablesAddedIter = this.tablesAdded.iterator();
            while (tablesAddedIter.hasNext()) {
                try {
                    this.profileUtils.removeProfileTable((String)tablesAddedIter.next());
                }
                catch (Exception e) {
                    this.utils.getLog().warning(e);
                }
            }
        }
        this.utils.getLog().fine("Uninstalling the profile spec");
        this.utils.uninstallAll();
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().removeResourceListener();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public void onException(Exception e) throws RemoteException {
            ProfileTableNamesTest.this.utils.getLog().warning("Received exception from the TCK resource");
            ProfileTableNamesTest.this.utils.getLog().warning(e);
        }
    }
}

