/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ProfileProvisioningMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.EmptyArrays;
import java.rmi.RemoteException;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.slee.management.ManagementException;
import javax.slee.profile.ProfileSpecificationID;

public class Test1083Test
implements SleeTCKTest {
    private static final String PROFILE_DU_PATH_PARAM = "profileDUPath";
    private static final int TEST_ID = 1083;
    private static final String ATTRIBUTE_NAME = "AttributeA";
    private static final String PROFILE_SPEC_NAME = "Test1083ProfileCMP";
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private ProfileUtils profileUtils;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioningProxy = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils).lookupProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", "1.0");
        if (profileSpecID == null) {
            throw new TCKTestErrorException("No ProfileSpecification found.");
        }
        ObjectName profileObj = null;
        try {
            profileProvisioningProxy.createProfileTable(profileSpecID, "Test1083ProfileTable");
            profileObj = profileProvisioningProxy.createProfile("Test1083ProfileTable", "Test1083Profile");
        }
        catch (Exception e) {
            return TCKTestResult.error("Failed to create profile table or profile.");
        }
        String newValue = "ChangedValue1";
        ProfileMBeanProxy profileProxy = this.utils.getMBeanProxyFactory().createProfileMBeanProxy(profileObj);
        try {
            profileProxy.editProfile();
            this.utils.getLog().info("setting attribute using MBeanServer.setAttribute() to value " + newValue);
            this.setViaSetAttribute(profileObj, newValue);
            this.utils.getLog().info("getting attribute using MBeanServer.getAttribute()");
            String currentValue = this.getViaGetAttribute(profileObj);
            this.utils.getLog().info("MBeanServer.getAttribute() return value=" + currentValue);
            Assert.assertEquals(1083, "Value returned by MBeanServer.getAttribute() was not the same as the value set using MBeanServer.setAttribute()", newValue, currentValue);
            newValue = "ChangedValue2";
            this.utils.getLog().info("setting attribute using MBeanServer.invoke(...,\"setAttributeA\",...) to value " + newValue);
            this.setViaInvoke(profileObj, newValue);
            this.utils.getLog().info("getting attribute using MBeanServer.invoke(...,\"getAttributeA\",...)");
            currentValue = this.getViaInvoke(profileObj);
            this.utils.getLog().info("MBeanServer.invoke(...,\"getAttributeA\",...) return value=" + currentValue);
            Assert.assertEquals(1083, "Value returned by MBeanServer.invoke(...,\"getAttributeA\",...) was not the same as the value set using MMBeanServer.invoke(...,\"getAttributeA\",...)", newValue, currentValue);
        }
        finally {
            if (profileProxy.isProfileWriteable()) {
                profileProxy.commitProfile();
            }
            profileProxy.closeProfile();
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing the profile spec");
        String duPath = this.utils.getTestParams().getProperty(PROFILE_DU_PATH_PARAM);
        this.utils.install(duPath);
        this.profileUtils = new ProfileUtils(this.utils);
    }

    public void tearDown() throws Exception {
        if (this.profileUtils != null) {
            ProfileProvisioningMBeanProxy profileProvisioningProxy = this.profileUtils.getProfileProvisioningProxy();
            try {
                profileProvisioningProxy.removeProfile("Test1083ProfileTable", "Test1083Profile");
            }
            catch (Exception e) {
                this.utils.getLog().warning(e);
            }
            try {
                this.profileUtils.removeProfileTable("Test1083ProfileTable");
            }
            catch (Exception e) {
                this.utils.getLog().warning(e);
            }
        }
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Uninstalling the profile spec");
        this.utils.uninstallAll();
    }

    private void setViaSetAttribute(ObjectName objName, String value) throws ManagementException, TCKTestErrorException, TCKTestFailureException {
        try {
            this.utils.getMBeanFacade().setAttribute(objName, new Attribute(ATTRIBUTE_NAME, value));
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.getAttribute()", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestFailureException(1083, "Caught ReflectionException while calling MBeanServer.setAttribute(...,\"AttributeA\",...)", re);
        }
        catch (AttributeNotFoundException e) {
            throw new TCKTestFailureException(1083, "Caught AttributeNotFoundException while calling MBeanServer.setAttribute(...,\"AttributeA\",...)", e);
        }
        catch (InvalidAttributeValueException e) {
            throw new TCKTestFailureException(1083, "Caught InvalidAttributeValueException while calling MBeanServer.setAttribute(...,\"AttributeA\",...)", e);
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof ManagementException) {
                throw (ManagementException)((Object)enclosed);
            }
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught unexpected exception", enclosed);
        }
    }

    private String getViaGetAttribute(ObjectName objName) throws ManagementException, TCKTestErrorException, TCKTestFailureException {
        try {
            return (String)this.utils.getMBeanFacade().getAttribute(objName, ATTRIBUTE_NAME);
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.getAttribute()", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestFailureException(1083, "Caught ReflectionException while calling MBeanServer.getAttribute(\"AttributeA\")", re);
        }
        catch (AttributeNotFoundException e) {
            throw new TCKTestFailureException(1083, "Caught AttributeNotFoundException while calling MBeanServer.getAttribute(\"AttributeA\")", e);
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof ManagementException) {
                throw (ManagementException)((Object)enclosed);
            }
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught unexpected exception", enclosed);
        }
    }

    private void setViaInvoke(ObjectName objName, String value) throws TCKTestErrorException, TCKTestFailureException {
        try {
            this.utils.getMBeanFacade().invoke(objName, "setAttributeA", new Object[]{value}, new String[]{"java.lang.String"});
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke(...,\"setAttributeA\",...)", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestFailureException(1083, "Caught ReflectionException while calling MBeanServer.invoke(...,\"setAttributeA\",...)", re);
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught unexpected exception", enclosed);
        }
    }

    private String getViaInvoke(ObjectName objName) throws TCKTestErrorException, TCKTestFailureException {
        try {
            return (String)this.utils.getMBeanFacade().invoke(objName, "getAttributeA", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke(...,\"getAttributeA\",...)", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestFailureException(1083, "Caught ReflectionException while calling MBeanServer.invoke(...,\"getAttributeA\",...)", re);
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught unexpected exception", enclosed);
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public void onException(Exception e) throws RemoteException {
            Test1083Test.this.utils.getLog().warning("Received exception from the TCK resource");
            Test1083Test.this.utils.getLog().warning(e);
        }
    }
}

