/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ProfileProvisioningMBean;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Collection;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.slee.profile.ProfileID;
import javax.slee.profile.ProfileSpecificationID;

public class Test1114011Test
extends AbstractSleeTCKTest {
    public static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    public static final String SPEC_NAME = "Test1114011Profile";
    public static final String SPEC_VERSION = "1.1";
    public static final String PROFILE_TABLE_NAME = "Test1114011ProfileTable";
    public static final String QUERY_NAME = "compareStringParam";
    public static final String QUERY_PARAM = "Test1114011Query";
    public static final String PROFILE_NAME = "Test1114011Profile_1";
    public static final int TEST_ID = 1114011;
    private ProfileUtils profileUtils;
    private ProfileProvisioningMBeanProxy profileProvisioning;

    public TCKTestResult run() throws Exception {
        ProfileID expectedProfile = new ProfileID(PROFILE_TABLE_NAME, PROFILE_NAME);
        ProfileSpecificationID specID = new ProfileSpecificationID(SPEC_NAME, "jain.slee.tck", SPEC_VERSION);
        this.profileProvisioning.createProfileTable(specID, PROFILE_TABLE_NAME);
        this.getLog().fine("1114011: Added profile table Test1114011ProfileTable");
        ObjectName profile = this.profileProvisioning.createProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
        ProfileMBeanProxy proxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        this.utils().getMBeanFacade().setAttribute(profile, new Attribute("StringValue", QUERY_PARAM));
        this.getLog().fine("1114011: Set Attribute in profile table to: Test1114011Query");
        proxy.commitProfile();
        proxy.closeProfile();
        try {
            Object[] queryParameters = new Object[]{new String(QUERY_PARAM)};
            boolean found = false;
            Collection profileCollections = this.profileProvisioning.getProfilesByStaticQuery(PROFILE_TABLE_NAME, QUERY_NAME, queryParameters);
            if (!profileCollections.isEmpty()) {
                for (int i = 0; i < profileCollections.size(); ++i) {
                    this.getLog().fine("1114011: query result = " + profileCollections.toArray()[i].toString());
                    if (!profileCollections.contains(expectedProfile)) {
                        return TCKTestResult.failed(1114011, "Profile does not contain Attribute for Query");
                    }
                    found = true;
                }
                if (found) {
                    this.logSuccessfulCheck(1114011);
                }
            } else {
                return TCKTestResult.failed(1114011, "ProfileTable contains no Attributes for Query");
            }
            if (!found) {
                return TCKTestResult.failed(1114011, "getProfilesByStaticQuery did not return correct value");
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114011, "ProfileProvisioningMBean did not perform getProfilesByStaticQuery");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.setupService(SERVICE_DU_PATH_PARAM);
        this.getLog().fine("1114011: setUp: Create ProfileProvisioningProxy ");
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
    }

    public void tearDown() throws Exception {
        try {
            this.profileUtils.removeProfileTable(PROFILE_TABLE_NAME);
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }

    private void logSuccessfulCheck(int assertionID) {
        this.utils().getLog().info("Check for assertion " + assertionID + " OK");
    }
}

