/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ProfileProvisioningMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.AttributeNotIndexedException;
import javax.slee.profile.AttributeTypeMismatchException;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.UnrecognizedAttributeException;

public class Test1649Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 1649;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private ProfileUtils profileUtils;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.profileUtils = new ProfileUtils(this.utils);
        ProfileProvisioningMBeanProxy profileProxy = this.profileUtils.getProfileProvisioningProxy();
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProfileSpecificationID)) continue;
            ProfileSpecificationID profileSpecID = (ProfileSpecificationID)components[i];
            try {
                profileProxy.createProfileTable(profileSpecID, "Test1649ProfileTable");
                ObjectName profile = profileProxy.createProfile("Test1649ProfileTable", "Test1649Profile");
                ProfileMBeanProxy proxy = this.utils.getMBeanProxyFactory().createProfileMBeanProxy(profile);
                proxy.commitProfile();
                proxy.closeProfile();
            }
            catch (Exception e) {
                return TCKTestResult.error("Failed to create profile table or profile.");
            }
            Collection profiles = profileProxy.getProfilesByIndexedAttribute("Test1649ProfileTable", "attributeC", "Foo");
            if (profiles.size() != 1) {
                return TCKTestResult.failed(1650, "Search for attributeC of 'Foo' failed");
            }
            boolean passed = false;
            try {
                profileProxy.getProfilesByIndexedAttribute("Test1649ProfileTable", "attributeC", new Boolean(true));
            }
            catch (AttributeTypeMismatchException e) {
                passed = true;
            }
            if (!passed) {
                return TCKTestResult.failed(1651, "attributeC is of type java.lang.String, but searching for java.lang.Boolean didn't throw AttributeTypeMismatchException.");
            }
            try {
                profileProxy.getProfilesByIndexedAttribute("Test1649ProfileTable", "attributeA", new Boolean(true));
            }
            catch (Exception e) {
                return TCKTestResult.failed(1652, "AttributeValue object was appropriate for attributeA but an Exception was thrown.");
            }
            passed = false;
            try {
                profileProxy.getProfilesByIndexedAttribute("Test1649ProfileTable", "attributeA", new Integer(1));
            }
            catch (AttributeTypeMismatchException e) {
                passed = true;
            }
            if (!passed) {
                return TCKTestResult.failed(1652, "AttributeValue object was inappropriate for attribute expecting boolean type, yet AttributeTypeMismatchException was not thrown.");
            }
            profiles = profileProxy.getProfilesByIndexedAttribute("Test1649ProfileTable", "attributeB", "Bar");
            if (profiles.size() != 1) {
                return TCKTestResult.failed(1653, "Expected one match, got " + profiles.size());
            }
            profiles = profileProxy.getProfilesByIndexedAttribute("Test1649ProfileTable", "attributeB", "NonExistant");
            if (profiles.size() != 0) {
                return TCKTestResult.failed(1653, "Expected zero matches, got " + profiles.size());
            }
            passed = false;
            try {
                profileProxy.getProfilesByIndexedAttribute("Test1649ProfileTable", "attributeB", new Integer(1));
            }
            catch (AttributeTypeMismatchException e) {
                passed = true;
            }
            if (!passed) {
                return TCKTestResult.failed(1654, "AttributeValue object was inappropriate for attribute expecting String type, yet AttributeTypeMismatchException was not thrown.");
            }
            passed = false;
            try {
                profileProxy.getProfilesByIndexedAttribute("Test1649ProfileTable", "attributeD", new Integer(42));
            }
            catch (AttributeTypeMismatchException e) {
                passed = true;
            }
            if (!passed) {
                return TCKTestResult.failed(1656, "AttributeValue object was inappropriate for attribute expecting boolean type, yet AttributeTypeMismatchException was not thrown.");
            }
            passed = false;
            try {
                profileProxy.getProfilesByIndexedAttribute("Test1649ProfileTable", "attributeF", new Boolean(true));
            }
            catch (UnrecognizedAttributeException e) {
                passed = true;
            }
            if (!passed) {
                return TCKTestResult.failed(1662, "Should have thrown UnrecognizedAttributeException when non-existent attribute was used.");
            }
            try {
                profileProxy.getProfilesByIndexedAttribute("Test1649ProfileTable", "attributeE", new Boolean(true));
            }
            catch (AttributeNotIndexedException e) {
                return TCKTestResult.passed();
            }
            return TCKTestResult.failed(1665, "Should have thrown AttributeNotIndexedException when non-indexed attribute was used.");
        }
        return TCKTestResult.error("No ProfileSpecification found.");
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        if (this.profileUtils != null) {
            ProfileProvisioningMBeanProxy profileProxy = this.profileUtils.getProfileProvisioningProxy();
            try {
                profileProxy.removeProfile("Test1649ProfileTable", "Test1649Profile");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.profileUtils.removeProfileTable("Test1649ProfileTable");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Test1649Test.this.utils.getLog().info("Received message from SBB");
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            if (passed.booleanValue()) {
                Test1649Test.this.result.setPassed();
            } else {
                Test1649Test.this.result.setFailed(1649, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test1649Test.this.utils.getLog().warning("Received exception from SBB");
            Test1649Test.this.utils.getLog().warning(e);
            Test1649Test.this.result.setError(e);
        }
    }
}

