/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ProfileProvisioningMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileID;
import javax.slee.profile.ProfileSpecificationID;

public class Test4460Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 4460;
    private static final String PROFILE_TABLE_NAME = "Test4460ProfileTable";
    private static final String PROFILE_NAME = "Test4460Profile";
    private ProfileProvisioningMBeanProxy profileProxy;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private ProfileUtils profileUtils;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        ProfileID profileID;
        this.profileUtils = new ProfileUtils(this.utils);
        this.profileProxy = this.profileUtils.getProfileProvisioningProxy();
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        ProfileSpecificationID profileSpecID = null;
        ObjectName profileObject = null;
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProfileSpecificationID)) continue;
            profileSpecID = (ProfileSpecificationID)components[i];
            try {
                this.profileProxy.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
                profileObject = this.profileProxy.createProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
                ProfileMBeanProxy proxy = this.utils.getMBeanProxyFactory().createProfileMBeanProxy(profileObject);
                proxy.commitProfile();
                proxy.closeProfile();
                break;
            }
            catch (Exception e) {
                return TCKTestResult.error("Failed to create profile table or profile.");
            }
        }
        if (profileSpecID == null) {
            return TCKTestResult.error("Could not find Profile Specification.");
        }
        Collection profiles = this.profileProxy.getProfiles(PROFILE_TABLE_NAME);
        Iterator iter = profiles.iterator();
        while (iter.hasNext()) {
            profileID = (ProfileID)iter.next();
            if (profileID.getProfileName().equals(PROFILE_NAME)) continue;
            return TCKTestResult.failed(4460, "Returned set of profiles contained default profile.");
        }
        profiles = this.profileProxy.getProfilesByIndexedAttribute(PROFILE_TABLE_NAME, "value", new Integer(0));
        iter = profiles.iterator();
        while (iter.hasNext()) {
            profileID = (ProfileID)iter.next();
            if (profileID.getProfileName().equals(PROFILE_NAME)) continue;
            return TCKTestResult.failed(4461, "Returned set of profiles contained default profile.");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        if (this.profileProxy != null) {
            try {
                this.profileProxy.removeProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.profileUtils.removeProfileTable(PROFILE_TABLE_NAME);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Test4460Test.this.utils.getLog().info("Received message from SBB");
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            if (passed.booleanValue()) {
                Test4460Test.this.result.setPassed();
            } else {
                Test4460Test.this.result.setFailed(4460, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test4460Test.this.utils.getLog().warning("Received exception from SBB");
            Test4460Test.this.utils.getLog().warning(e);
            Test4460Test.this.result.setError(e);
        }
    }
}

