/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ServiceManagementMBean;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import javax.slee.ComponentID;
import javax.slee.InvalidArgumentException;
import javax.slee.InvalidStateException;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.ServiceState;

public class Test2270Test
extends AbstractSleeTCKTest {
    private static final int TEST_ID = 2270;
    private ServiceManagementMBeanProxy serviceProxy;
    private DeployableUnitID duID;
    private ServiceID[] services;

    public TCKTestResult run() throws Exception {
        int i;
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        this.serviceProxy = this.utils().getMBeanProxyFactory().createServiceManagementMBeanProxy(this.utils().getSleeManagementMBeanProxy().getServiceManagementMBean());
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        this.services = new ServiceID[2];
        int index = 0;
        for (i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ServiceID)) continue;
            this.services[index++] = (ServiceID)components[i];
        }
        this.getLog().fine("Setting up test.");
        for (i = 0; i < this.services.length; ++i) {
            if (this.serviceProxy.getState(this.services[i]).isInactive()) continue;
            return TCKTestResult.failed(2270, "Services are not in the inactive state; cannot continue with test.");
        }
        try {
            this.serviceProxy.activate(this.services[0]);
        }
        catch (InvalidStateException e) {
            return TCKTestResult.error(e);
        }
        catch (Exception e) {
            this.utils().getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!this.serviceProxy.getState(this.services[0]).isActive()) {
            return TCKTestResult.error("Failed to activate service to start test, cannot proceed.");
        }
        if (this.serviceProxy.getState(this.services[1]).isActive()) {
            return TCKTestResult.error("Test start conditions were not met.");
        }
        this.getLog().fine("Testing assertion 2270 - deactivateAndActivate(valid services in the right states.");
        try {
            this.serviceProxy.deactivateAndActivate(new ServiceID[]{this.services[0]}, new ServiceID[]{this.services[1]});
        }
        catch (Exception e) {
            return TCKTestResult.error(e);
        }
        if (!this.serviceProxy.getState(this.services[1]).isActive()) {
            return TCKTestResult.failed(2270, "Service not in the ACTIVE state after deactivateAndActivate().");
        }
        if (this.serviceProxy.getState(this.services[0]).isActive()) {
            return TCKTestResult.failed(2270, "Service not in the INACTIVE/STOPPING state after deactivateAndActivate().");
        }
        this.getLog().fine("Verifying that services[0] is in the INACTIVE state before proceeding.");
        this.waitForStateChange(this.services[0], ServiceState.INACTIVE);
        this.getLog().fine("Calling deactivateAndActivate() with valid services.");
        try {
            this.serviceProxy.deactivateAndActivate(this.services[1], this.services[0]);
        }
        catch (Exception e) {
            return TCKTestResult.error(e);
        }
        if (!this.serviceProxy.getState(this.services[0]).isActive()) {
            return TCKTestResult.failed(2270, "Service not in the ACTIVE state after deactivateAndActivate().");
        }
        if (this.serviceProxy.getState(this.services[1]).isActive()) {
            return TCKTestResult.failed(2270, "Service not in the INACTIVE/STOPPING state after deactivateAndActivate().");
        }
        this.getLog().fine("Waiting for services[1] to enter the INACTIVE state.");
        this.waitForStateChange(this.services[1], ServiceState.INACTIVE);
        this.getLog().fine("Calling deactivateAndActivate(services[1], services[0])");
        boolean passed = false;
        try {
            this.serviceProxy.deactivateAndActivate(this.services[1], this.services[0]);
        }
        catch (InvalidStateException e) {
            passed = true;
        }
        catch (Exception e) {
            this.utils().getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!passed) {
            return TCKTestResult.failed(2273, "ServiceManagementMBean.deactivateAndActivate() should have thrown InvalidStateException when arg0 and arg1 correspond to services in the wrong state.");
        }
        this.getLog().fine("Calling deactivateAndActivate(services[1], services[1])");
        passed = false;
        try {
            this.serviceProxy.deactivateAndActivate(this.services[1], this.services[1]);
        }
        catch (InvalidArgumentException e) {
            passed = true;
        }
        catch (InvalidStateException e) {
            passed = true;
        }
        catch (Exception e) {
            this.utils().getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!passed) {
            return TCKTestResult.failed(2478, "ServiceManagementMBean.deactivateAndActivate() should have thrown InvalidStateException when arg0 corresponds to a service in the wrong state, or InvalidArgumentException should have been thrown as the same service was requested to be deactivated and activated.");
        }
        this.getLog().fine("Calling deactivateAndActivate(services[0], services[0])");
        passed = false;
        try {
            this.serviceProxy.deactivateAndActivate(this.services[0], this.services[0]);
        }
        catch (InvalidArgumentException e) {
            passed = true;
        }
        catch (InvalidStateException e) {
            passed = true;
        }
        catch (Exception e) {
            this.utils().getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!passed) {
            return TCKTestResult.failed(2478, "ServiceManagementMBean.deactivateAndActivate() should have thrown InvalidStateException when arg1 corresponds to a service in the wrong state, or InvalidArgumentException should have been thrown as the same service was requested to be deactivated and activated.");
        }
        this.getLog().fine("Calling deactivateAndActivate({services[1]}, {services[0]})");
        passed = false;
        try {
            this.serviceProxy.deactivateAndActivate(new ServiceID[]{this.services[1]}, new ServiceID[]{this.services[0]});
        }
        catch (InvalidStateException e) {
            passed = true;
        }
        catch (Exception e) {
            this.utils().getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!passed) {
            return TCKTestResult.failed(2273, "ServiceManagementMBean.deactivateAndActivate() should have thrown InvalidStateException when arg0 and arg1 correspond to services in the wrong state.");
        }
        this.getLog().fine("Calling deactivateAndActivate({services[1]}, {services[1]})");
        passed = false;
        try {
            this.serviceProxy.deactivateAndActivate(new ServiceID[]{this.services[1]}, new ServiceID[]{this.services[1]});
        }
        catch (InvalidArgumentException e) {
            passed = true;
        }
        catch (InvalidStateException e) {
            passed = true;
        }
        catch (Exception e) {
            this.utils().getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!passed) {
            return TCKTestResult.failed(2273, "ServiceManagementMBean.deactivateAndActivate() should have thrown InvalidStateException when arg0 corresponds to a service in the wrong state, or InvalidArgumentException should have been thrown as the same service was requested to be deactivated and activated.");
        }
        this.getLog().fine("Calling deactivateAndActivate({services[0]}, {services[0]})");
        passed = false;
        try {
            this.serviceProxy.deactivateAndActivate(new ServiceID[]{this.services[0]}, new ServiceID[]{this.services[0]});
        }
        catch (InvalidArgumentException e) {
            passed = true;
        }
        catch (InvalidStateException e) {
            passed = true;
        }
        catch (Exception e) {
            this.utils().getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!passed) {
            return TCKTestResult.failed(2273, "ServiceManagementMBean.deactivateAndActivate() should have thrown InvalidStateException when arg1 corresponds to a service in the wrong state, or InvalidArgumentException should have been thrown as the same service was requested to be deactivated and activated.");
        }
        this.getLog().fine("Calling deactivateAndActivate({}, {services[1]})");
        passed = false;
        try {
            this.serviceProxy.deactivateAndActivate(new ServiceID[0], new ServiceID[]{this.services[1]});
        }
        catch (InvalidArgumentException e) {
            passed = true;
        }
        catch (Exception e) {
            this.utils().getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!passed) {
            return TCKTestResult.failed(2473, "ServiceManagementMBean.deactivateAndActivate(new ServiceID[] {}, new ServiceID[] {service}) should have thrown InvalidArgumentException.");
        }
        this.getLog().fine("Calling deactivateAndActivate({services[0]}, {})");
        passed = false;
        try {
            this.serviceProxy.deactivateAndActivate(new ServiceID[]{this.services[0]}, new ServiceID[0]);
        }
        catch (InvalidArgumentException e) {
            passed = true;
        }
        catch (Exception e) {
            this.utils().getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!passed) {
            return TCKTestResult.failed(2473, "ServiceManagementMBean.deactivateAndActivate(new ServiceID[] {service}, new ServiceID[] {}) should have thrown InvalidArgumentException.");
        }
        this.getLog().fine("Calling deactivateAndActivate({null}, {services[1]})");
        passed = false;
        try {
            this.serviceProxy.deactivateAndActivate(new ServiceID[]{null}, new ServiceID[]{this.services[1]});
        }
        catch (InvalidArgumentException e) {
            passed = true;
        }
        catch (Exception e) {
            this.utils().getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!passed) {
            return TCKTestResult.failed(2473, "ServiceManagementMBean.deactivateAndActivate(new ServiceID[] {null}, new ServiceID[] {service}) should have thrown InvalidArgumentException.");
        }
        this.getLog().fine("Calling deactivateAndActivate({services[0]}, {null})");
        passed = false;
        try {
            this.serviceProxy.deactivateAndActivate(new ServiceID[]{this.services[0]}, new ServiceID[]{null});
        }
        catch (InvalidArgumentException e) {
            passed = true;
        }
        catch (Exception e) {
            this.utils().getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!passed) {
            return TCKTestResult.failed(2473, "ServiceManagementMBean.deactivateAndActivate(new ServiceID[] {service}, new ServiceID[] {null}) should have thrown InvalidArgumentException.");
        }
        this.getLog().fine("Calling deactivateAndActivate({services[0], services[0]}, {services[1]})");
        passed = false;
        try {
            this.serviceProxy.deactivateAndActivate(new ServiceID[]{this.services[0], this.services[0]}, new ServiceID[]{this.services[1]});
        }
        catch (InvalidArgumentException e) {
            passed = true;
        }
        catch (Exception e) {
            this.utils().getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!passed) {
            return TCKTestResult.failed(2473, "ServiceManagementMBean.deactivateAndActivate(new ServiceID[] {service2, service2}, new ServiceID[] {service}) should have thrown InvalidArgumentException.");
        }
        this.getLog().fine("Calling deactivateAndActivate({services[0]}, {services[1], services[1]})");
        passed = false;
        try {
            this.serviceProxy.deactivateAndActivate(new ServiceID[]{this.services[0]}, new ServiceID[]{this.services[1], this.services[1]});
        }
        catch (InvalidArgumentException e) {
            passed = true;
        }
        catch (Exception e) {
            this.utils().getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!passed) {
            return TCKTestResult.failed(2473, "ServiceManagementMBean.deactivateAndActivate(new ServiceID[] {service}, new ServiceID[] {service2, service2}) should have thrown InvalidArgumentException.");
        }
        return TCKTestResult.passed();
    }

    private void waitForStateChange(ServiceID serviceID, ServiceState expectedState) throws Exception {
        int count = 0;
        while (!this.serviceProxy.getState(serviceID).equals((Object)expectedState)) {
            if (count > 10) {
                throw new OperationTimedOutException("Timeout waiting for service " + serviceID + " to enter state " + expectedState);
            }
            Thread.sleep(500L);
            ++count;
        }
        return;
    }

    public void setUp() throws Exception {
        this.getLog().fine("Installing the service");
        String duPath = this.utils().getTestParams().getProperty("serviceDUPath");
        this.duID = this.utils().install(duPath);
    }

    public void tearDown() throws Exception {
        this.getLog().fine("Deactivating services");
        try {
            if (this.serviceProxy.getState(this.services[0]).isActive()) {
                this.serviceProxy.deactivate(this.services[0]);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.serviceProxy.getState(this.services[1]).isActive()) {
                this.serviceProxy.deactivate(this.services[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDown();
    }
}

