/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ServiceManagementMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.slee.ComponentID;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.ServiceState;

public class Test3954Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 3954;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        ServiceManagementMBeanProxy serviceProxy = this.utils.getMBeanProxyFactory().createServiceManagementMBeanProxy(this.utils.getSleeManagementMBeanProxy().getServiceManagementMBean());
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        ServiceID firstService = null;
        ServiceID secondService = null;
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ServiceID)) continue;
            ServiceID service = (ServiceID)components[i];
            if (firstService == null) {
                firstService = service;
                continue;
            }
            if (secondService != null) continue;
            secondService = service;
            break;
        }
        if (firstService == null || secondService == null) {
            return TCKTestResult.error("Failed to find both test services.");
        }
        serviceProxy.activate(firstService);
        ServiceID[] services = serviceProxy.getServices(ServiceState.ACTIVE);
        if (services.length != 1 || !services[0].equals((Object)firstService)) {
            return TCKTestResult.failed(3954, "Failed to find one active service: found " + services.length + " instead.");
        }
        services = serviceProxy.getServices(ServiceState.INACTIVE);
        if (services.length != 1 || !services[0].equals((Object)secondService)) {
            return TCKTestResult.failed(3954, "Failed to find single inactive service.");
        }
        try {
            serviceProxy.getServices(null);
        }
        catch (NullPointerException e) {
            return TCKTestResult.passed();
        }
        return TCKTestResult.failed(3955, "Should have thrown NullPointerException when passed a NULL state.");
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Test3954Test.this.utils.getLog().info("Received message from SBB");
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            if (passed.booleanValue()) {
                Test3954Test.this.result.setPassed();
            } else {
                Test3954Test.this.result.setFailed(3954, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test3954Test.this.utils.getLog().warning("Received exception from SBB");
            Test3954Test.this.utils.getLog().warning(e);
            Test3954Test.this.result.setError(e);
        }
    }
}

