/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.TraceMBean;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.TraceMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.TraceMBeanProxyImpl;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.InvalidArgumentException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.facilities.TraceLevel;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.NotificationSource;
import javax.slee.management.SbbNotification;
import javax.slee.management.TraceNotification;
import javax.slee.management.UnrecognizedNotificationSourceException;

public class Test1114191Test
extends AbstractSleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private static final int TEST_ID = 1114191;
    private TCKResourceListener resourceListener;
    private SleeTCKTestUtils utils;
    private FutureResult result;
    private DeployableUnitID duID;
    private SbbID sbbID;
    private ServiceID serviceID;
    private String testName = "Test1114191";
    private ObjectName traceMBeanName;
    private TraceMBeanProxy tracembean;
    private NotificationListener listener;
    private TraceMBeanProxy traceMBeanProxy;
    private SbbNotification sbbNotification;
    private int receivedTraceNotifications = 0;
    private int expectedTraceNotifications;
    private boolean passed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        this.expectedTraceNotifications = 1;
        if (this.sbbID == null) {
            throw new TCKTestErrorException("sbbID not found for serviceDUPath");
        }
        if (this.serviceID == null) {
            throw new TCKTestErrorException("serviceID not found for serviceDUPath");
        }
        this.traceMBeanProxy = this.utils().getMBeanProxyFactory().createTraceMBeanProxy(this.utils().getSleeManagementMBeanProxy().getTraceMBean());
        this.sbbNotification = new SbbNotification(this.serviceID, this.sbbID);
        String activityName = "Test1114191Test";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.utils().getLog().info("Firing event: " + this.testName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
        Test1114191Test test1114191Test = this;
        synchronized (test1114191Test) {
            this.wait(this.utils().getTestTimeout());
        }
        if (this.passed && this.expectedTraceNotifications == this.receivedTraceNotifications) {
            result.setPassed();
        } else if (!result.isSet()) {
            result.setFailed(1114191, "Expected number of trace messages not received, traces were not delivered by the TraceFacility (expected " + this.expectedTraceNotifications + ", received " + this.receivedTraceNotifications + ")");
        }
    }

    private boolean doNotficationSourcesCheck(NotificationSource sbbNotification) {
        int i;
        boolean found;
        boolean passed = true;
        try {
            this.utils().getLog().fine("Starting a test to set the level of the tracer.");
            this.traceMBeanProxy.setTraceLevel(sbbNotification, "com.foo", TraceLevel.FINE);
            if (this.traceMBeanProxy.getTraceLevel(sbbNotification, "com.foo") == TraceLevel.FINE) {
                this.logSuccessfulCheck(1114194);
            } else {
                this.result.setFailed(1114194, "setTraceLevel did not set Tracer level");
                passed = false;
            }
        }
        catch (Exception e) {
            this.utils().getLog().warning(e);
            this.result.setFailed(1114194, "Exception occured while setting Tracer level.");
            return false;
        }
        try {
            this.utils().getLog().fine("Starting to test an invalid tracer name.");
            this.traceMBeanProxy.setTraceLevel(sbbNotification, "com..foo", TraceLevel.FINE);
            this.result.setFailed(1114802, "Invalid Tracer name failed to throw InvalidArgumentException");
            passed = false;
        }
        catch (InvalidArgumentException iae) {
            this.logSuccessfulCheck(1114802);
        }
        catch (Exception e) {
            this.utils().getLog().warning(e);
            this.result.setFailed(1114802, "Tracer name components must be at least one character in length, that means that \u201a\u00c4\u00facom..foo\u201a\u00c4\u00f9 is not a legal name because the middle name component of this name is zero-length.");
            return false;
        }
        ServiceID badServiceID = new ServiceID("bad", "jain.slee.tck", "1.0");
        SbbID badSbbID = new SbbID("bad", "jain.slee.tck", "1.0");
        SbbNotification badSbbNotification = new SbbNotification(badServiceID, badSbbID);
        try {
            this.utils().getLog().fine("Starting to test an invalid SBB Nofification.");
            this.traceMBeanProxy.setTraceLevel((NotificationSource)badSbbNotification, "com.foo", TraceLevel.FINE);
            this.result.setFailed(1114190, "setTraceLevel(badSbbNotification) failed to throw UnrecognizedNotificationSourceException");
            passed = false;
        }
        catch (UnrecognizedNotificationSourceException e) {
            this.logSuccessfulCheck(1114190);
        }
        catch (Exception e) {
            this.utils().getLog().warning(e);
            this.result.setFailed(1114190, "setTraceLevel(badSbbNotification) failed");
            return false;
        }
        try {
            this.utils().getLog().fine("Starting to test the default trace level for all root tracers is TraceLevel.INFO.");
            if (this.traceMBeanProxy.getTraceLevel(sbbNotification, "") != TraceLevel.INFO) {
                this.result.setFailed(1114413, "The default trace level for all root tracers must set to TraceLevel.INFO, but it returned " + this.traceMBeanProxy.getTraceLevel(sbbNotification, "").toString());
                passed = false;
            } else {
                this.logSuccessfulCheck(1114413);
            }
        }
        catch (Exception e) {
            this.utils().getLog().warning(e);
            this.result.setFailed(1114413, "getTraceLevel failed");
            return false;
        }
        try {
            this.utils().getLog().fine("Starting to test the Administrator uses the TraceMBean to change the trace level for a tracer. ");
            this.traceMBeanProxy.setTraceLevel(sbbNotification, "com.foo", TraceLevel.FINE);
            if (this.traceMBeanProxy.getTraceLevel(sbbNotification, "com.foo") != TraceLevel.FINE) {
                this.result.setFailed(1114196, "The old TraceLevel for the tracername com.foo did not return TraceLevel.FINE.");
                passed = false;
            } else {
                this.traceMBeanProxy.setTraceLevel(sbbNotification, "com.foo", TraceLevel.CONFIG);
                if (this.traceMBeanProxy.getTraceLevel(sbbNotification, "com.foo") != TraceLevel.CONFIG) {
                    this.result.setFailed(1114196, "The new TraceLevel for the tracername com.foo did not return TraceLevel.CONFIG.");
                    passed = false;
                } else {
                    this.logSuccessfulCheck(1114196);
                }
            }
        }
        catch (Exception e) {
            this.utils().getLog().warning(e);
            this.result.setFailed(1114196, "There is an error when the Administrator uses the TraceMBean to change the trace level for a tracer. ");
            return false;
        }
        try {
            this.utils().getLog().fine("Starting to test getTracersSet()");
            String[] tracersSet = null;
            tracersSet = this.traceMBeanProxy.getTracersSet(sbbNotification);
            if (tracersSet.length == 0) {
                this.result.setFailed(0x110055, "getTracersSet() did not return any Tracers");
                passed = false;
            } else {
                found = false;
                for (i = 0; i < tracersSet.length; ++i) {
                    this.utils().getLog().fine("Tracer set is " + tracersSet[i]);
                    if (!tracersSet[i].equals("com.foo")) continue;
                    this.logSuccessfulCheck(0x110055);
                    found = true;
                }
                if (!found) {
                    this.result.setFailed(0x110055, "getTracersSet() did not return correct Tracers");
                    passed = false;
                }
            }
        }
        catch (Exception e) {
            this.utils().getLog().warning(e);
            this.result.setFailed(0x110055, "getTracersSet failed");
            return false;
        }
        try {
            this.utils().getLog().fine("Starting to test getTracersUsed()");
            String[] tracersUsed = null;
            tracersUsed = this.traceMBeanProxy.getTracersUsed(sbbNotification);
            if (tracersUsed.length == 0) {
                this.result.setFailed(1114191, "getTracersUsed() did not return any Tracers");
                passed = false;
            } else {
                found = false;
                for (i = 0; i < tracersUsed.length; ++i) {
                    this.utils().getLog().fine("Tracer used is " + tracersUsed[i]);
                    if (!tracersUsed[i].equals("com.foo")) continue;
                    this.logSuccessfulCheck(1114191);
                    found = true;
                }
                if (!found) {
                    this.result.setFailed(1114191, "getTracersUsed() did not return correct Tracers");
                    passed = false;
                }
            }
        }
        catch (Exception e) {
            this.utils().getLog().warning(e);
            this.result.setFailed(1114191, "getTracersUsed failed");
            return false;
        }
        try {
            this.utils().getLog().fine("Starting to test unsetTracerLevel().");
            String[] noTracersSet = null;
            found = false;
            this.traceMBeanProxy.unsetTraceLevel(sbbNotification, "com.foo");
            noTracersSet = this.traceMBeanProxy.getTracersSet(sbbNotification);
            this.utils().getLog().fine("getTracersSet returns length : " + noTracersSet.length);
            if (noTracersSet.length > 0) {
                for (i = 0; i < noTracersSet.length; ++i) {
                    if (!noTracersSet[i].equals("com.foo")) continue;
                    found = true;
                }
                if (found) {
                    this.utils().getLog().fine("ERROR: Still have Tracer set");
                    this.result.setFailed(1114189, "unsetTraceLevel() returned Tracers");
                    passed = false;
                } else {
                    this.logSuccessfulCheck(1114189);
                }
            } else {
                this.logSuccessfulCheck(1114189);
            }
        }
        catch (Exception e) {
            this.utils().getLog().warning(e);
            this.result.setFailed(1114189, "unsetTraceLevel failed");
            return false;
        }
        return passed;
    }

    public void setUp() throws Exception {
        this.utils().getLog().fine("Installing and activating service");
        String duPath = this.utils().getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils().install(duPath);
        this.utils().activateServices(this.duID, true);
        SleeManagementMBeanProxy proxy = this.utils().getSleeManagementMBeanProxy();
        this.traceMBeanName = proxy.getTraceMBean();
        this.listener = new TraceNotificationListenerImpl();
        this.tracembean = new TraceMBeanProxyImpl(this.traceMBeanName, this.utils().getMBeanFacade());
        this.tracembean.addNotificationListener(this.listener, null, null);
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof ServiceID) {
                this.utils().getLog().fine("Setting serviceID value.");
                this.serviceID = (ServiceID)components[i];
                continue;
            }
            if (!(components[i] instanceof SbbID)) continue;
            this.utils().getLog().fine("Setting sbbID value.");
            this.sbbID = (SbbID)components[i];
        }
    }

    public void tearDown() throws Exception {
        this.utils().getLog().fine("Disconnecting from resource");
        this.utils().getResourceInterface().clearActivities();
        this.utils().getLog().fine("Deactivating and uninstalling service");
        this.utils().deactivateAllServices();
        this.utils().uninstallAll();
    }

    private void logSuccessfulCheck(int assertionID) {
        this.utils().getLog().info("Check for assertion " + assertionID + " OK");
    }

    public class TraceNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            if (notification instanceof TraceNotification) {
                TraceNotification traceNotification = (TraceNotification)notification;
                Test1114191Test.this.utils().getLog().fine("Received Trace Notification from: " + traceNotification);
                if (traceNotification.getNotificationSource() instanceof SbbNotification && traceNotification.getType().equals("javax.slee.management.trace.sbb")) {
                    NotificationSource notificationSource = traceNotification.getNotificationSource();
                    Test1114191Test.this.passed = Test1114191Test.this.doNotficationSourcesCheck(notificationSource);
                    Test1114191Test.this.receivedTraceNotifications++;
                }
            }
        }
    }
}

