/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.ProfileVerificationException;

public class TestUniqueAttributeTest
extends AbstractSleeTCKTest {
    private static final String TABLE_NAME = "tck.TestUniqueAttributeTest.table";
    private static final String PROFILE_SPEC_NAME = "TestUniqueAttributeProfile";
    private static final int TEST_ID = 9999;
    private ProfileUtils profileUtils;

    public TCKTestResult run() throws Exception {
        ProfileMBeanProxy proxy;
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", "1.0");
        profileProvisioning.createProfileTable(profileSpecID, TABLE_NAME);
        ObjectName[] profiles = new ObjectName[2];
        try {
            profiles[0] = profileProvisioning.createProfile(TABLE_NAME, "Foo");
            proxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profiles[0]);
            proxy.commitProfile();
        }
        catch (Exception e) {
            return TCKTestResult.failed(9999, "Failed to create profile with uniquely indexed attribute - perhaps the SLEE erroneously included the default profile when deciding whether or not a profile with this attribute value could be legally created.");
        }
        try {
            profiles[1] = profileProvisioning.createProfile(TABLE_NAME, "Bar");
            proxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profiles[1]);
            proxy.commitProfile();
        }
        catch (ProfileVerificationException pve) {
            return TCKTestResult.passed();
        }
        catch (Exception e) {
            return TCKTestResult.error(e);
        }
        return TCKTestResult.failed(9999, "Was able to create two profiles with a uniquely indexed attribute that had its value set in profileInitialize().");
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
    }

    public void tearDown() throws Exception {
        if (this.profileUtils != null) {
            ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
            try {
                profileProvisioning.removeProfile(TABLE_NAME, "Bar");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                profileProvisioning.removeProfile(TABLE_NAME, "Foo");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.getLog().fine("Removing profile table");
                this.profileUtils.removeProfileTable(TABLE_NAME);
            }
            catch (Exception e) {
                this.getLog().warning("Caught exception while trying to remove profile table:");
                this.getLog().warning(e);
            }
        }
        this.profileUtils = null;
        super.tearDown();
    }
}

