/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.events;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.management.ObjectName;
import javax.slee.profile.ProfileRemovedEvent;
import javax.slee.profile.ProfileSpecificationID;

public class Test1010003_3Test
extends AbstractSleeTCKTest {
    private static final String TCK_SBB_EVENT_DU_PATH_PARAM = "eventDUPath";
    private static final String PROFILE_TABLE_NAME = "Test1010003_3ProfileTable";
    private static final String PROFILE_NAME = "Test1010003_3Profile";
    private QueuingResourceListener resourceListener;
    private ProfileUtils profileUtils;

    public TCKTestResult run() throws Exception {
        this.getLog().fine("Creating profile tables");
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID("SimpleProfile11", "jain.slee.tck", "1.1");
        profileProvisioning.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
        this.getLog().fine("Adding profile Test1010003_3Profile to the profile table");
        ObjectName profile = profileProvisioning.createProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
        ProfileMBeanProxy profProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        profProxy.commitProfile();
        this.getLog().fine("Removing profile Test1010003_3Profile from the profile table");
        profileProvisioning.removeProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
        try {
            TCKSbbMessage reply = this.resourceListener.nextMessage();
            if (!ProfileRemovedEvent.class.getName().equals(reply.getMessage())) {
                throw new TCKTestErrorException("Received unexpected reply from SBB after removing a profile. Message=" + reply.getMessage());
            }
        }
        catch (OperationTimedOutException ex) {
            throw new TCKTestFailureException(1010003, "Timed out waiting for acknowledgement of a ProfileRemovedEvent following the removal of a profile.", ex);
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.setupService("profileSpecDUPath");
        this.setupService(TCK_SBB_EVENT_DU_PATH_PARAM);
        this.setupService("serviceDUPath");
        this.resourceListener = new QueuingResourceListener(this.utils());
        this.setResourceListener(this.resourceListener);
        this.profileUtils = new ProfileUtils(this.utils());
    }

    public void tearDown() throws Exception {
        try {
            this.profileUtils.removeProfileTable(PROFILE_TABLE_NAME);
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile tables:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }
}

