/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.lifecycle;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.profileutils.BaseMessageAdapter;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.FutureAssertionsResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;

public class Test1110227Test
extends AbstractSleeTCKTest {
    private static final String DU_PATH_PARAM = "DUPath";
    private static final String SPEC_NAME = "Test1110227Profile";
    private static final String SPEC_VERSION = "1.0";
    private ProfileUtils profileUtils;
    private ProfileProvisioningMBeanProxy profileProvisioning;
    private RMIObjectChannel in;
    private FutureAssertionsResult futureResult;
    private TCKTestResult exResult;

    public TCKTestResult run() throws Exception {
        this.exResult = null;
        this.futureResult = new FutureAssertionsResult(new int[]{1110234, 1110236, 1110245, 0x10F111, 1110290}, this.getLog());
        ProfileSpecificationID specID = new ProfileSpecificationID(SPEC_NAME, "jain.slee.tck", SPEC_VERSION);
        this.profileProvisioning.createProfileTable(specID, "Test1110227ProfileTable");
        this.getLog().fine("Added profile table Test1110227ProfileTable based on profile spec Test1110227Profile");
        TCKTestResult result = this.futureResult.waitForResult(this.utils().getTestTimeout());
        if (!result.isPassed()) {
            return result;
        }
        this.futureResult = new FutureAssertionsResult(new int[]{1110234, 1110236, 1110276, 1110278, 1110280}, this.getLog());
        ObjectName profile = this.profileProvisioning.createProfile("Test1110227ProfileTable", SPEC_NAME);
        ProfileMBeanProxy profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        this.getLog().fine("Created profile Test1110227Profile for profile table Test1110227ProfileTable");
        profileProxy.commitProfile();
        result = this.futureResult.waitForResult(this.utils().getTestTimeout());
        if (!result.isPassed()) {
            return result;
        }
        profileProxy.editProfile();
        this.utils().getMBeanFacade().setAttribute(profile, new Attribute("StringValue", "Rollback"));
        try {
            profileProxy.commitProfile();
            return TCKTestResult.failed(1110280, "commitProfile() should have thrown an exception as TXN was marked for rollback.");
        }
        catch (Exception e) {
            this.getLog().fine("Caught exception as expected: " + e);
            String value = (String)this.utils().getMBeanFacade().getAttribute(profile, "StringValue");
            if (!value.equals("Init")) {
                return TCKTestResult.failed(1110280, "commitProfile() should have thrown an exception as TXN was marked for rollback.");
            }
            this.getLog().fine("CMP changes have been reverted as expected.");
            profileProxy.closeProfile();
            this.getLog().fine("Try to get an Sbb to cause profileVerify being called.");
            TCKResourceTestInterface resource = this.utils().getResourceInterface();
            TCKActivityID activityID = resource.createActivity(this.getClass().getName());
            this.futureResult = new FutureAssertionsResult(new int[]{1110281}, this.getLog());
            resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", null, activityID, null);
            result = this.futureResult.waitForResult(this.utils().getTestTimeout());
            if (!result.isPassed()) {
                return result;
            }
            ObjectName profile3 = this.profileProvisioning.createProfile("Test1110227ProfileTable", "Test1110227Profile3");
            ProfileMBeanProxy profileProxy3 = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile3);
            this.getLog().fine("Created profile Test1110227Profile3 for profile table Test1110227ProfileTable");
            profileProxy3.commitProfile();
            this.futureResult = new FutureAssertionsResult(new int[]{1110261, 1110263}, this.getLog());
            this.getLog().fine("Remove profile Test1110227Profile3 and check that appropriate responses have been sent.");
            this.profileProvisioning.removeProfile("Test1110227ProfileTable", "Test1110227Profile3");
            result = this.futureResult.waitForResult(this.utils().getTestTimeout());
            if (!result.isPassed()) {
                return result;
            }
            this.getLog().fine("Obtain the default profile.");
            ObjectName defaultProfile = this.profileProvisioning.getDefaultProfile("Test1110227ProfileTable");
            ProfileMBeanProxy defaultProfileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(defaultProfile);
            this.getLog().fine("Check CMP values for default profile.");
            if (!"Init".equals(this.utils().getMBeanFacade().getAttribute(defaultProfile, "StringValue"))) {
                return TCKTestResult.failed(1110290, "CMP values for default profiles not set correctly during profileInitialize().");
            }
            this.getLog().fine("Start TXN for modifying the default profile.");
            defaultProfileProxy.editProfile();
            this.utils().getMBeanFacade().setAttribute(defaultProfile, new Attribute("StringValue", "Rollback"));
            try {
                this.getLog().fine("Commit changes to default profile");
                defaultProfileProxy.commitProfile();
                this.getLog().fine("Commit was successful for default profile as expected.");
            }
            catch (Exception e2) {
                return TCKTestResult.failed(1110282, "commitProfile() should have succeeded as profileVerify is not called for changes to the Default Profile.");
            }
            if (this.exResult != null) {
                return this.exResult;
            }
            return TCKTestResult.passed();
        }
    }

    public void setPassed(int assertionID, String msg) {
        this.getLog().fine(assertionID + ": " + msg);
        if (this.futureResult != null && !this.futureResult.isSet()) {
            this.futureResult.setPassed(assertionID);
        }
    }

    public void setFailed(int assertionID, String msg, Exception e) {
        if (e == null) {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setFailed(assertionID, msg);
            }
            this.setIfEmpty(TCKTestResult.failed(assertionID, msg));
        } else {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            this.getLog().fine(e);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setFailed(new TCKTestFailureException(assertionID, msg, e));
            }
            this.setIfEmpty(TCKTestResult.failed(new TCKTestFailureException(assertionID, msg, e)));
        }
    }

    public void setError(String msg, Exception e) {
        if (e == null) {
            this.getLog().warning(msg);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setError(msg);
            }
            this.setIfEmpty(TCKTestResult.error(msg));
        } else {
            this.getLog().warning(msg);
            this.getLog().warning(e);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setError(msg, e);
            }
            this.setIfEmpty(TCKTestResult.error(msg, e));
        }
    }

    public void setUp() throws Exception {
        this.setupService(DU_PATH_PARAM);
        this.in = this.utils().getRMIObjectChannel();
        this.in.setMessageHandler(new BaseMessageAdapter(this.getLog()){

            public void onSetPassed(int assertionID, String msg) {
                Test1110227Test.this.setPassed(assertionID, msg);
            }

            public void onSetFailed(int assertionID, String msg, Exception e) {
                Test1110227Test.this.setFailed(assertionID, msg, e);
            }

            public void onLogCall(String msg) {
                Test1110227Test.this.getLog().fine(msg);
            }

            public void onSetError(String msg, Exception e) {
                Test1110227Test.this.setError(msg, e);
            }
        });
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
    }

    public void tearDown() throws Exception {
        this.in.clearQueue();
        try {
            this.profileUtils.removeProfileTable("Test1110227ProfileTable");
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }

    private void setIfEmpty(TCKTestResult exResult) {
        if (this.exResult == null) {
            this.exResult = exResult;
        }
    }
}

