/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profileadded;

import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.sbbutils.events.TCKSbbEvent;
import com.opencloud.sleetck.lib.sbbutils.events.TCKSbbEventImpl;
import com.opencloud.sleetck.lib.sbbutils.events2.SbbBaseMessageComposer;
import com.opencloud.sleetck.lib.sbbutils.events2.SendResultEvent;
import com.opencloud.sleetck.lib.testsuite.profiles.profileadded.ProfileEventsTestsProfileLocal;
import java.util.HashMap;
import javax.slee.ActivityContextInterface;
import javax.slee.Address;
import javax.slee.CreateException;
import javax.slee.profile.ProfileLocalObject;
import javax.slee.profile.ProfileUpdatedEvent;

public abstract class Test1110024Sbb
extends BaseTCKSbb {
    public static final int TYPE_UPDATE_PROFILE = 1024;

    private void sendLogMsgCall(String msg) {
        HashMap map = SbbBaseMessageComposer.getLogMsg(msg);
        try {
            TCKSbbUtils.getResourceInterface().callTest(map);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private Object sendUpdateRequestCall(int newValue, int id) throws Exception {
        HashMap map = SbbBaseMessageComposer.getCustomMessage(1024, new String[]{"NewValue", "ID"}, new Object[]{new Integer(newValue), new Integer(id)});
        return TCKSbbUtils.getResourceInterface().callTest(map);
    }

    private void sendResult(boolean result, int id, String msg, ActivityContextInterface aci) {
        HashMap map = SbbBaseMessageComposer.getSetResultMsg(result, id, msg);
        this.setResult(map);
        this.fireSendResultEvent(new SendResultEvent(), aci, null);
    }

    public void onProfileUpdatedEvent(ProfileUpdatedEvent event, ActivityContextInterface aci) {
        try {
            ProfileEventsTestsProfileLocal afterUpdateProfile;
            ProfileEventsTestsProfileLocal beforeUpdateProfile;
            if (this.getStopProcessUpdateEvent()) {
                this.sendLogMsgCall("ProfileUpdatedEvent has already been received once before. Discarding this event otherwise we would run into an endless loop.");
                return;
            }
            this.setStopProcessUpdateEvent(true);
            this.sendLogMsgCall("Received ProfileUpdatedEvent");
            try {
                beforeUpdateProfile = (ProfileEventsTestsProfileLocal)event.getBeforeUpdateProfileLocal();
            }
            catch (ClassCastException e) {
                this.sendResult(false, 1110025, "The Profile Local interface returned by ProfileUpdatedEvent.getBeforeUpdateProfileLocal() was not of type ProfileEventsTestsProfileLocal", aci);
                return;
            }
            try {
                afterUpdateProfile = (ProfileEventsTestsProfileLocal)event.getAfterUpdateProfileLocal();
            }
            catch (ClassCastException e) {
                this.sendResult(false, 1110025, "The Profile Local interface returned by ProfileUpdatedEvent.getAfterUpdateProfileLocal() was not of type ProfileEventsTestsProfileLocal", aci);
                return;
            }
            this.sendLogMsgCall("Performed method calls and class casts.");
            if (beforeUpdateProfile.getValue() != 0) {
                this.sendResult(false, 1110024, "The 'value' field in the ProfileEventsTestsProfileLocal object representing the values prior to the update was not correct.", aci);
                return;
            }
            if (afterUpdateProfile.getValue() != 42) {
                this.sendResult(false, 1110024, "The 'value' field in the ProfileEventsTestsProfileLocal object representing the values after the update was not correct.", aci);
                return;
            }
            this.sendLogMsgCall("Checked expected values for profile before and after update.");
            this.sendLogMsgCall("Request tck test to update profile field value to 2048");
            this.sendUpdateRequestCall(2048, 1110026);
            if (beforeUpdateProfile.getValue() != 0 || afterUpdateProfile.getValue() != 42) {
                this.sendResult(false, 1110026, "The 'value' field in the ProfileEventsTestsProfileLocal objects should represent a snapshot of the time when the profile was modified the first time and not be subject to changes done to the profile since then.", aci);
                return;
            }
            this.sendLogMsgCall("Check that values have not been affected by latest profile update.");
            try {
                this.setBeforeUpdateProfileLocalObject(beforeUpdateProfile);
                this.setAfterUpdateProfileLocalObject(afterUpdateProfile);
            }
            catch (Exception e) {
                this.sendResult(false, 1110640, "Attempt to store a ProfileLocal object in an SBB CMP field failed.", aci);
                return;
            }
            try {
                ProfileLocalObject profileLocal1 = this.getBeforeUpdateProfileLocalObject();
                ProfileLocalObject profileLocal2 = this.getAfterUpdateProfileLocalObject();
                if (!beforeUpdateProfile.isIdentical(profileLocal1) || !afterUpdateProfile.isIdentical(profileLocal2)) {
                    this.sendResult(false, 1110640, "Attempt to retrieve a ProfileLocal object from an SBB CMP field failed. Retrieved and original ProfileLocalObject are not identical (as determined by ProfileObject.isIdentical()).", aci);
                    return;
                }
            }
            catch (Exception e) {
                this.sendResult(false, 1110640, "Attempt to retrieve a ProfileLocal object from an SBB CMP field failed with exception: " + e, aci);
                return;
            }
            this.fireTCKSbbEvent(new TCKSbbEventImpl(null), aci, null);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKSbbEvent(TCKSbbEvent event, ActivityContextInterface aci) {
        this.sendResult(true, 1110024, "Test completed successfully", aci);
    }

    public void onSendResultEvent(SendResultEvent event, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.getResourceInterface().sendSbbMessage(this.getResult());
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void sbbPostCreate() throws CreateException {
        this.setStopProcessUpdateEvent(false);
    }

    public abstract void fireSendResultEvent(SendResultEvent var1, ActivityContextInterface var2, Address var3);

    public abstract void fireTCKSbbEvent(TCKSbbEvent var1, ActivityContextInterface var2, Address var3);

    public abstract void setResult(HashMap var1);

    public abstract HashMap getResult();

    public abstract void setStopProcessUpdateEvent(boolean var1);

    public abstract boolean getStopProcessUpdateEvent();

    public abstract void setBeforeUpdateProfileLocalObject(ProfileLocalObject var1);

    public abstract ProfileLocalObject getBeforeUpdateProfileLocalObject();

    public abstract void setAfterUpdateProfileLocalObject(ProfileLocalObject var1);

    public abstract ProfileLocalObject getAfterUpdateProfileLocalObject();
}

