/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profileadded;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileSpecificationID;

public class Test2077Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 2077;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private ProfileProvisioningMBeanProxy profileProvisioningProxy;
    private ObjectName profileMBeanName;
    private ProfileMBeanProxy profileMBeanProxy;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils.getLog());
        this.profileProvisioningProxy = new ProfileUtils(this.utils).getProfileProvisioningProxy();
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProfileSpecificationID)) continue;
            this.profileProvisioningProxy.createProfileTable((ProfileSpecificationID)components[i], "Test2077ProfileTable");
        }
        this.profileMBeanName = this.profileProvisioningProxy.createProfile("Test2077ProfileTable", "Test2077Profile");
        this.profileMBeanProxy = this.utils.getMBeanProxyFactory().createProfileMBeanProxy(this.profileMBeanName);
        this.utils.getMBeanFacade().setAttribute(this.profileMBeanName, new Attribute("Value", new Integer(42)));
        this.profileMBeanProxy.commitProfile();
        return this.result.waitForResultOrFail(this.utils.getTestTimeout(), "Timeout waiting for test result", 2077);
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        if (this.profileMBeanProxy != null) {
            try {
                this.profileMBeanProxy.closeProfile();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            this.profileProvisioningProxy.removeProfile("Test2077ProfileTable", "Test2077Profile");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.profileProvisioningProxy.removeProfileTable("Test2077ProfileTable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID activity) throws RemoteException {
            Test2077Test.this.utils.getLog().info("Received message from SBB: " + message.getMessage());
            HashMap map = (HashMap)message.getMessage();
            String type = (String)map.get("Type");
            if (type != null) {
                try {
                    Test2077Test.this.profileMBeanProxy.editProfile();
                    Test2077Test.this.utils.getMBeanFacade().setAttribute(Test2077Test.this.profileMBeanName, new Attribute("Value", new Integer(43)));
                    Test2077Test.this.profileMBeanProxy.commitProfile();
                }
                catch (Exception e) {
                    this.onException(e);
                }
            } else {
                Boolean passed = (Boolean)map.get("Result");
                String msgString = (String)map.get("Message");
                Integer id = (Integer)map.get("ID");
                if (passed.booleanValue()) {
                    Test2077Test.this.result.setPassed();
                } else {
                    Test2077Test.this.result.setFailed(id, msgString);
                }
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test2077Test.this.utils.getLog().warning("Received exception from SBB.");
            Test2077Test.this.utils.getLog().warning(e);
            Test2077Test.this.result.setError(e);
        }
    }
}

