/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profilecommit;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testsuite.profiles.simpleprofile.SimpleProfileProxy;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;

public class ProfileCommitTest
extends AbstractSleeTCKTest {
    public static final String PROFILE_TABLE_NAME = "ProfileCommitTestTable";
    public static final String VALUE_1 = "val1";
    public static final String VALUE_2 = "val2";
    public static final String VALUE_3 = "val3";
    public static final String VALUE_4 = "val4";
    public static final String STATUS_PASS = "pass";
    private SimpleProfileProxy proxy;
    private TCKActivityID activityID;
    private TCKResourceTestInterface resource;
    private ResourceListenerImpl listener;
    private ProfileUtils profileUtils;
    private boolean tableCreated = false;
    private Vector activeProxies;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID("SimpleProfile", "jain.slee.tck", "1.0");
        this.getLog().info("Creating profile table: ProfileCommitTestTable");
        profileProvisioning.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
        this.tableCreated = true;
        String name = "A";
        this.getLog().info("Creating profile A");
        ObjectName jmxObjectName = profileProvisioning.createProfile(PROFILE_TABLE_NAME, "A");
        this.listener = new ResourceListenerImpl(this.utils());
        this.setResourceListener(this.listener);
        this.resource = this.utils().getResourceInterface();
        this.getLog().fine("Creaing activity");
        this.activityID = this.resource.createActivity(this.getClass().getName());
        this.proxy = this.getProfileProxy(jmxObjectName);
        this.proxy.editProfile();
        this.getLog().info("Initialising profile value");
        this.proxy.setValue(VALUE_1);
        this.proxy.commitProfile();
        this.proxy.editProfile();
        this.proxy.setValue(VALUE_2);
        this.getLog().info("Verifying that SBB does not see the new value");
        if (!this.testSbbProfileValue("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", VALUE_1)) {
            Assert.fail(1122, "Changes made to a profile were visible to the SBB before beging committed by the administrator");
        }
        this.proxy.commitProfile();
        if (!this.testSbbProfileValue("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", VALUE_2)) {
            Assert.fail(1064, "The profile get accessor method did not return the last committed value to the SBB(1)");
        }
        this.proxy.editProfile();
        this.proxy.setValue(VALUE_3);
        this.proxy.commitProfile();
        if (!this.testSbbProfileValue("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", VALUE_3)) {
            Assert.fail(1064, "The profile get accessor method did not return the last committed value to the SBB(2)");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
        this.activeProxies = new Vector();
        super.setUp();
    }

    public void tearDown() throws Exception {
        if (this.activeProxies != null) {
            this.getLog().fine("Closing profiles");
            Iterator activeProxiesIter = this.activeProxies.iterator();
            while (activeProxiesIter.hasNext()) {
                SimpleProfileProxy aProxy = (SimpleProfileProxy)activeProxiesIter.next();
                try {
                    if (aProxy == null) continue;
                    if (aProxy.isProfileWriteable()) {
                        aProxy.restoreProfile();
                    }
                    aProxy.closeProfile();
                }
                catch (Exception ex) {
                    this.getLog().warning("Exception caught while trying to close profiles:");
                    this.getLog().warning(ex);
                }
            }
        }
        try {
            if (this.profileUtils != null && this.tableCreated) {
                this.getLog().fine("Removing profile table");
                this.profileUtils.removeProfileTable(PROFILE_TABLE_NAME);
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }

    private boolean testSbbProfileValue(String eventTypeName, String expectedValue) throws Exception {
        this.getLog().info("Firing event");
        this.getLog().info("Firing event: SBB's view of the profile should have value: " + expectedValue);
        this.resource.fireEvent(eventTypeName, expectedValue, this.activityID, null);
        Map response = (Map)this.listener.nextMessage().getMessage();
        String status = (String)response.get("status");
        this.getLog().info("SBB returned status: " + status);
        return status.equals(STATUS_PASS);
    }

    private SimpleProfileProxy getProfileProxy(ObjectName mbeanName) {
        SimpleProfileProxy rProxy = new SimpleProfileProxy(mbeanName, this.utils().getMBeanFacade());
        this.activeProxies.addElement(rProxy);
        return rProxy;
    }

    private class ResourceListenerImpl
    extends QueuingResourceListener {
        public ResourceListenerImpl(SleeTCKTestUtils utils) {
            super(utils);
        }

        public Object onSbbCall(Object argument) throws Exception {
            ProfileCommitTest.this.getLog().info("Sbb synchronous callback: " + argument);
            ProfileCommitTest.this.proxy.editProfile();
            ProfileCommitTest.this.proxy.setValue(ProfileCommitTest.VALUE_4);
            ProfileCommitTest.this.proxy.commitProfile();
            return null;
        }
    }
}

