/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profileenv;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.profileutils.BaseMessageAdapter;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;

public class Test1110374Test
extends AbstractSleeTCKTest {
    private static final String DU_PATH_PARAM = "DUPath";
    private static final String SPEC_NAME = "Test1110374Profile";
    private static final String SPEC_NAME2 = "Test1110374_2Profile";
    private static final String SPEC_VERSION = "1.0";
    private static final String PROFILE_TABLE_NAME = "Test1110374ProfileTable";
    private static final String PROFILE_TABLE_NAME2 = "Test1110374_2ProfileTable";
    private ProfileUtils profileUtils;
    private Vector profileTables;
    private ProfileProvisioningMBeanProxy profileProvisioning;
    private TCKTestResult exResult;
    private RMIObjectChannel in;

    public TCKTestResult run() throws Exception {
        try {
            this.getLog().fine("Deploy profile spec.");
            this.setupService(DU_PATH_PARAM);
        }
        catch (Exception e) {
            return TCKTestResult.failed(11101125, "Deployment of profile specification failed with exception: " + e);
        }
        ProfileSpecificationID specID2 = new ProfileSpecificationID(SPEC_NAME2, "jain.slee.tck", SPEC_VERSION);
        this.profileProvisioning.createProfileTable(specID2, PROFILE_TABLE_NAME2);
        this.profileTables.add(PROFILE_TABLE_NAME2);
        this.getLog().fine("Added profile table Test1110374_2ProfileTable based on profile spec Test1110374_2Profile");
        ProfileSpecificationID specID = new ProfileSpecificationID(SPEC_NAME, "jain.slee.tck", SPEC_VERSION);
        this.profileProvisioning.createProfileTable(specID, PROFILE_TABLE_NAME);
        this.profileTables.add(PROFILE_TABLE_NAME);
        this.getLog().fine("Added profile table Test1110374ProfileTable based on profile spec Test1110374Profile");
        ObjectName defaultProfile = this.profileProvisioning.getDefaultProfile(PROFILE_TABLE_NAME);
        this.utils().getMBeanFacade().invoke(defaultProfile, "manage", new Object[0], new String[0]);
        if (this.exResult != null) {
            return this.exResult;
        }
        return TCKTestResult.passed();
    }

    public void setPassed(int assertionID, String msg) {
        this.getLog().fine(assertionID + ": " + msg);
    }

    public void setFailed(int assertionID, String msg, Exception e) {
        if (e == null) {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            this.setIfEmpty(TCKTestResult.failed(assertionID, msg));
        } else {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            this.getLog().fine(e);
            this.setIfEmpty(TCKTestResult.failed(new TCKTestFailureException(assertionID, msg, e)));
        }
    }

    public void setError(String msg, Exception e) {
        if (e == null) {
            this.getLog().warning(msg);
            this.setIfEmpty(TCKTestResult.error(msg));
        } else {
            this.getLog().warning(msg);
            this.getLog().warning(e);
            this.setIfEmpty(TCKTestResult.error(msg, e));
        }
    }

    private void setIfEmpty(TCKTestResult exResult) {
        if (this.exResult == null) {
            this.exResult = exResult;
        }
    }

    public void setUp() throws Exception {
        this.in = this.utils().getRMIObjectChannel();
        this.in.setMessageHandler(new BaseMessageAdapter(this.getLog()){

            public void onSetPassed(int assertionID, String msg) {
                Test1110374Test.this.setPassed(assertionID, msg);
            }

            public void onSetFailed(int assertionID, String msg, Exception e) {
                Test1110374Test.this.setFailed(assertionID, msg, e);
            }

            public void onLogCall(String msg) {
                Test1110374Test.this.getLog().fine(msg);
            }

            public void onSetError(String msg, Exception e) {
                Test1110374Test.this.setError(msg, e);
            }
        });
        this.profileTables = new Vector();
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
    }

    public void tearDown() throws Exception {
        this.in.clearQueue();
        try {
            Enumeration en = this.profileTables.elements();
            while (en.hasMoreElements()) {
                this.profileUtils.removeProfileTable((String)en.nextElement());
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }
}

