/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profilelocal;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.sbbutils.events2.SbbBaseMessageComposer;
import com.opencloud.sleetck.lib.testsuite.profiles.profilelocal.MyNonSerializable;
import com.opencloud.sleetck.lib.testsuite.profiles.profilelocal.Test1110101ProfileLocal;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.Context;
import javax.slee.ActivityContextInterface;
import javax.slee.RolledBackContext;
import javax.slee.TransactionRolledbackLocalException;
import javax.slee.profile.ProfileFacility;
import javax.slee.profile.ProfileTable;
import javax.slee.profile.ReadOnlyProfileException;

public abstract class Test1110101Sbb
extends BaseTCKSbb {
    public static final int PASS_BY_REF = 0;
    public static final int TRY_CMP_GET_SET = 1;
    public static final int PASS_NON_RMI_IIOP = 2;
    public static final int CHECK_ROLLBACK = 3;
    public static final int CHECK_REMOVE = 4;
    public static final int GET_SET_PROFILE_LOCAL_VIA_BUSINESS = 5;
    public static final String PROFILE_TABLE_NAME = "Test1110101ProfileTable";
    public static final String PROFILE_NAME = "Test1110101Profile";

    private void sendLogMsgCall(String msg) {
        HashMap map = SbbBaseMessageComposer.getLogMsg(msg);
        try {
            TCKSbbUtils.getResourceInterface().callTest(map);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void sendResult(boolean result, int id, String msg) {
        HashMap map = SbbBaseMessageComposer.getSetResultMsg(result, id, msg);
        try {
            TCKSbbUtils.getResourceInterface().sendSbbMessage(map);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void do_PASS_BY_REF(ProfileTable profileTable) {
        String value;
        String key;
        Hashtable t = new Hashtable();
        Test1110101ProfileLocal profileLocal = (Test1110101ProfileLocal)profileTable.find(PROFILE_NAME);
        Hashtable t_new = profileLocal.businessInsert(t, key = "key", value = "value");
        if (t == t_new && t.containsKey(key)) {
            this.sendResult(true, 1110099, "Pass-By-Ref worked fine.");
        } else {
            this.sendResult(false, 1110099, "Pass-By-Ref test failed.");
        }
    }

    private void do_TRY_CMP_GET_SET(ProfileTable profileTable) {
        Test1110101ProfileLocal profileLocal = (Test1110101ProfileLocal)profileTable.find(PROFILE_NAME);
        profileLocal.setValue("new value");
        profileLocal.getValue();
        profileLocal.setValue2("new value");
        profileLocal.getValue2();
        this.sendResult(true, 1110101, "Using accessors defined in CMP interface via ProfileLocal interface worked fine.");
    }

    private void do_GET_SET_PROFILE_LOCAL_VIA_BUSINESS(ProfileTable profileTable) {
        Test1110101ProfileLocal profileLocal = (Test1110101ProfileLocal)profileTable.find(PROFILE_NAME);
        Test1110101ProfileLocal internal = (Test1110101ProfileLocal)profileLocal.businessGetProfileLocal();
        if (!internal.getProfileName().equals(PROFILE_NAME)) {
            this.sendResult(false, 1110642, "Obtaining ProfileLocal object via business method call did not return a proper ProfileLocal object for the chosen profile.");
            return;
        }
        if (!profileLocal.businessCompareProfileLocal(profileLocal)) {
            this.sendResult(false, 1110642, "Sending ProfileLocal object via business method call did not work as expected.");
            return;
        }
        this.sendResult(true, 1110642, "Receiving and setting a ProfileLocal object via business method call worked as expected.");
    }

    private void do_PASS_NON_RMI_IIOP(ProfileTable profileTable) {
        MyNonSerializable obj = new MyNonSerializable();
        Test1110101ProfileLocal profileLocal = (Test1110101ProfileLocal)profileTable.find(PROFILE_NAME);
        MyNonSerializable obj_new = profileLocal.businessNonSerial(obj, "new value");
        if (obj == obj_new && obj.value.equals("new value")) {
            this.sendResult(true, 1110106, "Passing non-RMI-IIOP parameter worked fine.");
        } else {
            this.sendResult(false, 1110106, "Passing non-RMI-IIOP parameter failed.");
        }
    }

    private void do_CHECK_ROLLBACK(ProfileTable profileTable) {
        Test1110101ProfileLocal profileLocal = (Test1110101ProfileLocal)profileTable.find(PROFILE_NAME);
        ReadOnlyProfileException rope = new ReadOnlyProfileException("Testexception");
        try {
            profileLocal.raiseException((RuntimeException)rope);
            this.sendResult(false, 1110120, "TransactionRolledbackLocalException should have been thrown.");
            return;
        }
        catch (TransactionRolledbackLocalException e) {
            this.sendLogMsgCall("TransactionRolledbackLocalException was received as expected after business method threw an unchecked exception.");
            if (rope.equals(e.getCause())) {
                this.sendLogMsgCall("Cause of the TransactionRolledbackLocalException was the raised ReadOnlyProfileException as expected.");
            }
            this.sendResult(false, 11101126, "Cause of the TransactionRolledbackLocalException should have been the raised ReadOnlyProfileException but was " + e.getCause());
            return;
        }
        catch (Exception e) {
            this.sendResult(false, 1110120, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: javax.slee.TransactionRolledbackLocalException");
            return;
        }
        if (this.getSbbContext().getRollbackOnly()) {
            this.sendResult(true, 1110122, "As expected TXN was marked for rollback after business method threw an unchecked exception.");
        } else {
            this.sendResult(false, 1110122, "TransactionRolledbackLocalException was caught but transaction has not been marked for rollback.");
        }
    }

    private void do_CHECK_REMOVE(ProfileTable profileTable) {
        Test1110101ProfileLocal profileLocal = (Test1110101ProfileLocal)profileTable.find(PROFILE_NAME);
        profileTable.remove(PROFILE_NAME);
        try {
            profileLocal.getValue();
            this.sendResult(false, 1110651, "TransactionRolledbackLocalException should have been thrown as profile is already removed.");
        }
        catch (TransactionRolledbackLocalException e) {
            this.sendResult(true, 1110651, "TransactionRolledbackLocalException caught as expected when trying to call methods on an invalid ProfileLocal object.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110651, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: javax.slee.TransactionRolledbackLocalException");
        }
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            int operationID = (Integer)event.getMessage();
            Context env = TCKSbbUtils.getSbbEnvironment();
            ProfileFacility profileFacility = (ProfileFacility)env.lookup("slee/facilities/profile");
            ProfileTable profileTable = profileFacility.getProfileTable(PROFILE_TABLE_NAME);
            Object profileLocal = null;
            switch (operationID) {
                case 0: {
                    this.do_PASS_BY_REF(profileTable);
                    break;
                }
                case 1: {
                    this.do_TRY_CMP_GET_SET(profileTable);
                    break;
                }
                case 5: {
                    this.do_GET_SET_PROFILE_LOCAL_VIA_BUSINESS(profileTable);
                    break;
                }
                case 2: {
                    this.do_PASS_NON_RMI_IIOP(profileTable);
                    break;
                }
                case 3: {
                    this.do_CHECK_ROLLBACK(profileTable);
                    break;
                }
                case 4: {
                    this.do_CHECK_REMOVE(profileTable);
                }
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void sbbRolledBack(RolledBackContext context) {
    }
}

