/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profilemanagement;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.profiles.profilemanagement.PMProfileManagementProxy;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Iterator;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.slee.InvalidStateException;
import javax.slee.profile.ProfileID;
import javax.slee.profile.ProfileSpecificationID;

public class ProfileManagementTest
extends AbstractSleeTCKTest {
    protected static final String PROFILE_TABLE_NAME = "tck.ProfileManagementTest.table";
    public static final String PROFILE_SPEC_NAME = "PMProfile";
    private ProfileUtils profileUtils;
    private boolean tableCreated = false;
    private Vector activeProxies;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", "1.0");
        this.getLog().info("Creating profile table: tck.ProfileManagementTest.table");
        profileProvisioning.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
        this.tableCreated = true;
        String name = "A";
        this.getLog().info("Creating profile A");
        ObjectName jmxObjectName = profileProvisioning.createProfile(PROFILE_TABLE_NAME, "A");
        PMProfileManagementProxy proxy = this.getProfileProxy(jmxObjectName);
        proxy.commitProfile();
        proxy.closeProfile();
        jmxObjectName = profileProvisioning.getProfile(PROFILE_TABLE_NAME, "A");
        proxy = this.getProfileProxy(jmxObjectName);
        Assert.assertTrue(2267, "isProfileWriteable() should have returned false for a profile retrieved via getProfile() that hasn't subsequently had editProfile() called", !proxy.isProfileWriteable());
        proxy.editProfile();
        proxy.testMarkDirty();
        Assert.assertTrue(1032, "markProfileDirty() should have explicitly set the profiles dirty flag", proxy.isProfileDirty());
        Assert.assertTrue(1040, "isProfileValid() should return true for a valid profile", proxy.testIsProfileValid(new ProfileID(PROFILE_TABLE_NAME, "A")));
        Assert.assertTrue(1040, "isProfileValid() should return false for a profile that does not exist", !proxy.testIsProfileValid(new ProfileID(PROFILE_TABLE_NAME, "X")));
        proxy.restoreProfile();
        try {
            proxy.setValue("cannot set");
            Assert.fail(1085, "Did not get an exception when attempting to invoke setter on a profile in read only state");
        }
        catch (InvalidStateException e) {
            this.getLog().info("got expected InvalidStateException");
        }
        catch (Exception e) {
            Assert.fail(1085, "Got unexpected exception when attempting to invoke setter on a profile in read only state: " + e);
        }
        try {
            this.utils().getMBeanFacade().setAttribute(jmxObjectName, new Attribute("Value", "cannot set"));
        }
        catch (MBeanException e) {
            if (e.getTargetException() instanceof InvalidStateException) {
                this.getLog().info("got expected InvalidStateException");
            } else {
                Assert.fail(1085, "Got unexpected exception when using setAttribute() to update a CMP attribute on a profile in a read only state: " + e);
            }
        }
        catch (Exception e) {
            Assert.fail(1085, "Got unexpected exception when using setAttribute() to update a CMP attribute on a profile in a read only state: " + e);
        }
        try {
            proxy.setValueIndirectly("cannot set");
            Assert.fail(1085, "Did not get an exception when a management method attemped to invoke setter on a profile in read only state");
        }
        catch (InvalidStateException e) {
            this.getLog().info("got expected InvalidStateException");
        }
        catch (Exception e) {
            Assert.fail(1085, "Got unexpected exception when a management method attemps to invoke setter on a profile in read only state: " + e);
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
        this.activeProxies = new Vector();
    }

    public void tearDown() throws Exception {
        if (this.activeProxies != null) {
            this.getLog().fine("Closing profiles");
            Iterator activeProxiesIter = this.activeProxies.iterator();
            while (activeProxiesIter.hasNext()) {
                PMProfileManagementProxy aProxy = (PMProfileManagementProxy)activeProxiesIter.next();
                try {
                    if (aProxy == null) continue;
                    if (aProxy.isProfileWriteable()) {
                        aProxy.restoreProfile();
                    }
                    aProxy.closeProfile();
                }
                catch (Exception ex) {
                    this.getLog().warning("Exception caught while trying to close profiles:");
                    this.getLog().warning(ex);
                }
            }
        }
        try {
            if (this.profileUtils != null && this.tableCreated) {
                this.getLog().fine("Removing profile table");
                this.profileUtils.removeProfileTable(PROFILE_TABLE_NAME);
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }

    private PMProfileManagementProxy getProfileProxy(ObjectName mbeanName) {
        PMProfileManagementProxy rProxy = new PMProfileManagementProxy(mbeanName, this.utils().getMBeanFacade());
        this.activeProxies.addElement(rProxy);
        return rProxy;
    }
}

