/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profilerefs;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.profiles.profilerefs.ManyToManyProfileProxy;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.InvalidStateException;
import javax.slee.management.ManagementException;
import javax.slee.profile.ProfileID;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.ProfileVerificationException;
import javax.slee.profile.UnrecognizedProfileNameException;
import javax.slee.profile.UnrecognizedProfileTableNameException;

public class ManyToManyProfilesTest
extends AbstractSleeTCKTest {
    private static final String PROFILE_TABLE_NAME = "tck.ManyToManyProfilesTest.table";
    private static final String PROFILE_SPEC_NAME = "ManyToMany";
    private static final String INDEXED_ATTRIBUTE = "name";
    private QueuingResourceListener resourceListener;
    private Vector activeProfileProxies;
    private ProfileUtils profileUtils;
    private boolean tableCreated = false;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", "1.0");
        this.getLog().info("Creating profile table: tck.ManyToManyProfilesTest.table");
        profileProvisioning.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
        this.tableCreated = true;
        ProfileID profileA = new ProfileID(PROFILE_TABLE_NAME, "A");
        ProfileID profileB = new ProfileID(PROFILE_TABLE_NAME, "B");
        ProfileID profileC = new ProfileID(PROFILE_TABLE_NAME, "C");
        ProfileID profileX = new ProfileID(PROFILE_TABLE_NAME, "X");
        ProfileID[] profileIDs = new ProfileID[]{profileA, profileB, profileC, profileX};
        for (int i = 0; i < profileIDs.length; ++i) {
            this.getLog().fine("Creating profile" + profileIDs[i]);
            ObjectName profile = profileProvisioning.createProfile(PROFILE_TABLE_NAME, profileIDs[i].getProfileName());
            ProfileMBeanProxy profProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
            profProxy.commitProfile();
        }
        ManyToManyProfileProxy profileProxyA = this.getProfileProxy(profileA.getProfileName());
        ManyToManyProfileProxy profileProxyB = this.getProfileProxy(profileB.getProfileName());
        ManyToManyProfileProxy profileProxyC = this.getProfileProxy(profileC.getProfileName());
        ManyToManyProfileProxy profileProxyX = this.getProfileProxy(profileX.getProfileName());
        this.activeProfileProxies.add(profileProxyA);
        this.activeProfileProxies.add(profileProxyB);
        this.activeProfileProxies.add(profileProxyC);
        this.activeProfileProxies.add(profileProxyX);
        this.getLog().fine("Setting the name attribute of each profile to its profile name");
        for (int i = 0; i < this.activeProfileProxies.size(); ++i) {
            ManyToManyProfileProxy aProxy = (ManyToManyProfileProxy)this.activeProfileProxies.elementAt(i);
            aProxy.editProfile();
            aProxy.setName(profileIDs[i].getProfileName());
            aProxy.commitProfile();
        }
        profileProxyC.closeProfile();
        this.activeProfileProxies.remove(profileProxyC);
        this.getLog().info("Removing profile " + profileC);
        profileProvisioning.removeProfile(PROFILE_TABLE_NAME, profileC.getProfileName());
        this.getLog().info("Creating references between profiles");
        this.performEdit(profileProxyX, profileA, 988, "Couldn't create a reference to another profile using a ProfileID");
        this.performEdit(profileProxyX, new ProfileID[]{profileA, profileB}, 914, "Couldn't create a reference to two other profiles using a ProfileID array");
        this.performEdit(profileProxyX, profileC, 1977, "Couldn't create a reference to a deleted profile");
        this.performEdit(profileProxyX, profileX, 988, "Couldn't create a reference from a profile to itself");
        this.performEdit(profileProxyA, profileX, 914, "Couldn't create a reference from A to X when X references A");
        this.performEdit(profileProxyB, profileX, 914, "Couldn't create a reference from B to X when X references A and B, and A references X");
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.getLog().fine("Installing profile specification");
        String profDUPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.utils().install(profDUPath);
        this.resourceListener = new QueuingResourceListener(this.utils());
        this.setResourceListener(this.resourceListener);
        this.profileUtils = new ProfileUtils(this.utils());
        this.activeProfileProxies = new Vector();
    }

    public void tearDown() throws Exception {
        if (this.activeProfileProxies != null) {
            this.getLog().fine("Closing profiles");
            Iterator activeProfileProxiesIter = this.activeProfileProxies.iterator();
            while (activeProfileProxiesIter.hasNext()) {
                ManyToManyProfileProxy aProxy = (ManyToManyProfileProxy)activeProfileProxiesIter.next();
                try {
                    if (aProxy == null) continue;
                    if (aProxy.isProfileWriteable()) {
                        aProxy.restoreProfile();
                    }
                    aProxy.closeProfile();
                }
                catch (Exception ex) {
                    this.getLog().warning("Exception caught while trying to close profile:");
                    this.getLog().warning(ex);
                }
            }
        }
        try {
            if (this.profileUtils != null && this.tableCreated) {
                this.getLog().fine("Removing profile table");
                this.profileUtils.removeProfileTable(PROFILE_TABLE_NAME);
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }

    private void performEdit(ManyToManyProfileProxy profile, ProfileID newSingleProfile, int assertionID, String failMessage) throws TCKTestFailureException, TCKTestErrorException, ManagementException, InvalidStateException {
        this.getLog().info("Creating a reference from profile " + profile.getName() + " to " + newSingleProfile);
        profile.editProfile();
        profile.setSingleProfile(newSingleProfile);
        try {
            profile.commitProfile();
        }
        catch (ProfileVerificationException verificationEx) {
            throw new TCKTestFailureException(assertionID, failMessage, (Exception)((Object)verificationEx));
        }
    }

    private void performEdit(ManyToManyProfileProxy profile, ProfileID[] newProfileArray, int assertionID, String failMessage) throws TCKTestFailureException, TCKTestErrorException, ManagementException, InvalidStateException {
        this.getLog().info("Creating an array of references from profile " + profile.getName() + " to a set of profiles");
        profile.editProfile();
        profile.setProfileArray(newProfileArray);
        try {
            profile.commitProfile();
        }
        catch (ProfileVerificationException verificationEx) {
            throw new TCKTestFailureException(assertionID, failMessage, (Exception)((Object)verificationEx));
        }
    }

    private ManyToManyProfileProxy getProfileProxy(String profileName) throws TCKTestErrorException, UnrecognizedProfileNameException, UnrecognizedProfileTableNameException, ManagementException {
        ObjectName mbeanName = this.profileUtils.getProfileProvisioningProxy().getProfile(PROFILE_TABLE_NAME, profileName);
        return new ManyToManyProfileProxy(mbeanName, this.utils().getMBeanFacade());
    }
}

