/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profilestate;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.profiles.simpleprofile.SimpleProfileProxy;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.InvalidStateException;
import javax.slee.management.ManagementException;
import javax.slee.profile.ProfileSpecificationID;

public class ProfileStateTest
extends AbstractSleeTCKTest {
    protected static final String PROFILE_TABLE_NAME = "tck.ProfileStateTest.table";
    public static final String PROFILE_SPEC_NAME = "SimpleProfile";
    protected static final String PROFILE_NAME = "A";
    public static final String VALUE_1 = "value1";
    public static final String VALUE_2 = "value2";
    private ProfileUtils profileUtils;
    private boolean tableCreated = false;
    private Vector activeProxies;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", "1.0");
        this.getLog().info("Creating profile table: tck.ProfileStateTest.table");
        profileProvisioning.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
        this.tableCreated = true;
        this.getLog().info("Creating profile A");
        ObjectName jmxObjectName = profileProvisioning.createProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
        SimpleProfileProxy proxy = this.getProfileProxy(jmxObjectName);
        Assert.assertTrue(1111, "After creation the ProfileMBean should be in the read-write state", proxy.isProfileWriteable());
        proxy.commitProfile();
        jmxObjectName = profileProvisioning.getProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
        proxy = this.getProfileProxy(jmxObjectName);
        Assert.assertTrue(4384, "isWritable() should return false when the profile is not in a writable state", !proxy.isProfileWriteable());
        Assert.assertTrue(4381, "The profile has not been modified so isProfileDirty() should return false", !proxy.isProfileDirty());
        proxy.editProfile();
        Assert.assertTrue(4384, "isWritable() should return true when the profile is in a writable state", proxy.isProfileWriteable());
        proxy.setValue(VALUE_1);
        Assert.assertTrue(4381, "The profile has been modified so isProfileDirty() should return true", proxy.isProfileDirty());
        proxy.commitProfile();
        Assert.assertTrue(4381, "The profile changes have been committed so isProfileDirty() should return false", !proxy.isProfileDirty());
        try {
            proxy.commitProfile();
            throw new TCKTestFailureException(4366, "Expected javax.slee.InvalidStateException exception not thrown");
        }
        catch (InvalidStateException e) {
            try {
                proxy.restoreProfile();
                throw new TCKTestFailureException(4374, "Expected javax.slee.InvalidStateException not thrown");
            }
            catch (InvalidStateException e2) {
                proxy.editProfile();
                proxy.setValue(VALUE_2);
                try {
                    proxy.closeProfile();
                    throw new TCKTestFailureException(4378, "closeProfile() should throw a javax.slee.InvalidStateException when the profile has uncommitted changes");
                }
                catch (InvalidStateException e3) {
                    proxy.restoreProfile();
                    proxy.closeProfile();
                    return TCKTestResult.passed();
                }
            }
        }
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
        this.activeProxies = new Vector();
    }

    public void tearDown() throws Exception {
        block9: {
            if (this.activeProxies != null) {
                this.getLog().fine("Closing profiles");
                Iterator activeProxiesIter = this.activeProxies.iterator();
                while (activeProxiesIter.hasNext()) {
                    SimpleProfileProxy aProxy = (SimpleProfileProxy)activeProxiesIter.next();
                    try {
                        if (aProxy == null) continue;
                        if (aProxy.isProfileWriteable()) {
                            aProxy.restoreProfile();
                        }
                        aProxy.closeProfile();
                    }
                    catch (Exception ex) {
                        this.getLog().warning("Exception caught while trying to close profiles:");
                        this.getLog().warning(ex);
                    }
                }
            }
            try {
                if (this.profileUtils == null || !this.tableCreated) break block9;
                try {
                    ProfileProvisioningMBeanProxy proxy = this.profileUtils.getProfileProvisioningProxy();
                    proxy.removeProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.getLog().fine("Removing profile table");
                this.profileUtils.removeProfileTable(PROFILE_TABLE_NAME);
            }
            catch (Exception e) {
                this.getLog().warning("Caught exception while trying to remove profile table:");
                this.getLog().warning(e);
            }
        }
        super.tearDown();
    }

    private boolean isProfileReadOnly(SimpleProfileProxy proxy) throws TCKTestErrorException, ManagementException {
        try {
            String oldValue = proxy.getValue();
            proxy.setValue("isProfileReadOnly?");
            proxy.setValue(oldValue);
            return false;
        }
        catch (InvalidStateException e) {
            return true;
        }
    }

    private SimpleProfileProxy getProfileProxy(ObjectName mbeanName) {
        SimpleProfileProxy rProxy = new SimpleProfileProxy(mbeanName, this.utils().getMBeanFacade());
        this.activeProxies.addElement(rProxy);
        return rProxy;
    }
}

