/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.readonly;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.UnrecognizedProfileNameException;

public abstract class ReadOnlyIsTrueBaseTest
extends AbstractSleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private static final String SPEC_VERSION = "1.0";
    private ProfileUtils profileUtils;
    private QueuingResourceListener resourceListener;

    protected abstract String getSpecName();

    public TCKTestResult run() throws Exception {
        String specName = this.getSpecName();
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID specID = new ProfileSpecificationID(specName, "jain.slee.tck", SPEC_VERSION);
        profileProvisioning.createProfileTable(specID, "ReadOnlyIsTrueTestsSbbProfileTable");
        this.getLog().fine("Added profile table ReadOnlyIsTrueTestsSbbProfileTable");
        ObjectName profile = profileProvisioning.createProfile("ReadOnlyIsTrueTestsSbbProfileTable", "ReadOnlyIsTrueTestsSbbProfile");
        ProfileMBeanProxy profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        this.getLog().fine("Created profile ReadOnlyIsTrueTestsSbbProfile for profile table ReadOnlyIsTrueTestsSbbProfileTable");
        try {
            this.utils().getMBeanFacade().invoke(profile, "setValue", new Object[]{"42"}, new String[]{"java.lang.String"});
            this.getLog().fine("Called set accessor via management interface.");
        }
        catch (Exception e) {
            return TCKTestResult.failed(1110066, "Exception occured when trying to set a CMP field value on a read-only profile via management client.");
        }
        profileProxy.commitProfile();
        profileProxy.closeProfile();
        this.getLog().fine("Commit and close profile ReadOnlyIsTrueTestsSbbProfile");
        this.getLog().fine("Start sending events to SLEE to get Sbb to do the profile modifications...");
        this.sendResourceEvent(0);
        this.sendResourceEvent(1);
        this.sendResourceEvent(2);
        this.sendResourceEvent(3);
        this.sendResourceEvent(4);
        this.sendResourceEvent(5);
        this.getLog().fine("Completed test sequence successfully.");
        try {
            profile = profileProvisioning.getProfile("ReadOnlyIsTrueTestsSbbProfileTable", "ReadOnlyIsTrueTestsSbbProfile");
            profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
            String value = (String)this.utils().getMBeanFacade().invoke(profile, "getValue", new Object[0], new String[0]);
            if (!"42".equals(value)) {
                return TCKTestResult.failed(1110071, "Profile ReadOnlyIsTrueTestsSbbProfile was modified by SLEE component though profile spec is declared read-only.");
            }
        }
        catch (UnrecognizedProfileNameException e) {
            return TCKTestResult.failed(1110074, "Profile ReadOnlyIsTrueTestsSbbProfile was removed by SLEE component though profile spec is declared read-only.");
        }
        this.getLog().fine("Checked that profile ReadOnlyIsTrueTestsSbbProfile has not been deleted or modified by SLEE component.");
        try {
            profile = profileProvisioning.getProfile("ReadOnlyIsTrueTestsSbbProfileTable", "ReadOnlyIsTrueTestsSbbProfile2");
            return TCKTestResult.failed(1110073, "Profile ReadOnlyIsTrueTestsSbbProfile2 was created by SLEE component though profile spec is declared read-only.");
        }
        catch (UnrecognizedProfileNameException e) {
            this.getLog().fine("Checked that profile ReadOnlyIsTrueTestsSbbProfile2 has not been created by SLEE component.");
            return TCKTestResult.passed();
        }
    }

    public void sendResourceEvent(int operationID) throws TCKTestErrorException, RemoteException, TCKTestFailureException {
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(this.getClass().getName());
        Integer message = new Integer(operationID);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", message, activityID, null);
        try {
            TCKSbbMessage reply = this.resourceListener.nextMessage();
            HashMap map = (HashMap)reply.getMessage();
            int type = (Integer)map.get("Type");
            switch (type) {
                case 0: {
                    String msg = (String)map.get("Msg");
                    int id = (Integer)map.get("ID");
                    boolean result = (Boolean)map.get("Result");
                    if (result) {
                        this.getLog().fine(id + ": " + msg);
                        break;
                    }
                    this.getLog().fine("FAILURE: " + msg);
                    throw new TCKTestFailureException(id, msg);
                }
            }
        }
        catch (OperationTimedOutException ex) {
            throw new TCKTestErrorException("Timed out waiting for processing of initial resource event.", ex);
        }
    }

    public void setUp() throws Exception {
        this.setupService(SERVICE_DU_PATH_PARAM);
        this.profileUtils = new ProfileUtils(this.utils());
        this.resourceListener = new QueuingResourceListener(this.utils()){

            public Object onSbbCall(Object argument) throws Exception {
                HashMap map = (HashMap)argument;
                int type = (Integer)map.get("Type");
                switch (type) {
                    case 1: {
                        ReadOnlyIsTrueBaseTest.this.getLog().fine((String)map.get("Msg"));
                    }
                }
                return null;
            }
        };
        this.setResourceListener(this.resourceListener);
    }

    public void tearDown() throws Exception {
        try {
            this.profileUtils.removeProfileTable("ReadOnlyIsTrueTestsSbbProfileTable");
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }
}

