/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.readonly;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.sbbutils.events2.SbbBaseMessageComposer;
import com.opencloud.sleetck.lib.testsuite.profiles.readonly.ReadOnlyTestsProfileCMP;
import com.opencloud.sleetck.lib.testsuite.profiles.readonly.ReadOnlyTestsProfileLocal;
import java.util.HashMap;
import javax.naming.Context;
import javax.slee.ActivityContextInterface;
import javax.slee.RolledBackContext;
import javax.slee.TransactionRolledbackLocalException;
import javax.slee.profile.ProfileFacility;
import javax.slee.profile.ProfileID;
import javax.slee.profile.ProfileTable;
import javax.slee.profile.ReadOnlyProfileException;
import javax.slee.profile.UnrecognizedProfileNameException;
import javax.slee.profile.UnrecognizedProfileTableNameException;

public abstract class ReadOnlyIsTrueTestsSbb
extends BaseTCKSbb {
    public static final String PROFILE_TABLE_NAME = "ReadOnlyIsTrueTestsSbbProfileTable";
    public static final String PROFILE_NAME = "ReadOnlyIsTrueTestsSbbProfile";
    public static final String PROFILE_NAME2 = "ReadOnlyIsTrueTestsSbbProfile2";
    public static final int CMP_SET = 0;
    public static final int PROF_LOCAL_SET = 1;
    public static final int PROF_LOCAL_INDIR_SET = 2;
    public static final int PROF_TAB_CREATE = 3;
    public static final int PROF_TAB_REMOVE = 4;
    public static final int PROF_LOCAL_REMOVE = 5;

    private void sendLogMsgCall(String msg) {
        HashMap map = SbbBaseMessageComposer.getLogMsg(msg);
        try {
            TCKSbbUtils.getResourceInterface().callTest(map);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void sendResult(boolean result, int id, String msg) {
        HashMap map = SbbBaseMessageComposer.getSetResultMsg(result, id, msg);
        try {
            TCKSbbUtils.getResourceInterface().sendSbbMessage(map);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            int operationID = (Integer)event.getMessage();
            Context env = TCKSbbUtils.getSbbEnvironment();
            ProfileFacility profileFacility = (ProfileFacility)env.lookup("slee/facilities/profile");
            ProfileTable profileTable = profileFacility.getProfileTable(PROFILE_TABLE_NAME);
            ReadOnlyTestsProfileLocal profileLocal = null;
            switch (operationID) {
                case 0: {
                    ReadOnlyTestsProfileCMP profileCMP = this.getProfileCMP(new ProfileID(PROFILE_TABLE_NAME, PROFILE_NAME));
                    try {
                        profileCMP.setValue("newValue");
                        this.sendResult(false, 1110071, "Set accessor method on ProfileCMP interface was successful but should have failed as profile spec is marked as read-only.");
                    }
                    catch (UnsupportedOperationException e) {
                        this.sendResult(true, 1110625, "Caught expected exception when setting new profile value via ProfileCMP interface: " + e.getClass().getName());
                    }
                    catch (Exception e) {
                        this.sendResult(false, 1110625, "Wrong type of exception received: " + e.getClass().getName() + " Expected: java.lang.UnsupportedOperationException");
                    }
                    break;
                }
                case 1: {
                    profileLocal = (ReadOnlyTestsProfileLocal)profileTable.find(PROFILE_NAME);
                    try {
                        profileLocal.setValue("newValue");
                        this.sendResult(false, 1110071, "Set accessor method on ProfileLocal interface was successful but should have failed as profile spec is marked as read-only.");
                    }
                    catch (TransactionRolledbackLocalException e) {
                        this.sendLogMsgCall("Caught expected exception when setting new profile value via ProfileLocal interface: " + ((Object)((Object)e)).getClass().getName());
                    }
                    catch (Exception e) {
                        this.sendResult(false, 1110071, "Wrong type of exception received: " + e.getClass().getName() + " Expected: javax.slee.TransactionRolledbackLocalException");
                    }
                    if (!this.getSbbContext().getRollbackOnly()) {
                        this.sendResult(false, 1110072, "Current TXN context should have been marked for rollback as the raised ReadOnlyProfileException propagated unhandled out of the Profile object.");
                        break;
                    }
                    this.sendResult(true, 1110071, "PROF_LOCAL_SET completed as expected.");
                    break;
                }
                case 2: {
                    profileLocal = (ReadOnlyTestsProfileLocal)profileTable.find(PROFILE_NAME);
                    try {
                        profileLocal.localSetValue("newValue");
                        this.sendResult(false, 1110071, "Invoking business method on ProfileLocal interface that indirectly calls CMP set accessor was successful but should have failed as profile spec is marked as read-only.");
                    }
                    catch (TransactionRolledbackLocalException e) {
                        this.sendResult(true, 1110071, "Caught expected exception when setting new profile value indirectly via business method on ProfileLocal interface: " + ((Object)((Object)e)).getClass().getName());
                    }
                    catch (Exception e) {
                        this.sendResult(false, 1110071, "Wrong type of exception received: " + e.getClass().getName() + " Expected: javax.slee.TransactionRolledbackLocalException");
                    }
                    break;
                }
                case 3: {
                    try {
                        profileTable.create(PROFILE_NAME2);
                        this.sendResult(false, 1110073, "Creating profile ReadOnlyIsTrueTestsSbbProfile2 via ProfileTable interface  was successful but should have failed as profile spec is marked as read-only.");
                    }
                    catch (ReadOnlyProfileException e) {
                        this.sendResult(true, 1110073, "Caught expected exception when creating profile via ProfileTable interface: " + ((Object)((Object)e)).getClass().getName());
                    }
                    catch (Exception e) {
                        this.sendResult(false, 1110073, "Wrong type of exception received: " + e.getClass().getName() + " Expected: javax.slee.profile.ReadOnlyProfileException");
                    }
                    break;
                }
                case 4: {
                    try {
                        profileTable.remove(PROFILE_NAME);
                        this.sendResult(false, 1110073, "Removing profile ReadOnlyIsTrueTestsSbbProfile via ProfileTable interface  was successful but should have failed as profile spec is marked as read-only.");
                    }
                    catch (ReadOnlyProfileException e) {
                        this.sendResult(true, 1110073, "Caught expected exception when removing profile via ProfileTable interface: " + ((Object)((Object)e)).getClass().getName());
                    }
                    catch (Exception e) {
                        this.sendResult(false, 1110073, "Wrong type of exception received: " + e.getClass().getName() + " Expected: javax.slee.profile.ReadOnlyProfileException");
                    }
                    break;
                }
                case 5: {
                    try {
                        profileLocal = (ReadOnlyTestsProfileLocal)profileTable.find(PROFILE_NAME);
                        profileLocal.remove();
                        this.sendResult(false, 1110074, "Removing profile ReadOnlyIsTrueTestsSbbProfile via ProfileLocal interface  was successful but should have failed as profile spec is marked as read-only.");
                        break;
                    }
                    catch (TransactionRolledbackLocalException e) {
                        this.sendResult(true, 1110074, "Caught expected exception when removing profile via ProfileLocal interface: " + ((Object)((Object)e)).getClass().getName());
                        break;
                    }
                    catch (Exception e) {
                        this.sendResult(false, 1110074, "Wrong type of exception received: " + e.getClass().getName() + " Expected: javax.slee.TransactionRolledbackLocalException");
                    }
                }
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    public abstract ReadOnlyTestsProfileCMP getProfileCMP(ProfileID var1) throws UnrecognizedProfileTableNameException, UnrecognizedProfileNameException;
}

