/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.readonly;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.sbbutils.events.TCKSbbEvent;
import com.opencloud.sleetck.lib.sbbutils.events.TCKSbbEventImpl;
import com.opencloud.sleetck.lib.sbbutils.events2.SbbBaseMessageComposer;
import com.opencloud.sleetck.lib.sbbutils.events2.SendResultEvent;
import com.opencloud.sleetck.lib.testsuite.profiles.readonly.ReadOnlyTestsProfileCMP;
import java.util.HashMap;
import javax.naming.Context;
import javax.slee.ActivityContextInterface;
import javax.slee.Address;
import javax.slee.profile.ProfileFacility;
import javax.slee.profile.ProfileID;
import javax.slee.profile.ProfileTable;
import javax.slee.profile.UnrecognizedProfileNameException;
import javax.slee.profile.UnrecognizedProfileTableNameException;

public abstract class Test1110069Sbb
extends BaseTCKSbb {
    public static final String PROFILE_TABLE_NAME = "Test1110069ProfileTable";
    public static final String PROFILE_NAME = "Test1110069Profile";

    private void sendLogMsgCall(String msg) {
        HashMap map = SbbBaseMessageComposer.getLogMsg(msg);
        try {
            TCKSbbUtils.getResourceInterface().callTest(map);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void sendResult(boolean result, int id, String msg, ActivityContextInterface aci) {
        HashMap map = SbbBaseMessageComposer.getSetResultMsg(result, id, msg);
        this.setResult(map);
        this.fireSendResultEvent(new SendResultEvent(), aci, null);
    }

    public void onSendResultEvent(SendResultEvent event, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.getResourceInterface().sendSbbMessage(this.getResult());
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            this.sendLogMsgCall("Received TCKResourceEventX1.");
            this.fireTCKSbbEvent(new TCKSbbEventImpl(event.getMessage()), aci, null);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKSbbEvent(TCKSbbEvent event, ActivityContextInterface aci) {
        try {
            Context env = TCKSbbUtils.getSbbEnvironment();
            ProfileFacility profileFacility = (ProfileFacility)env.lookup("slee/facilities/profile");
            this.sendLogMsgCall("Obtained ProfileFacility from naming context.");
            ProfileTable profileTable = profileFacility.getProfileTable(PROFILE_TABLE_NAME);
            this.sendLogMsgCall("Obtained ProfileTable object through Profile Facility.");
            String msg = (String)event.getMessage();
            if (msg.equals("Create")) {
                ReadOnlyTestsProfileCMP profileCMP = (ReadOnlyTestsProfileCMP)profileTable.create(PROFILE_NAME);
                if (profileCMP == null) {
                    TCKSbbUtils.handleException(new TCKTestErrorException("profileTable.create(PROFILE_NAME) returned null when it shouldn't have."));
                    return;
                }
                this.sendLogMsgCall("Created profile Test1110069Profile");
                this.fireTCKSbbEvent(new TCKSbbEventImpl("Update"), aci, null);
            } else if (msg.equals("Update")) {
                ReadOnlyTestsProfileCMP profileCMP = (ReadOnlyTestsProfileCMP)profileTable.find(PROFILE_NAME);
                profileCMP.setValue("newValue");
                this.sendLogMsgCall("Set new value for profile attribute.");
                this.fireTCKSbbEvent(new TCKSbbEventImpl("Check"), aci, null);
            } else if (msg.equals("Check")) {
                ReadOnlyTestsProfileCMP profileCMP = (ReadOnlyTestsProfileCMP)profileTable.find(PROFILE_NAME);
                if (!profileCMP.getValue().equals("newValue")) {
                    this.sendResult(false, 1110069, "Failed to use set/get accessor methods properly.", aci);
                    return;
                }
                this.sendLogMsgCall("Checked that new value has been successfully set and could be obtained by 'get' accessor.");
                this.fireTCKSbbEvent(new TCKSbbEventImpl("UpdateViaCMP"), aci, null);
            } else if (msg.equals("UpdateViaCMP")) {
                ReadOnlyTestsProfileCMP profileCMP = this.getProfileCMP(new ProfileID(PROFILE_TABLE_NAME, PROFILE_NAME));
                profileCMP.setValue("newValue2");
                this.sendLogMsgCall("Set new value for profile attribute via CMP interface.");
                this.fireTCKSbbEvent(new TCKSbbEventImpl("CheckViaCMP"), aci, null);
            } else if (msg.equals("CheckViaCMP")) {
                ReadOnlyTestsProfileCMP profileCMP = this.getProfileCMP(new ProfileID(PROFILE_TABLE_NAME, PROFILE_NAME));
                if (!profileCMP.getValue().equals("newValue2")) {
                    this.sendResult(false, 1110086, "Failed to use set/get accessor methods via ProfileCMP object properly.", aci);
                    return;
                }
                this.sendLogMsgCall("Checked that new value has been successfully set and could be obtained by 'get' accessor via ProfileCMP interface.");
                this.fireTCKSbbEvent(new TCKSbbEventImpl("Remove"), aci, null);
            } else if (msg.equals("Remove")) {
                boolean res = profileTable.remove(PROFILE_NAME);
                if (!res) {
                    this.sendResult(false, 1110069, "Sbb failed to remove profile Test1110069Profile", aci);
                    return;
                }
                this.sendLogMsgCall("ProfileTable object reports successful removal of profile table Test1110069Profile");
                this.fireTCKSbbEvent(new TCKSbbEventImpl("CheckRemove"), aci, null);
            } else if (msg.equals("CheckRemove")) {
                ReadOnlyTestsProfileCMP profileCMP = (ReadOnlyTestsProfileCMP)profileTable.find(PROFILE_NAME);
                if (profileCMP != null) {
                    this.sendResult(false, 1110069, "Profile Test1110069Profile was not removed correctly.", aci);
                    return;
                }
                this.sendLogMsgCall("Check whether profile was really removed after TXN committed was successful.");
                this.sendResult(true, 1110069, "Test successful", aci);
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public abstract void fireTCKSbbEvent(TCKSbbEvent var1, ActivityContextInterface var2, Address var3);

    public abstract void fireSendResultEvent(SendResultEvent var1, ActivityContextInterface var2, Address var3);

    public abstract void setResult(HashMap var1);

    public abstract HashMap getResult();

    public abstract ReadOnlyTestsProfileCMP getProfileCMP(ProfileID var1) throws UnrecognizedProfileTableNameException, UnrecognizedProfileNameException;
}

