/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.readonly;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.sbbutils.events2.SbbMessageAdapter;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;

public class Test1110094Test
extends AbstractSleeTCKTest {
    private static final String SPEC_NAME = "Test1110094Profile";
    private static final String SPEC_VERSION = "1.0";
    private static final int TEST_ID = 1110094;
    private ProfileUtils profileUtils;
    private FutureResult result;

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils().getLog());
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID specID = new ProfileSpecificationID(SPEC_NAME, "jain.slee.tck", SPEC_VERSION);
        profileProvisioning.createProfileTable(specID, "Test1110094ProfileTable");
        this.getLog().fine("Added profile table Test1110094ProfileTable");
        ObjectName profile = profileProvisioning.createProfile("Test1110094ProfileTable", SPEC_NAME);
        ProfileMBeanProxy profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        this.getLog().fine("Created profile Test1110094Profile for profile table Test1110094ProfileTable");
        profileProxy.commitProfile();
        profileProxy.closeProfile();
        this.getLog().fine("Commit and close profile Test1110094Profile");
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(this.getClass().getName());
        this.getLog().fine("About to fire TCKResourceEventX.X1 event to the Sbb");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", null, activityID, null);
        return this.result.waitForResultOrFail(this.utils().getTestTimeout(), "Timeout waiting for test result", 1110094);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.profileUtils = new ProfileUtils(this.utils());
        this.setResourceListener(new SbbMessageAdapter(){

            public Logable getLog() {
                return Test1110094Test.this.utils().getLog();
            }

            public void onSbbLogCall(String msg) {
                Test1110094Test.this.sbbLogCall(msg);
            }

            public void onSetPassed(int id, String msg) {
                Test1110094Test.this.setPassed(id, msg);
            }

            public void onSetFailed(int id, String msg) {
                Test1110094Test.this.setFailed(id, msg);
            }

            public void onSetException(Exception e) {
                Test1110094Test.this.setException(e);
            }
        });
    }

    public void tearDown() throws Exception {
        try {
            this.profileUtils.removeProfileTable("Test1110094ProfileTable");
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }

    public void sbbLogCall(String msg) {
        this.getLog().fine("Sbb wants to log: " + msg);
    }

    public void setPassed(int id, String msg) {
        this.result.setPassed();
    }

    public void setFailed(int id, String msg) {
        this.result.setFailed(id, msg);
    }

    public void setException(Exception e) {
        this.result.setError(e);
    }
}

