/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import com.opencloud.sleetck.lib.rautils.MessageHandlerRegistry;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.UOID;
import com.opencloud.sleetck.lib.testsuite.resource.TCKMessage;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ResourceManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ResourceUsageMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import com.opencloud.util.Future;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.slee.ComponentID;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.ResourceAdaptorID;

public class BaseResourceTest
extends AbstractSleeTCKTest {
    protected static final String PROFILE_TABLE_NAME_PARAM = "profileTableName";
    protected static final String PROFILE_SPEC_NAME_PARAM = "profileSpecName";
    protected static final String PROFILE_SPEC_VERSION = "1.1";
    protected static final String RESOURCE_LINK_NAME_PARAM = "resourceLinkName";
    protected static final String USAGE_SET_NAME_PARAM = "usageParameterSetName";
    protected static final String SKIP_RA_SETUP_PARAM = "skipRASetup";
    protected RMIObjectChannel in;
    protected MessageHandlerRegistry out;
    protected static final UOID testUID = UOID.createUOID();
    private static int nextMessageID = 0;
    private String profileTableName;
    private String profileSpecName;
    private String raLinkName;
    private String serviceDUPath;
    private String raDUPath;
    private String raEntityName;
    private String usageSetName;
    private boolean skipRASetup = false;

    public void setUp() throws Exception {
        this.in = this.utils().getRMIObjectChannel();
        this.out = this.utils().getMessageHandlerRegistry();
        this.profileTableName = this.utils().getTestParams().getProperty(PROFILE_TABLE_NAME_PARAM);
        this.profileSpecName = this.utils().getTestParams().getProperty(PROFILE_SPEC_NAME_PARAM);
        this.raLinkName = this.utils().getTestParams().getProperty(RESOURCE_LINK_NAME_PARAM);
        this.serviceDUPath = this.utils().getTestParams().getProperty("serviceDUPath");
        this.raDUPath = this.utils().getTestParams().getProperty("resourceDUPath");
        this.usageSetName = this.utils().getTestParams().getProperty(USAGE_SET_NAME_PARAM);
        this.skipRASetup = "true".equalsIgnoreCase(this.utils().getTestParams().getProperty(SKIP_RA_SETUP_PARAM));
        ResourceManagementMBeanProxy resourceMBean = this.utils().getResourceManagementMBeanProxy();
        DeploymentMBeanProxy deploymentMBean = this.utils().getDeploymentMBeanProxy();
        ServiceManagementMBeanProxy serviceMBean = this.utils().getServiceManagementMBeanProxy();
        ResourceAdaptorID resourceAdaptorID = null;
        if (this.raDUPath == null) {
            throw new TCKTestErrorException("Missing test parameter: resourceDUPath");
        }
        this.getLog().info("Installing resource adaptor: " + this.raDUPath);
        DeployableUnitID raDUID = this.utils().install(this.raDUPath);
        this.getLog().info("Determining resource adaptor and entity names.");
        resourceAdaptorID = this.getResourceAdaptorID(raDUID);
        String raName = resourceAdaptorID.getName();
        this.raEntityName = raName + "_Entity";
        this.getLog().info("Resource Adaptor = \"" + resourceAdaptorID + "\", Resource Adaptor Entity = " + this.raEntityName);
        if (this.profileTableName != null && this.profileSpecName != null) {
            this.getLog().info("Creating profile table '" + this.profileTableName + "' from profile specification '" + this.profileSpecName + "'");
            ProfileUtils profileUtils = new ProfileUtils(this.utils());
            ProfileProvisioningMBeanProxy profileMBean = profileUtils.getProfileProvisioningProxy();
            ProfileSpecificationID profileSpecID = new ProfileSpecificationID(this.profileSpecName, "jain.slee.tck", PROFILE_SPEC_VERSION);
            profileMBean.createProfileTable(profileSpecID, this.profileTableName);
        }
        if (!this.skipRASetup) {
            this.getLog().info("Creating Resource Adaptor Entity: " + this.raEntityName);
            resourceMBean.createResourceAdaptorEntity(resourceAdaptorID, this.raEntityName, new ConfigProperties());
            if (this.usageSetName != null) {
                this.getLog().info("Creating Usage Parameter Set: " + this.usageSetName);
                ResourceUsageMBeanProxy resourceUsageMBean = this.utils().getResourceUsageMBeanProxy(this.raEntityName);
                resourceUsageMBean.createUsageParameterSet(this.usageSetName);
            }
            if (this.raLinkName != null) {
                this.getLog().info("Binding RA Entity '" + this.raEntityName + "' to link name '" + this.raLinkName + "'");
                resourceMBean.bindLinkName(this.raEntityName, this.raLinkName);
            }
        }
        if (this.serviceDUPath != null) {
            String absolutePath = this.utils().getDeploymentUnitURL(this.serviceDUPath);
            this.getLog().info("Installing service: " + absolutePath);
            DeployableUnitID serviceDUID = deploymentMBean.install(absolutePath);
            ServiceID serviceID = this.getServiceID(serviceDUID);
            serviceMBean.activate(serviceID);
        }
        if (!this.skipRASetup && this.raEntityName != null) {
            this.getLog().info("Activating Resource Adaptor Entity: " + this.raEntityName);
            resourceMBean.activateResourceAdaptorEntity(this.raEntityName);
        }
    }

    public void tearDown() throws Exception {
        Exception error;
        block30: {
            block29: {
                block28: {
                    block27: {
                        ResourceManagementMBeanProxy resourceMBean;
                        block24: {
                            DeploymentMBeanProxy deploymentMBean;
                            block23: {
                                resourceMBean = this.utils().getResourceManagementMBeanProxy();
                                deploymentMBean = this.utils().getDeploymentMBeanProxy();
                                error = null;
                                if (!this.skipRASetup) {
                                    try {
                                        this.getLog().info("Deactivating Resource Adaptor Entity: " + this.raEntityName);
                                        this.utils().deactivateResourceAdaptorEntity(this.raEntityName);
                                    }
                                    catch (Exception e) {
                                        this.getLog().error(e);
                                        if (error != null) break block23;
                                        error = e;
                                    }
                                }
                            }
                            if (this.serviceDUPath != null) {
                                try {
                                    this.getLog().info("Uninstalling service: " + this.serviceDUPath);
                                    String relativePath = this.utils().getTestParams().getProperty("serviceDUPath");
                                    String serviceDuPath = this.utils().getDeploymentUnitURL(relativePath);
                                    DeployableUnitID serviceDUID = deploymentMBean.getDeployableUnit(serviceDuPath);
                                    ServiceID serviceID = this.getServiceID(serviceDUID);
                                    this.utils().deactivateService(serviceID);
                                    deploymentMBean.uninstall(serviceDUID);
                                }
                                catch (Exception e) {
                                    this.getLog().error(e);
                                    if (error != null) break block24;
                                    error = e;
                                }
                            }
                        }
                        if (!this.skipRASetup) {
                            block26: {
                                block25: {
                                    if (this.raLinkName != null) {
                                        try {
                                            this.getLog().info("Unbinding RA Link Name: " + this.raLinkName);
                                            resourceMBean.unbindLinkName(this.raLinkName);
                                        }
                                        catch (Exception e) {
                                            this.getLog().error(e);
                                            if (error != null) break block25;
                                            error = e;
                                        }
                                    }
                                }
                                if (this.usageSetName != null) {
                                    try {
                                        this.getLog().info("Removing Usage Parameter Set: " + this.usageSetName);
                                        ResourceUsageMBeanProxy resourceUsageMBean = this.utils().getResourceUsageMBeanProxy(this.raEntityName);
                                        resourceUsageMBean.removeUsageParameterSet(this.usageSetName);
                                    }
                                    catch (Exception e) {
                                        this.getLog().error(e);
                                        if (error != null) break block26;
                                        error = e;
                                    }
                                }
                            }
                            try {
                                this.getLog().info("Removing Resource Adaptor Entity: " + this.raEntityName);
                                resourceMBean.removeResourceAdaptorEntity(this.raEntityName);
                            }
                            catch (Exception e) {
                                this.getLog().error(e);
                                if (error != null) break block27;
                                error = e;
                            }
                        }
                    }
                    try {
                        if (this.profileTableName != null) {
                            this.getLog().info("Removing profile table: " + this.profileTableName);
                            ProfileUtils profileUtils = new ProfileUtils(this.utils());
                            ProfileProvisioningMBeanProxy profileMBean = profileUtils.getProfileProvisioningProxy();
                            profileMBean.removeProfileTable(this.profileTableName);
                        }
                    }
                    catch (Exception e) {
                        this.getLog().error(e);
                        if (error != null) break block28;
                        error = e;
                    }
                }
                try {
                    this.utils().removeRAEntities();
                }
                catch (Exception e) {
                    this.getLog().error(e);
                    if (error != null) break block29;
                    error = e;
                }
            }
            try {
                super.tearDown();
            }
            catch (Exception e) {
                this.getLog().error(e);
                if (error != null) break block30;
                error = e;
            }
        }
        if (error != null) {
            throw new TCKTestErrorException("An unexpected exception was thrown during test: ", error);
        }
    }

    protected void sendMessage(int method, Object argument, MessageHandler customMessageHandler, int sequenceID) {
        TCKMessage message = new TCKMessage(testUID, sequenceID, method, argument);
        this.getLog().info("Sending message to test component(s): " + message);
        try {
            this.in.setMessageHandler(customMessageHandler);
            this.out.sendMessage(message);
        }
        catch (RemoteException e) {
            this.getLog().error(e);
        }
    }

    protected HashMap sendMessage(int method) {
        return this.sendMessage(method, null);
    }

    protected HashMap sendMessage(int method, Object argument) {
        TCKMessage message = new TCKMessage(testUID, this.nextMessageID(), method, argument);
        this.getLog().info("Sending message to test component(s): " + message);
        int expectedResponse = message.getSequenceID();
        ResponseListener listener = new ResponseListener(expectedResponse);
        try {
            this.in.setMessageHandler(listener);
            this.out.sendMessage(message);
        }
        catch (RemoteException e) {
            this.getLog().error(e);
            return null;
        }
        return listener.getResultMap();
    }

    protected TCKMessage[] castMessages(Object[] objects) {
        TCKMessage[] messages = new TCKMessage[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            messages[i] = (TCKMessage)objects[i];
        }
        return messages;
    }

    protected ServiceID getServiceID(DeployableUnitID duID) throws TCKTestErrorException {
        DeployableUnitDescriptor descriptor;
        try {
            descriptor = this.utils().getDeploymentMBeanProxy().getDescriptor(duID);
        }
        catch (Exception e) {
            throw new TCKTestErrorException("An error occured while attempting to find a ServiceID contained in DU: " + duID, e);
        }
        ComponentID[] components = descriptor.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ServiceID)) continue;
            return (ServiceID)components[i];
        }
        return null;
    }

    protected ResourceAdaptorID getResourceAdaptorID(DeployableUnitID duID) throws TCKTestErrorException {
        DeployableUnitDescriptor descriptor;
        try {
            descriptor = this.utils().getDeploymentMBeanProxy().getDescriptor(duID);
        }
        catch (Exception e) {
            throw new TCKTestErrorException("An error occured while attempting to find a ResourceAdaptorID contained in DU: " + duID, e);
        }
        ComponentID[] components = descriptor.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ResourceAdaptorID)) continue;
            return (ResourceAdaptorID)components[i];
        }
        return null;
    }

    protected String getResourceAdaptorEntityName() {
        return this.raEntityName;
    }

    protected int nextMessageID() {
        return nextMessageID++;
    }

    protected void checkResult(Object result, int assertion) throws TCKTestErrorException, TCKTestFailureException {
        if (result instanceof Exception) {
            throw new TCKTestFailureException(assertion, "Unexpected exception thrown during test:", (Exception)result);
        }
        if (!Boolean.TRUE.equals(result)) {
            throw new TCKTestErrorException("Unexpected result received from test component: " + result);
        }
    }

    protected void checkResult(Object result, int assertion, String failureMessage) throws TCKTestErrorException, TCKTestFailureException {
        if (result instanceof Exception) {
            throw new TCKTestFailureException(assertion, "Unexpected exception thrown during test:", (Exception)result);
        }
        if (Boolean.FALSE.equals(result)) {
            throw new TCKTestFailureException(assertion, failureMessage);
        }
        if (!Boolean.TRUE.equals(result)) {
            throw new TCKTestErrorException("Unexpected result received from test component: " + result);
        }
    }

    protected void checkResult(HashMap results, String resultsField, int assertion, String failureMessage) throws TCKTestErrorException, TCKTestFailureException {
        this.getLog().fine("Checking result '" + resultsField + "' for test success status.");
        if (results == null) {
            throw new TCKTestErrorException("No results were returned from test component.");
        }
        Object result = results.get(resultsField);
        this.checkResult(result, assertion, failureMessage);
        this.getLog().fine("Result passed.");
    }

    protected class MultiResponseListener
    implements MessageHandler {
        protected HashMap futures = new HashMap();
        protected int expectedResponse = -1;

        public MultiResponseListener(int sequenceID) {
            this.expectedResponse = sequenceID;
        }

        public boolean handleMessage(Object obj) throws RemoteException {
            BaseResourceTest.this.getLog().info("Received message from test component: " + obj);
            if (!(obj instanceof TCKMessage)) {
                BaseResourceTest.this.getLog().error("Unhandled message type: " + obj);
                return false;
            }
            TCKMessage message = (TCKMessage)obj;
            if (message.getSequenceID() != this.expectedResponse) {
                return true;
            }
            HashMap results = (HashMap)message.getArgument();
            if (results == null) {
                return true;
            }
            Set keys = results.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Future future = this.getFuture(key);
                if (future == null || future.isSet()) continue;
                future.setValue(results.get(key));
            }
            return true;
        }

        public void addExpectedResult(String name) {
            this.futures.put(name, new Future());
        }

        public Object getResult(String name) {
            Object result;
            if (this.futures.get(name) == null) {
                throw new IllegalArgumentException("Unknown result name (not set as expected result): " + name);
            }
            try {
                Future future = (Future)this.futures.get(name);
                result = future.getValue(BaseResourceTest.this.utils().getTestTimeout());
            }
            catch (Future.TimeoutException e) {
                return null;
            }
            return result;
        }

        protected Future getFuture(String name) {
            return (Future)this.futures.get(name);
        }
    }

    protected class ResponseListener
    implements MessageHandler {
        private int expectedResponse = -1;
        private Future future = new Future();

        public ResponseListener(int expectedResponse) {
            this.expectedResponse = expectedResponse;
        }

        public boolean handleMessage(Object obj) throws RemoteException {
            BaseResourceTest.this.getLog().info("Received message from test component: " + obj);
            if (!(obj instanceof TCKMessage)) {
                BaseResourceTest.this.getLog().error("Unhandled message type: " + obj);
                return false;
            }
            TCKMessage message = (TCKMessage)obj;
            if (message.getSequenceID() != this.expectedResponse || this.future.isSet()) {
                return true;
            }
            this.future.setValue(message.getArgument());
            return true;
        }

        public HashMap getResultMap() {
            HashMap result;
            try {
                result = (HashMap)this.future.getValue(BaseResourceTest.this.utils().getTestTimeout());
            }
            catch (Future.TimeoutException e) {
                return null;
            }
            return result;
        }
    }
}

