/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource.context;

import com.opencloud.sleetck.lib.rautils.BaseTCKRA;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import com.opencloud.sleetck.lib.rautils.MessageHandlerRegistry;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.resource.adaptor11.TCKActivityHandleImpl;
import com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent;
import com.opencloud.sleetck.lib.testsuite.resource.SimpleProfileTable;
import com.opencloud.sleetck.lib.testsuite.resource.SimpleSbbInterface;
import com.opencloud.sleetck.lib.testsuite.resource.SimpleUsageParameterInterface;
import com.opencloud.sleetck.lib.testsuite.resource.TCKMessage;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Timer;
import javax.slee.EventTypeID;
import javax.slee.ServiceID;
import javax.slee.facilities.AlarmFacility;
import javax.slee.facilities.AlarmLevel;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.profile.ProfileTable;
import javax.slee.profile.UnrecognizedProfileTableNameException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.ResourceAdaptorID;
import javax.slee.resource.ResourceAdaptorTypeID;
import javax.slee.resource.SleeEndpoint;
import javax.slee.transaction.SleeTransactionManager;
import javax.slee.usage.UnrecognizedUsageParameterSetNameException;

public class ContextResourceAdaptor
extends BaseTCKRA
implements SimpleSbbInterface {
    private boolean isConfigured = false;
    private MessageHandler messageHandler = null;

    public void raConfigure(ConfigProperties properties) {
        this.isConfigured = true;
    }

    public void raUnconfigure() {
        this.isConfigured = false;
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext context) {
        super.setResourceAdaptorContext(context);
        this.setTracer(context.getTracer("Context RA"));
        try {
            MessageHandlerRegistry registry = TCKRAUtils.lookupMessageHandlerRegistry();
            this.messageHandler = new ContextMessageListener(this);
            registry.registerMessageHandler(this.messageHandler);
        }
        catch (Exception e) {
            this.getLog().severe("An error occured during setResourceAdaptorContext()", e);
        }
    }

    public void unsetResourceAdaptorContext() {
        try {
            MessageHandlerRegistry registry = TCKRAUtils.lookupMessageHandlerRegistry();
            if (this.messageHandler != null) {
                registry.unregisterMessageHandler(this.messageHandler);
            }
        }
        catch (Exception e) {
            this.getLog().severe("An error occured during unsetResourceAdaptorContext()", e);
        }
        this.setTracer(null);
        super.unsetResourceAdaptorContext();
    }

    private boolean isConfigured() {
        return this.isConfigured;
    }

    private void sendContextMessage(int sequenceID, int method, Object argument) {
        this.sendMessage(new TCKMessage(this.getRAUID(), sequenceID, method, argument));
    }

    private ResourceAdaptorContext getContext() {
        return this.getResourceAdaptorContext();
    }

    private class ContextMessageListener
    extends UnicastRemoteObject
    implements MessageHandler {
        private transient ContextResourceAdaptor ra = null;

        public ContextMessageListener(ContextResourceAdaptor ra) throws RemoteException {
            this.ra = ra;
        }

        public boolean handleMessage(Object obj) throws RemoteException {
            if (!ContextResourceAdaptor.this.isConfigured()) {
                return false;
            }
            this.ra.getLog().info("Received message from test: " + obj.toString());
            TCKMessage message = (TCKMessage)obj;
            int sequenceID = message.getSequenceID();
            HashMap<String, Object> results = new HashMap<String, Object>();
            switch (message.getMethod()) {
                case 35: {
                    String entityName = null;
                    entityName = this.ra.getContext().getEntityName();
                    results.put("result", entityName);
                    ContextResourceAdaptor.this.sendContextMessage(sequenceID, 35, results);
                    break;
                }
                case 33: {
                    results.put("result", Boolean.TRUE);
                    try {
                        SleeEndpoint endpoint = this.ra.getContext().getSleeEndpoint();
                        if (endpoint == null) {
                            results.put("result", "ResourceAdaptorContext.getSleeEndpoint() returned null");
                        }
                    }
                    catch (Exception e) {
                        results.put("result", e);
                    }
                    ContextResourceAdaptor.this.sendContextMessage(sequenceID, 33, results);
                    break;
                }
                case 26: {
                    results.put("result", Boolean.TRUE);
                    try {
                        AlarmFacility alarmFacility = this.ra.getContext().getAlarmFacility();
                        if (alarmFacility == null) {
                            results.put("result", Boolean.FALSE);
                        } else {
                            String alarmID = alarmFacility.raiseAlarm("TestAlarm", "1115179", AlarmLevel.CRITICAL, "Alarm message");
                        }
                    }
                    catch (Exception e) {
                        results.put("result", e);
                    }
                    ContextResourceAdaptor.this.sendContextMessage(sequenceID, 26, results);
                    break;
                }
                case 37: {
                    Tracer tracer;
                    results.put("result1", Boolean.TRUE);
                    try {
                        tracer = this.ra.getContext().getTracer("ContextResourceAdaptor Test Tracer");
                        if (tracer == null) {
                            results.put("result1", "ResourceAdaptorContext.getTracer() returned null");
                        }
                    }
                    catch (Exception e) {
                        results.put("result1", e);
                    }
                    try {
                        tracer = this.ra.getContext().getTracer(null);
                    }
                    catch (Exception e) {
                        results.put("result2", e);
                    }
                    try {
                        tracer = this.ra.getContext().getTracer("com..mycompany");
                    }
                    catch (Exception e) {
                        results.put("result3", e);
                    }
                    ContextResourceAdaptor.this.sendContextMessage(sequenceID, 37, results);
                    break;
                }
                case 28: {
                    results.put("result", Boolean.TRUE);
                    try {
                        EventLookupFacility elf = this.ra.getContext().getEventLookupFacility();
                        if (elf == null) {
                            results.put("result", "ResourceAdaptorContext.getEventLookupFacility() returned null");
                        }
                    }
                    catch (Exception e) {
                        results.put("result", e);
                    }
                    ContextResourceAdaptor.this.sendContextMessage(sequenceID, 28, results);
                    break;
                }
                case 34: {
                    results.put("result", Boolean.TRUE);
                    try {
                        SleeTransactionManager stm = this.ra.getContext().getSleeTransactionManager();
                        if (stm == null) {
                            results.put("result", "ResourceAdaptorContext.getSleeTransactionManager() returned null");
                        }
                    }
                    catch (Exception e) {
                        results.put("result", e);
                    }
                    ContextResourceAdaptor.this.sendContextMessage(sequenceID, 34, results);
                    break;
                }
                case 36: {
                    results.put("result1", Boolean.TRUE);
                    Timer t = null;
                    try {
                        t = this.ra.getContext().getTimer();
                        if (t == null) {
                            results.put("result", "ResourceAdaptorContext.getTimer() returned null");
                        }
                    }
                    catch (Exception e) {
                        results.put("result1", e);
                    }
                    if (t != null) {
                        results.put("result2", Boolean.TRUE);
                        try {
                            t.cancel();
                            results.put("result2", Boolean.FALSE);
                        }
                        catch (UnsupportedOperationException uoe) {
                        }
                        catch (Exception e) {
                            results.put("result2", e);
                        }
                    }
                    ContextResourceAdaptor.this.sendContextMessage(sequenceID, 36, results);
                    break;
                }
                case 31: {
                    results.put("result1", Boolean.TRUE);
                    ProfileTable table = null;
                    try {
                        table = this.ra.getContext().getProfileTable("TCKTestTable");
                        if (table == null) {
                            results.put("result", "ResourceAdaptorContext.getProfileTable(\"TestTableName\") returned null");
                        }
                    }
                    catch (Exception e) {
                        results.put("result1", e);
                    }
                    if (table != null) {
                        results.put("result2", Boolean.TRUE);
                        try {
                            SimpleProfileTable spt = (SimpleProfileTable)table;
                        }
                        catch (Exception e) {
                            results.put("result2", "ProfileTable retuned by ResourceAdaptorContext.getProfileTable(\"TestTableName\") could not be typecast correctly");
                        }
                    }
                    results.put("result3", Boolean.TRUE);
                    table = null;
                    try {
                        table = this.ra.getContext().getProfileTable(null);
                        results.put("result3", Boolean.FALSE);
                    }
                    catch (NullPointerException e) {
                    }
                    catch (Exception e) {
                        results.put("result3", e);
                    }
                    results.put("result4", Boolean.TRUE);
                    table = null;
                    try {
                        table = this.ra.getContext().getProfileTable("ATableWhichDoesNotExist");
                        results.put("result4", Boolean.FALSE);
                    }
                    catch (UnrecognizedProfileTableNameException e) {
                    }
                    catch (Exception e) {
                        results.put("result4", e);
                    }
                    ContextResourceAdaptor.this.sendContextMessage(sequenceID, 31, results);
                    break;
                }
                case 29: {
                    results.put("result1", Boolean.TRUE);
                    Object dups = null;
                    try {
                        dups = this.ra.getContext().getDefaultUsageParameterSet();
                        if (dups == null) {
                            results.put("result1", "ResourceAdaptorContext.getDefaultUsageParameterSet() returned null");
                        }
                    }
                    catch (Exception e) {
                        results.put("result1", e);
                    }
                    if (dups != null) {
                        results.put("result2", Boolean.TRUE);
                        try {
                            SimpleUsageParameterInterface supt = (SimpleUsageParameterInterface)dups;
                        }
                        catch (Exception e) {
                            results.put("result2", e);
                        }
                    }
                    ContextResourceAdaptor.this.sendContextMessage(sequenceID, 29, results);
                    break;
                }
                case 30: {
                    results.put("result1", Boolean.TRUE);
                    Object ups = null;
                    try {
                        ups = this.ra.getContext().getUsageParameterSet("TCKTestUsageParameterSet");
                        if (ups == null) {
                            results.put("result1", "ResourceAdaptorContext.getDefaultUsageParameterSet() returned null");
                        }
                    }
                    catch (Exception e) {
                        results.put("result1", e);
                    }
                    if (ups != null) {
                        results.put("result2", Boolean.TRUE);
                        try {
                            SimpleUsageParameterInterface supt = (SimpleUsageParameterInterface)ups;
                        }
                        catch (Exception e) {
                            results.put("result2", e);
                        }
                    }
                    results.put("result3", Boolean.TRUE);
                    try {
                        ups = this.ra.getContext().getUsageParameterSet(null);
                        results.put("result3", Boolean.FALSE);
                    }
                    catch (NullPointerException e) {
                    }
                    catch (Exception e) {
                        results.put("result3", e);
                    }
                    results.put("results4", Boolean.TRUE);
                    try {
                        ups = this.ra.getContext().getUsageParameterSet("AParameterSetWhichDoesNotExist");
                        results.put("results4", Boolean.FALSE);
                    }
                    catch (UnrecognizedUsageParameterSetNameException uupsne) {
                    }
                    catch (Exception e) {
                        results.put("results4", e);
                    }
                    ContextResourceAdaptor.this.sendContextMessage(sequenceID, 30, results);
                    break;
                }
                case 32: {
                    int value;
                    Integer assertion = (Integer)message.getArgument();
                    int n = value = assertion != null ? assertion : -1;
                    if (value == 1115206) {
                        results.put("result", Boolean.TRUE);
                        try {
                            ServiceID serviceID = this.ra.getContext().getInvokingService();
                            if (serviceID != null) {
                                results.put("result", serviceID);
                            }
                        }
                        catch (Exception e) {
                            results.put("result", e);
                        }
                        ContextResourceAdaptor.this.sendContextMessage(sequenceID, 32, results);
                        break;
                    }
                    if (value == 1115205) {
                        try {
                            EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
                            FireableEventType fireableEventType = this.ra.getContext().getEventLookupFacility().getFireableEventType(eventTypeID);
                            SleeEndpoint endpoint = this.ra.getContext().getSleeEndpoint();
                            TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 0);
                            endpoint.startActivity((ActivityHandle)handle, (Object)handle);
                            endpoint.fireEvent((ActivityHandle)handle, fireableEventType, (Object)new SimpleEvent(sequenceID), null, null);
                            endpoint.endActivity((ActivityHandle)handle);
                        }
                        catch (Exception e) {
                            this.ra.getLog().severe("An error occured firing SimpleEvent: ", e);
                            results.put("result2", e);
                            ContextResourceAdaptor.this.sendContextMessage(sequenceID, 32, results);
                        }
                        break;
                    }
                    this.ra.getLog().severe("TCK sent garbage to ContextResourceAdaptor while testing getInvokingService: argument=" + assertion);
                    break;
                }
                case 38: {
                    ResourceAdaptorID expectedID = new ResourceAdaptorID("TCK_Context_Test_RA", "jain.slee.tck", "1.1");
                    ResourceAdaptorID returnedID = ContextResourceAdaptor.this.getContext().getResourceAdaptor();
                    if (expectedID.equals((Object)returnedID)) {
                        this.ra.getLog().info("getResourceAdaptor() returned expected Resource Adaptor ID.");
                        results.put("result1", Boolean.TRUE);
                    } else {
                        this.ra.getLog().severe("getResourceAdaptor() returned unexpected Resource Adaptor ID - test failure.");
                        results.put("result1", Boolean.FALSE);
                    }
                    ContextResourceAdaptor.this.sendContextMessage(sequenceID, 38, results);
                    break;
                }
                case 39: {
                    ResourceAdaptorTypeID expectedType = new ResourceAdaptorTypeID("TCK_Simple_Resource_Type", "jain.slee.tck", "1.1");
                    ResourceAdaptorTypeID[] types = ContextResourceAdaptor.this.getContext().getResourceAdaptorTypes();
                    this.ra.getLog().info("Checking getResourceAdaptorTypes() returned a non-null value.");
                    if (types == null) {
                        this.ra.getLog().severe("getResourceAdaptorTypes() returned a null value - test failure");
                        results.put("result1", Boolean.FALSE);
                        ContextResourceAdaptor.this.sendContextMessage(sequenceID, 39, results);
                        break;
                    }
                    this.ra.getLog().info("getResourceAdaptorTypes() returned a non-null value");
                    results.put("result1", Boolean.TRUE);
                    this.ra.getLog().info("Checking getResourceAdaptorTypes() returned expected value.");
                    results.put("result2", Boolean.FALSE);
                    for (int i = 0; i < types.length; ++i) {
                        this.ra.getLog().info("Checking RA type: " + types[i]);
                        if (!expectedType.equals((Object)types[i])) {
                            this.ra.getLog().severe("Unexpected RA type found - test failure.");
                            results.put("result2", Boolean.FALSE);
                            break;
                        }
                        this.ra.getLog().info("Expected type found.");
                        results.put("result2", Boolean.TRUE);
                    }
                    ContextResourceAdaptor.this.sendContextMessage(sequenceID, 39, results);
                }
            }
            return true;
        }
    }
}

