/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource.endpoint;

import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.resource.BaseResourceTest;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitID;

public class Test1115232Test
extends BaseResourceTest {
    private static final int ASSERTION_ID = 1115232;

    public TCKTestResult run() throws Exception {
        int sequenceID = this.nextMessageID();
        BaseResourceTest.MultiResponseListener listener = new BaseResourceTest.MultiResponseListener(sequenceID);
        listener.addExpectedResult("result-ra1");
        listener.addExpectedResult("result-ra2");
        listener.addExpectedResult("result-sbb1a");
        listener.addExpectedResult("result-sbb1b");
        listener.addExpectedResult("result-sbb2");
        this.sendMessage(41, new Integer(1115232), listener, sequenceID);
        Object result1 = listener.getResult("result-ra1");
        this.checkResult(result1, 1115232);
        Object result2 = listener.getResult("result-ra2");
        this.checkResult(result2, 1115232, "Exception thrown while attempting to call endActivityTransacted() from an sbb event handler method");
        Object result3 = listener.getResult("result-sbb1a");
        this.checkResult(result3, 1115232, "Activity Context was unexpectedly ending before endActivityTrasacted() was called");
        Object result4 = listener.getResult("result-sbb1b");
        this.checkResult(result4, 1115232, "Activity Context failed to transition into the ending state after endActivityTrasacted() was called");
        Object result5 = listener.getResult("result-sbb2");
        this.checkResult(result5, 1115232, "Activity Context transition into ending state was not visible in a subsequent transaction");
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        super.setUp();
        try {
            DeploymentMBeanProxy deploymentMBean = this.utils().getDeploymentMBeanProxy();
            ServiceManagementMBeanProxy serviceMBean = this.utils().getServiceManagementMBeanProxy();
            String serviceDUPath = this.utils().getTestParams().getProperty("serviceDUPath2");
            String absolutePath = this.utils().getDeploymentUnitURL(serviceDUPath);
            this.getLog().info("Installing service: " + absolutePath);
            DeployableUnitID serviceDUID = deploymentMBean.install(absolutePath);
            ServiceID serviceID = this.getServiceID(serviceDUID);
            serviceMBean.activate(serviceID);
        }
        catch (Exception e) {
            this.getLog().error(e);
        }
    }

    public void tearDown() throws Exception {
        try {
            DeploymentMBeanProxy deploymentMBean = this.utils().getDeploymentMBeanProxy();
            String relativePath = this.utils().getTestParams().getProperty("serviceDUPath2");
            String serviceDuPath = this.utils().getDeploymentUnitURL(relativePath);
            this.getLog().info("Uninstalling service: " + serviceDuPath);
            DeployableUnitID serviceDUID = deploymentMBean.getDeployableUnit(serviceDuPath);
            ServiceID serviceID = this.getServiceID(serviceDUID);
            this.utils().deactivateService(serviceID);
            deploymentMBean.uninstall(serviceDUID);
        }
        catch (Exception e) {
            this.getLog().error(e);
        }
        super.tearDown();
    }
}

