/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource.endpoint;

import com.opencloud.sleetck.lib.rautils.UOID;
import com.opencloud.sleetck.lib.testsuite.resource.BaseResourceSbb;
import com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent;
import java.io.Serializable;
import java.util.HashMap;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.Address;

public abstract class Test1115277Sbb
extends BaseResourceSbb {
    private static final int ASSERTION_ID = 1115277;
    private static final UOID sbbUID = UOID.createUOID();

    public void onSimpleEvent(SimpleEvent event, ActivityContextInterface aci) {
        this.tracer.info("onSimpleEvent() event handler called with event: " + event);
        int sequenceID = event.getSequenceID();
        Object payload = event.getPayload();
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        if ("sbb".equals(payload)) {
            results.put("result-illegal-sbb", Boolean.TRUE);
            this.sendSbbMessage(sbbUID, sequenceID, 40, results);
            return;
        }
        if ("ra".equals(payload)) {
            results.put("result-illegal-ra", Boolean.TRUE);
            this.sendSbbMessage(sbbUID, sequenceID, 40, results);
            return;
        }
        this.tracer.info("Setting CMP field with initial event");
        this.setInitialEvent(event);
        try {
            this.getSbbInterface().executeTestLogic(new Integer(1115277));
            this.tracer.info("Checking ending state of Activity Context");
            if (aci.isEnding()) {
                this.tracer.info("Activity Context is correctly ending.");
                results.put("result-sbb1", Boolean.TRUE);
            } else {
                this.tracer.info("Activity Context is incorrectly not ending.");
                results.put("result-sbb1", Boolean.FALSE);
            }
            try {
                this.fireSimpleEvent(new SimpleEvent(sequenceID, "sbb"), aci, null);
            }
            catch (IllegalStateException e) {
                this.tracer.info("Ignoring exception thrown when trying to fire an event on ending activity", (Throwable)e);
            }
        }
        catch (Exception e) {
            results.put("result-sbb1", e);
        }
        this.sendSbbMessage(sbbUID, sequenceID, 40, results);
    }

    public abstract void fireSimpleEvent(SimpleEvent var1, ActivityContextInterface var2, Address var3);

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        this.tracer.info("onActivityEnd() event handler called with event: " + event);
        this.tracer.info("Getting initial event from CMP field");
        SimpleEvent initialEvent = this.getInitialEvent();
        int sequenceID = initialEvent.getSequenceID();
        if (sequenceID == -1) {
            return;
        }
        results.put("result-sbb2", Boolean.TRUE);
        this.sendSbbMessage(sbbUID, sequenceID, 40, results);
    }

    public abstract SimpleEvent getInitialEvent();

    public abstract void setInitialEvent(SimpleEvent var1);
}

