/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource.endpoint;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import com.opencloud.sleetck.lib.testsuite.resource.BaseResourceTest;
import com.opencloud.sleetck.lib.testsuite.resource.TCKMessage;
import com.opencloud.util.Future;
import java.rmi.RemoteException;
import java.util.HashMap;

public class Test1115308Test
extends BaseResourceTest {
    private static final int ASSERTION_ID = 1115308;

    public TCKTestResult run() throws Exception {
        int sequenceID = this.nextMessageID();
        ResponseListener listener = new ResponseListener(sequenceID);
        this.sendMessage(45, new Integer(1115308), listener, sequenceID);
        Object raResult = listener.getRAResult();
        Object eventsResult = listener.getEventsResult();
        if (raResult == null) {
            throw new TCKTestErrorException("Test timed out while waiting for response from test resource adaptor component");
        }
        if (eventsResult == null) {
            throw new TCKTestErrorException("Test timed out while waiting for event notifications from sbb");
        }
        if (raResult instanceof Exception) {
            throw new TCKTestFailureException(1115308, "An exception was thrown by test resource adaptor while firing an event on a new activity", (Exception)raResult);
        }
        if (!Boolean.TRUE.equals(raResult)) {
            throw new TCKTestErrorException("Unexpected result received from test resource adaptor component: " + raResult);
        }
        if (eventsResult instanceof Exception) {
            throw (Exception)eventsResult;
        }
        if (!Boolean.TRUE.equals(eventsResult)) {
            throw new TCKTestErrorException("Unexpected result received from event processing logic: " + eventsResult);
        }
        return TCKTestResult.passed();
    }

    private class ResponseListener
    implements MessageHandler {
        private Future eventsFuture = new Future();
        private Future raFuture = new Future();
        private int currentEventCount = 0;
        private int expectedResponse = -1;

        public ResponseListener(int expectedResponse) {
            this.expectedResponse = expectedResponse;
        }

        public boolean handleMessage(Object obj) throws RemoteException {
            Test1115308Test.this.getLog().info("Received message from test component: " + obj);
            if (!(obj instanceof TCKMessage)) {
                Test1115308Test.this.getLog().error("Unhandled message type: " + obj);
                return false;
            }
            TCKMessage message = (TCKMessage)obj;
            if (message.getSequenceID() != this.expectedResponse) {
                return true;
            }
            HashMap results = (HashMap)message.getArgument();
            Object raResult = results.get("result1");
            Object eventResult = results.get("result2");
            if (raResult != null && !this.raFuture.isSet()) {
                this.raFuture.setValue(raResult);
            } else if (eventResult != null && !this.eventsFuture.isSet()) {
                int nextEventID = this.currentEventCount + 1;
                int eventCount = (Integer)eventResult;
                Test1115308Test.this.getLog().info("Received notification for event '" + eventCount + "' (expecting event '" + nextEventID + "').");
                if (eventCount < nextEventID) {
                    Test1115308Test.this.getLog().info("Ignoring duplicate or previous event notification for event '" + eventCount + "'.");
                } else if (eventCount > nextEventID) {
                    this.eventsFuture.setValue(new TCKTestFailureException(1115308, "Missing or skipped event detected while processing test results"));
                } else if (eventCount == nextEventID) {
                    this.currentEventCount = eventCount;
                    if (this.currentEventCount == 42) {
                        this.eventsFuture.setValue(Boolean.TRUE);
                    }
                }
                return true;
            }
            return true;
        }

        public Object getEventsResult() {
            Object result;
            try {
                result = this.eventsFuture.getValue(Test1115308Test.this.utils().getTestTimeout());
            }
            catch (Future.TimeoutException e) {
                return null;
            }
            return result;
        }

        public Object getRAResult() {
            Object result;
            try {
                result = this.raFuture.getValue(Test1115308Test.this.utils().getTestTimeout());
            }
            catch (Future.TimeoutException e) {
                return null;
            }
            return result;
        }
    }
}

