/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource.events;

import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.profileutils.BaseMessageSender;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.resource.adaptor11.TCKActivityHandleImpl;
import com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent;
import com.opencloud.sleetck.lib.testsuite.resource.events.Test1115042ResourceAdaptor;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import javax.slee.EventTypeID;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.SleeEndpoint;

public class Test1115042MessageListener
extends UnicastRemoteObject
implements MessageHandler {
    private static Test1115042MessageListener instance;
    public static final int CREATE_VALID_ACTIVITY = 1;
    public static final int CHECK_ASSERTION = 2;
    private Test1115042ResourceAdaptor ra;
    private BaseMessageSender msgSender;
    private RMIObjectChannel out;
    private ActivityHandle handle1;

    public static Test1115042MessageListener getInstance(Test1115042ResourceAdaptor ra) throws RemoteException {
        if (instance == null || Test1115042MessageListener.instance.ra != ra) {
            instance = new Test1115042MessageListener(ra);
        }
        return instance;
    }

    private Test1115042MessageListener(Test1115042ResourceAdaptor ra) throws RemoteException {
        try {
            this.out = TCKRAUtils.lookupRMIObjectChannel();
            this.msgSender = new BaseMessageSender(this.out, new StdErrLog());
        }
        catch (Exception e) {
            ra.getLog().warning("Exception occurred when trying to acquire RMIObjectChannel: ", e);
        }
        this.ra = ra;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleMessage(Object message) throws RemoteException {
        SleeEndpoint endpoint = null;
        int type = (Integer)((HashMap)message).get("Type");
        endpoint = this.ra.getResourceAdaptorContext().getSleeEndpoint();
        switch (type) {
            case 1: {
                try {
                    this.handle1 = new TCKActivityHandleImpl(System.currentTimeMillis(), 0);
                    try {
                        endpoint.startActivity(this.handle1, (Object)this.handle1);
                        this.msgSender.sendSuccess(1115042, "Created activity.");
                        return true;
                    }
                    catch (Exception e) {
                        this.msgSender.sendError("Could not create activity.");
                        return true;
                    }
                }
                catch (Exception e) {
                    this.msgSender.sendError("Unexpected Exception occurred: " + e);
                    return true;
                }
            }
            case 2: {
                try {
                    EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
                    FireableEventType eventType = this.ra.getResourceAdaptorContext().getEventLookupFacility().getFireableEventType(eventTypeID);
                    TCKActivityHandleImpl handle2 = new TCKActivityHandleImpl(System.currentTimeMillis(), 0);
                    try {
                        this.ra.getLog().info("Starting activity: " + handle2);
                        endpoint.startActivity((ActivityHandle)handle2, (Object)handle2);
                        this.msgSender.sendFailure(1115042, "Starting new activity succeeded though SLEE is in the STOPPING state.");
                        boolean bl = true;
                        return bl;
                    }
                    catch (Exception e) {
                        this.msgSender.sendLogMsg("Starting new activity caused exception as expected: " + e);
                        try {
                            endpoint.fireEvent(this.handle1, eventType, (Object)new SimpleEvent(1), null, null);
                            this.msgSender.sendLogMsg("RA was allowed to submit events on an existing activity.");
                        }
                        catch (Exception e2) {
                            this.msgSender.sendFailure(1115042, "RA object should have been allowed to submit an event on an existing activity though SLEE is in the STOPPING state.");
                            boolean bl = true;
                            if (this.handle1 == null || endpoint == null) return bl;
                            try {
                                endpoint.endActivity(this.handle1);
                                return bl;
                            }
                            catch (Exception e3) {
                                this.ra.getLog().info("Exception occurred when trying to cleanup RA activity.");
                            }
                            return bl;
                        }
                        try {
                            endpoint.endActivity(this.handle1);
                            this.handle1 = null;
                            this.msgSender.sendLogMsg("RA was allowed to end existing activity.");
                        }
                        catch (Exception e4) {
                            this.msgSender.sendFailure(1115042, "RA object should have been allowed to end an existing activity though SLEE is in the STOPPING state.");
                            boolean bl = true;
                            if (this.handle1 == null || endpoint == null) return bl;
                            try {
                                endpoint.endActivity(this.handle1);
                                return bl;
                            }
                            catch (Exception e5) {
                                this.ra.getLog().info("Exception occurred when trying to cleanup RA activity.");
                            }
                            return bl;
                        }
                        this.msgSender.sendSuccess(1115042, "Test passed successfully.");
                        if (this.handle1 == null || endpoint == null) return true;
                        try {
                            endpoint.endActivity(this.handle1);
                            return true;
                        }
                        catch (Exception e6) {
                            this.ra.getLog().info("Exception occurred when trying to cleanup RA activity.");
                        }
                        return true;
                        catch (Exception e7) {
                            this.msgSender.sendError("Unexpected Exception occurred: " + e7);
                            if (this.handle1 == null || endpoint == null) return true;
                            try {
                                endpoint.endActivity(this.handle1);
                                return true;
                            }
                            catch (Exception e8) {
                                this.ra.getLog().info("Exception occurred when trying to cleanup RA activity.");
                            }
                            return true;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (this.handle1 != null && endpoint != null) {
                        try {
                            endpoint.endActivity(this.handle1);
                        }
                        catch (Exception e) {
                            this.ra.getLog().info("Exception occurred when trying to cleanup RA activity.");
                        }
                    }
                }
            }
        }
        return true;
    }
}

