/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource.events;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent;
import com.opencloud.sleetck.lib.testsuite.resource.TCKMessage;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ResourceManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import java.util.HashMap;
import javax.slee.ComponentID;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.ResourceAdaptorID;

public class Test1115158Test
extends AbstractSleeTCKTest {
    private static final String RA_NAME = "TCK_Event_Test_RA";
    private static final String RA_ENTITY_NAME = "TCK_Event_Test_RA_Entity";
    private static final String RA_VENDOR = "jain.slee.tck";
    private static final String RA_VERSION = "1.1";
    private static final String RA_LINK_NAME = "slee/resources/tck/simple";
    private static final String RESOURCE_DU_PATH_PARAM = "resourceDUPath";
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private boolean successCallbackReceived;
    private boolean unreferencedCallbackReceived;
    private boolean sbbEventReceived;
    private DeployableUnitID serviceDUID = null;

    public TCKTestResult run() throws Exception {
        RMIObjectChannel in = this.utils().getRMIObjectChannel();
        ResourceManagementMBeanProxy resourceMBean = this.utils().getResourceManagementMBeanProxy();
        DeploymentMBeanProxy deploymentMBean = this.utils().getDeploymentMBeanProxy();
        ServiceManagementMBeanProxy serviceMBean = this.utils().getServiceManagementMBeanProxy();
        ResourceAdaptorID raID = new ResourceAdaptorID(RA_NAME, RA_VENDOR, RA_VERSION);
        resourceMBean.createResourceAdaptorEntity(raID, RA_ENTITY_NAME, new ConfigProperties());
        resourceMBean.bindLinkName(RA_ENTITY_NAME, RA_LINK_NAME);
        String relativePath = this.utils().getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        String serviceDuPath = this.utils().getDeploymentUnitURL(relativePath);
        this.serviceDUID = deploymentMBean.install(serviceDuPath);
        ServiceID serviceID = this.getServiceID(this.serviceDUID);
        serviceMBean.activate(serviceID);
        resourceMBean.activateResourceAdaptorEntity(RA_ENTITY_NAME);
        TCKMessage[] messages = this.castMessages(in.readQueue(this.utils().getTestTimeout()));
        this.getLog().info("Received the following messages:");
        for (int i = 0; i < messages.length; ++i) {
            this.getLog().info(" " + messages[i].toString());
        }
        this.updateSuccessFlags(messages, 1);
        if (this.successCallbackReceived) {
            throw new TCKTestFailureException(1115159, "Received eventProcessingSuccessful callback when EventFlags.REQUEST_EVENT_PROCESSING_SUCCESSFUL_CALLBACK was not specified during fireEvent()");
        }
        if (this.unreferencedCallbackReceived) {
            throw new TCKTestFailureException(1115166, "Received eventUnreferenced callback when EventFlags.REQUEST_EVENT_UNREFERENCED_CALLBACK was not specified during fireEvent()");
        }
        if (!this.sbbEventReceived) {
            throw new TCKTestFailureException(1115158, "Event was not delivered to SBB");
        }
        this.updateSuccessFlags(messages, 2);
        if (this.successCallbackReceived) {
            throw new TCKTestFailureException(1115159, "Received eventProcessingSuccessful callback when EventFlags.REQUEST_EVENT_PROCESSING_SUCCESSFUL_CALLBACK was not specified during fireEvent()");
        }
        if (this.unreferencedCallbackReceived) {
            throw new TCKTestFailureException(1115166, "Received eventUnreferenced callback when EventFlags.REQUEST_EVENT_UNREFERENCED_CALLBACK was not specified during fireEvent()");
        }
        if (!this.sbbEventReceived) {
            throw new TCKTestFailureException(1115158, "Event was not delivered to SBB");
        }
        this.updateSuccessFlags(messages, 3);
        if (this.successCallbackReceived) {
            throw new TCKTestFailureException(1115159, "Received eventProcessingSuccessful callback when EventFlags.REQUEST_EVENT_PROCESSING_SUCCESSFUL_CALLBACK was not specified during fireEvent()");
        }
        if (!this.unreferencedCallbackReceived) {
            throw new TCKTestFailureException(1115166, "Did not receive expected eventUnreferenced callback when EventFlags.REQUEST_EVENT_UNREFERENCED_CALLBACK was specified during fireEvent()");
        }
        if (!this.sbbEventReceived) {
            throw new TCKTestFailureException(1115158, "Event was not delivered to SBB");
        }
        this.updateSuccessFlags(messages, 4);
        if (!this.successCallbackReceived) {
            throw new TCKTestFailureException(1115159, "Did not receive expected eventProcessingSuccessful callback when EventFlags.REQUEST_EVENT_PROCESSING_SUCCESSFUL_CALLBACK was specified during fireEvent()");
        }
        if (this.unreferencedCallbackReceived) {
            throw new TCKTestFailureException(1115166, "Received eventUnreferenced callback when EventFlags.REQUEST_EVENT_UNREFERENCED_CALLBACK was not specified during fireEvent()");
        }
        if (!this.sbbEventReceived) {
            throw new TCKTestFailureException(1115158, "Event was not delivered to SBB");
        }
        this.updateSuccessFlags(messages, 5);
        if (!this.successCallbackReceived) {
            throw new TCKTestFailureException(1115159, "Did not receive expected eventProcessingSuccessful callback when EventFlags.REQUEST_EVENT_PROCESSING_SUCCESSFUL_CALLBACK and EventFlags.REQUEST_EVENT_UNREFERENCED_CALLBACK were specified during fireEvent()");
        }
        if (!this.unreferencedCallbackReceived) {
            throw new TCKTestFailureException(1115166, "Did not receive expected eventUnreferenced callback when EventFlags.REQUEST_EVENT_PROCESSING_SUCCESSFUL_CALLBACK and EventFlags.REQUEST_EVENT_UNREFERENCED_CALLBACK were specified during fireEvent()");
        }
        if (!this.sbbEventReceived) {
            throw new TCKTestFailureException(1115158, "Event was not delivered to SBB");
        }
        return TCKTestResult.passed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            DeploymentMBeanProxy deploymentMBean = this.utils().getDeploymentMBeanProxy();
            try {
                if (this.serviceDUID != null) {
                    this.utils().deactivateService(this.getServiceID(this.serviceDUID));
                    deploymentMBean.uninstall(this.serviceDUID);
                }
            }
            finally {
                this.utils().removeRAEntities();
            }
        }
        finally {
            super.tearDown();
        }
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty(RESOURCE_DU_PATH_PARAM);
        this.utils().install(duPath);
    }

    private TCKMessage[] castMessages(Object[] objects) {
        TCKMessage[] messages = new TCKMessage[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            messages[i] = (TCKMessage)objects[i];
        }
        return messages;
    }

    private ServiceID getServiceID(DeployableUnitID duID) throws TCKTestErrorException {
        DeployableUnitDescriptor descriptor;
        try {
            descriptor = this.utils().getDeploymentMBeanProxy().getDescriptor(duID);
        }
        catch (Exception e) {
            throw new TCKTestErrorException("An error occured while attempting to determine ServiceID", e);
        }
        ComponentID[] components = descriptor.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ServiceID)) continue;
            return (ServiceID)components[i];
        }
        return null;
    }

    private void updateSuccessFlags(TCKMessage[] messages, int sequenceID) throws TCKTestErrorException {
        this.successCallbackReceived = false;
        this.unreferencedCallbackReceived = false;
        this.sbbEventReceived = false;
        for (int i = 0; i < messages.length; ++i) {
            SimpleEvent event;
            TCKMessage message = messages[i];
            HashMap results = (HashMap)message.getArgument();
            if (results == null) {
                throw new TCKTestErrorException("Null result received in message from test component: " + message);
            }
            boolean fromSbb = false;
            if (Boolean.TRUE.equals(results.get("fromsbb"))) {
                fromSbb = true;
            }
            if ((event = (SimpleEvent)results.get("event")) == null) {
                throw new TCKTestErrorException("Null event contained in message from test component: " + message);
            }
            if (fromSbb && event.getSequenceID() == sequenceID) {
                this.sbbEventReceived = true;
                continue;
            }
            if (!fromSbb && event.getSequenceID() == sequenceID && message.getMethod() == 12) {
                this.successCallbackReceived = true;
                continue;
            }
            if (fromSbb || event.getSequenceID() != sequenceID || message.getMethod() != 13) continue;
            this.unreferencedCallbackReceived = true;
        }
    }
}

