/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource.lifecycle;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.rautils.JVMUID;
import com.opencloud.sleetck.lib.rautils.UOID;
import com.opencloud.sleetck.lib.testsuite.resource.RAMethods;
import com.opencloud.sleetck.lib.testsuite.resource.TCKMessage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class RAStateManager {
    public static final int STATE_IMPOSSIBLE = -2;
    public static final int STATE_DOES_NOT_EXIST = -1;
    public static final int STATE_CONSTRUCTED = 0;
    public static final int STATE_UNCONFIGURED = 1;
    public static final int STATE_INACTIVE = 2;
    public static final int STATE_ACTIVE = 3;
    public static final int STATE_STOPPING = 4;
    private final HashMap states = new HashMap();
    private final Logable log;

    public RAStateManager(Logable log) {
        this.log = log;
    }

    public void runStateMachine(TCKMessage[] messages) throws TCKTestErrorException, TCKTestFailureException {
        for (int i = 0; i < messages.length; ++i) {
            this.handleMessage(messages[i]);
        }
    }

    public boolean hasRAObjectInState(int state) {
        Set keys = this.states.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            UOID key = (UOID)iter.next();
            if (this.getState(key) != state) continue;
            return true;
        }
        return false;
    }

    private void handleMessage(TCKMessage message) throws TCKTestErrorException, TCKTestFailureException {
        int method = message.getMethod();
        UOID rauid = message.getUID();
        int currentState = this.getState(rauid);
        this.log.debug("RAStateManager processing message from RA Object: " + message);
        int newState = currentState;
        switch (method) {
            case 24: {
                this.log.debug("Initialising lifecycle state for RAUID: " + rauid);
                if (currentState != -1) {
                    throw new TCKTestErrorException("RA Object constructor impossibly called multiple times: rauid=" + rauid);
                }
                newState = 0;
                break;
            }
            case 22: {
                if (currentState != 0) {
                    throw this.createTCKTestFailureException(1115504, method, rauid, currentState);
                }
                newState = 1;
                break;
            }
            case 5: {
                if (currentState != 1) {
                    throw this.createTCKTestFailureException(1115515, method, rauid, currentState);
                }
                newState = 2;
                break;
            }
            case 7: {
                if (currentState != 2) {
                    throw this.createTCKTestFailureException(1115525, method, rauid, currentState);
                }
                newState = 3;
                break;
            }
            case 9: {
                if (currentState != 3) {
                    throw this.createTCKTestFailureException(1115530, method, rauid, currentState);
                }
                newState = 4;
                break;
            }
            case 8: {
                if (currentState != 4) {
                    throw this.createTCKTestFailureException(1115535, method, rauid, currentState);
                }
                newState = 2;
                break;
            }
            case 6: {
                if (currentState != 2) {
                    throw this.createTCKTestFailureException(1115519, method, rauid, currentState);
                }
                newState = 1;
                break;
            }
            case 23: {
                if (this.getState(rauid) != 1) {
                    throw this.createTCKTestFailureException(1115512, method, rauid, currentState);
                }
                newState = 0;
                break;
            }
            case 25: {
                if (currentState != 0) {
                    throw new TCKTestErrorException("Finalizer called on RA Object in invalid state: " + RAStateManager.getStateString(currentState));
                }
                newState = -1;
                break;
            }
            default: {
                return;
            }
        }
        this.setState(rauid, newState);
        this.checkForMultipleConfiguredRAObjects();
    }

    private void setState(UOID rauid, int state) {
        this.states.put(rauid, new Integer(state));
    }

    private int getState(UOID rauid) {
        Integer state = (Integer)this.states.get(rauid);
        if (state != null) {
            return state;
        }
        return -1;
    }

    private TCKTestFailureException createTCKTestFailureException(int assertionId, int method, UOID rauid, int state) {
        return new TCKTestFailureException(assertionId, "Illegal call to method " + RAMethods.getMethodName(method) + "() in state " + RAStateManager.getStateString(state) + " on RA Object: " + rauid);
    }

    private void checkForMultipleConfiguredRAObjects() throws TCKTestFailureException {
        HashMap<JVMUID, UOID> jvmConfiguredRAObjects = new HashMap<JVMUID, UOID>();
        Set keys = this.states.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            UOID key = (UOID)iter.next();
            JVMUID jvmuid = key.getJVMUID();
            int raObjectState = this.getState(key);
            if (raObjectState == -1 || raObjectState == 0 || raObjectState == 1) continue;
            if (jvmConfiguredRAObjects.get(jvmuid) != null) {
                UOID firstKey = (UOID)jvmConfiguredRAObjects.get(jvmuid);
                throw new TCKTestFailureException(1115053, "Multiple configured Resource Adaptor Objects exist in a single JVM: RAUID_1=" + firstKey + ", RAUID_2=" + key);
            }
            jvmConfiguredRAObjects.put(jvmuid, key);
        }
    }

    public static String getStateString(int state) {
        switch (state) {
            case -2: {
                return "IMPOSSIBLE";
            }
            case -1: {
                return "DOES_NOT_EXIST";
            }
            case 0: {
                return "CONSTRUCTED";
            }
            case 1: {
                return "UNCONFIGURED";
            }
            case 2: {
                return "INACTIVE";
            }
            case 3: {
                return "ACTIVE";
            }
            case 4: {
                return "STOPPING";
            }
        }
        return "UNKNOWN_STATE";
    }
}

