/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.runtime.security;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.profileutils.BaseMessageAdapter;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.slee.profile.ProfileSpecificationID;

public class Test1112019Test
extends AbstractSleeTCKTest {
    public static final String DU_PATH_PARAM = "serviceDUPath";
    public static final String SPEC_NAME = "Test1112019Profile";
    public static final String SPEC_VERSION = "1.1";
    private ProfileUtils profileUtils;
    private ProfileProvisioningMBeanProxy profileProvisioning;
    private ObjectName profile;
    private ProfileMBeanProxy profileProxy;
    private RMIObjectChannel in;
    private FutureResult futureResult;
    private TCKTestResult exResult;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCKTestResult run() throws Exception {
        this.futureResult = new FutureResult(this.getLog());
        this.getLog().fine("Run tests for profile spec Test1112019Profile");
        ProfileSpecificationID specID = new ProfileSpecificationID(SPEC_NAME, "jain.slee.tck", SPEC_VERSION);
        this.profileProvisioning.createProfileTable(specID, "Test1112019ProfileTable");
        this.getLog().fine("Added profile table Test1112019ProfileTable");
        this.profile = this.profileProvisioning.createProfile("Test1112019ProfileTable", SPEC_NAME);
        this.profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(this.profile);
        if (null == this.profileProxy) {
            throw new TCKTestErrorException("Could not create profile.");
        }
        this.profileProxy.commitProfile();
        this.getLog().fine("Created profile Test1112019Profile for profile table Test1112019ProfileTable");
        try {
            this.getLog().info("Invoking profile management method directly.");
            try {
                this.utils().getMBeanFacade().invoke(this.profile, "manage", new Object[0], new String[0]);
                this.getLog().fine("Called management method on ProfileManagement interface.");
            }
            catch (ReflectionException e) {
                Assert.fail(1112019, "Method not found when invoking management method declared in ProfileManagement interface.");
            }
            TCKResourceTestInterface resource = this.utils().getResourceInterface();
            this.getLog().fine("Creating activity");
            TCKActivityID activityID = resource.createActivity(this.getClass().getName());
            this.getLog().fine("Firing an event");
            resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", null, activityID, null);
            TCKTestResult res = this.futureResult.waitForResult(this.utils().getTestTimeout());
            if (!res.isPassed()) {
                TCKTestResult tCKTestResult = res;
                return tCKTestResult;
            }
        }
        finally {
            this.futureResult = new FutureResult(this.getLog());
            this.profileProxy.closeProfile();
            this.profileProvisioning.removeProfile("Test1112019ProfileTable", SPEC_NAME);
            this.profileProvisioning.removeProfileTable("Test1112019ProfileTable");
            if (this.futureResult.isSet()) {
                return this.futureResult.waitForResult(this.utils().getTestTimeout());
            }
        }
        if (this.exResult != null) {
            return this.exResult;
        }
        return TCKTestResult.passed();
    }

    public void setPassed(int assertionID, String msg) {
        this.getLog().fine(assertionID + ": " + msg);
        if (this.futureResult != null && !this.futureResult.isSet()) {
            this.futureResult.setPassed();
        }
    }

    public void setFailed(int assertionID, String msg, Exception e) {
        if (e == null) {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setFailed(assertionID, msg);
            }
            this.setIfEmpty(TCKTestResult.failed(assertionID, msg));
        } else {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            this.getLog().fine(e);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setFailed(new TCKTestFailureException(assertionID, msg, e));
            }
            this.setIfEmpty(TCKTestResult.failed(new TCKTestFailureException(assertionID, msg, e)));
        }
    }

    public void setError(String msg, Exception e) {
        if (e == null) {
            this.getLog().warning(msg);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setError(msg);
            }
            this.setIfEmpty(TCKTestResult.error(msg));
        } else {
            this.getLog().warning(msg);
            this.getLog().warning(e);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setError(msg, e);
            }
            this.setIfEmpty(TCKTestResult.error(msg, e));
        }
    }

    public void tearDown() throws Exception {
        this.in.clearQueue();
        super.tearDown();
    }

    public void setUp() throws Exception {
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        this.in = this.utils().getRMIObjectChannel();
        this.in.setMessageHandler(new BaseMessageAdapter(this.getLog()){

            public void onSetPassed(int assertionID, String msg) {
                Test1112019Test.this.setPassed(assertionID, msg);
            }

            public void onSetFailed(int assertionID, String msg, Exception e) {
                Test1112019Test.this.setFailed(assertionID, msg, e);
            }

            public void onLogCall(String msg) {
                Test1112019Test.this.getLog().fine(msg);
            }

            public void onSetError(String msg, Exception e) {
                Test1112019Test.this.setError(msg, e);
            }
        });
        this.setupService(DU_PATH_PARAM);
    }

    private void setIfEmpty(TCKTestResult exResult) {
        if (this.exResult == null) {
            this.exResult = exResult;
        }
    }
}

