/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.sbb.abstractclass;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.testsuite.sbb.abstractclass.SendResultsSbb;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.slee.ActivityContextInterface;
import javax.slee.ComponentID;
import javax.slee.facilities.ActivityContextNamingFacility;
import javax.slee.facilities.AlarmFacility;
import javax.slee.facilities.Level;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TraceFacility;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import javax.slee.profile.ProfileFacility;
import javax.slee.profile.ProfileTableActivityContextInterfaceFactory;

public abstract class JndiEnvironmentSbb
extends SendResultsSbb {
    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            Context context = (Context)new InitialContext().lookup("java:comp/env");
            this.checkJndi(context, "slee/facilities/timer", TimerFacility.class, 1409);
            this.checkJndi(context, "slee/facilities/alarm", AlarmFacility.class, 1410);
            this.checkJndi(context, "slee/facilities/trace", TraceFacility.class, 1411);
            this.checkJndi(context, "slee/facilities/activitycontextnaming", ActivityContextNamingFacility.class, 1413);
            this.checkJndi(context, "slee/facilities/profile", ProfileFacility.class, 1414);
            this.checkJndi(context, "slee/facilities/profiletableactivitycontextinterfacefactory", ProfileTableActivityContextInterfaceFactory.class, 1415);
            this.checkJndi(context, "slee/nullactivity/factory", NullActivityFactory.class, 623);
            this.checkJndi(context, "slee/nullactivity/activitycontextinterfacefactory", NullActivityContextInterfaceFactory.class, 624);
            this.setResultPassed("jndi environment tests passed");
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void checkJndi(Context context, String name, Class expectedType, int assertionID) {
        block5: {
            try {
                try {
                    Object o = context.lookup(name);
                    if (expectedType.isAssignableFrom(o.getClass())) {
                        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "jndi name " + name + " returned correct object type", null);
                        break block5;
                    }
                    this.setResultFailed(assertionID, "expected type of object returned from jndi name " + name + " was " + expectedType.getName() + ", but got object of type " + o.getClass().getName());
                }
                catch (NameNotFoundException nnfe) {
                    this.setResultFailed(assertionID, "jndi name " + name + " not found (" + nnfe + ")");
                }
            }
            catch (Exception e) {
                TCKSbbUtils.handleException(e);
            }
        }
    }
}

