/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.sbb.abstractclass;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.Map;

public class SbbExceptionThrownRethrow
extends AbstractSleeTCKTest {
    private FutureResult result;
    private boolean reinvoked = false;

    public void run(FutureResult result) throws Exception {
        this.result = result;
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        String activityName = "SbbExceptionThrownRethrow";
        TCKActivityID activityID = resource.createActivity(activityName);
        this.utils().getLog().fine("Firing TCKResourceEventX.X1 on activity " + activityName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        this.utils().getLog().fine("Firing TCKResourceEventX.X2 on activity " + activityName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        TCKResourceListenerImpl resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(resourceListener);
        this.setupService("serviceDUPath", true);
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            if (sbbData.containsKey("reinvoked")) {
                SbbExceptionThrownRethrow.this.reinvoked = true;
            } else if (sbbData.containsKey("x2")) {
                if (SbbExceptionThrownRethrow.this.reinvoked) {
                    SbbExceptionThrownRethrow.this.result.setFailed(459, "sbbExceptionThrown was reinvoked after rethrowing a runtime exception");
                } else {
                    SbbExceptionThrownRethrow.this.result.setPassed();
                }
            }
        }

        public void onException(Exception exception) throws RemoteException {
            SbbExceptionThrownRethrow.this.getLog().warning("Received exception from SBB or resource:");
            SbbExceptionThrownRethrow.this.getLog().warning(exception);
            SbbExceptionThrownRethrow.this.result.setError(exception);
        }
    }
}

