/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.sbb.lifecycle;

import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import java.util.HashMap;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitID;

public class Test1106001Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 1106001;
    private SleeTCKTestUtils utils;
    private FutureResult result;
    private DeployableUnitID duID;
    private QueuingResourceListener resourceListener;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TCKTestResult run() throws Exception {
        ServiceID serviceID = new ServiceID("Test1106001TestService", "jain.slee.tck", "1.1");
        this.result = new FutureResult(this.utils.getLog());
        this.utils.getServiceManagementMBeanProxy().activate(serviceID);
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test1106001InitialActivity");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.getServiceManagementMBeanProxy().deactivate(serviceID);
        try {
            HashMap message;
            do {
                message = (HashMap)this.resourceListener.nextMessage().getMessage();
                this.utils.getLog().info("Got message from SBB Method: " + message);
                if (null == message) return TCKTestResult.passed();
            } while (null == message.get("TCKResult"));
            return (TCKTestResult)message.get("TCKResult");
        }
        catch (OperationTimedOutException e) {}
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new QueuingResourceListener(this.utils);
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.uninstallAll();
    }
}

