/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.transactions;

import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.profileutils.BaseMessageSender;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import java.util.HashMap;
import javax.slee.ActivityContextInterface;
import javax.slee.RolledBackContext;
import javax.slee.SbbContext;

public abstract class Test1109011Sbb
extends BaseTCKSbb {
    public static final int TYPE_EVENTHANDLER = 1025;
    public static final int TYPE_ROLLBACK = 1026;
    public static final int TYPE_CMP_VALUE = 1027;
    private RMIObjectChannel out;
    private BaseMessageSender msgSender;
    private static int rolledbackCount = 0;

    public void setSbbContext(SbbContext context) {
        super.setSbbContext(context);
        try {
            this.out = TCKRAUtils.lookupRMIObjectChannel();
            this.msgSender = new BaseMessageSender(this.out, new StdErrLog());
        }
        catch (Exception e) {
            context.getTracer(this.getSbbID().getName()).fine("An error occured creating an RMIObjectChannel:", (Throwable)e);
        }
    }

    public void sbbRolledBack(RolledBackContext context) {
        try {
            this.msgSender.sendLogMsg("sbbRolledBack called.");
            HashMap map = this.msgSender.getBaseConfig();
            map.put("SbbID", this.getSbbIDValue());
            this.msgSender.sendCustomMessage(1026, map);
            this.msgSender.sendLogMsg("Sent Sbb message.");
            if (rolledbackCount > 0) {
                return;
            }
            ++rolledbackCount;
            if ("newValue".equals(this.getStringValue())) {
                this.msgSender.sendFailure(1109014, "The TXN sbbRolledBack() is called with has to be a new TXN.");
            } else {
                this.msgSender.sendLogMsg("sbbRolledBack() was executed in a new TXN as expected.");
            }
            this.setStringValue("sbbRolledBack");
            this.msgSender.sendLogMsg("Mark sbbRolledBack TXN for rollback.");
            this.getSbbContext().setRollbackOnly();
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
        }
    }

    public void onTCKResourceEventX2(TCKResourceEventX ev, ActivityContextInterface aci) {
        try {
            this.msgSender.sendLogMsg("Received TCKResourceEvent.X2");
            HashMap map = this.msgSender.getBaseConfig();
            map.put("SbbID", this.getSbbIDValue());
            this.msgSender.sendCustomMessage(1025, map);
            this.msgSender.sendLogMsg("Sent Sbb message.");
            this.setStringValue("newValue");
            this.msgSender.sendLogMsg("Mark event handler TXN for rollback.");
            this.getSbbContext().setRollbackOnly();
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
        }
    }

    public void onTCKResourceEventX1(TCKResourceEventX ev, ActivityContextInterface aci) {
        try {
            if (this.getSbbIDValue() == null) {
                this.msgSender.sendLogMsg("Set CMP field from 'null' to " + ev.getMessage());
                this.setSbbIDValue((String)ev.getMessage());
                this.msgSender.sendSuccess(1109011, "Received TCKResourceEvent.X1 with message " + ev.getMessage());
            }
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
        }
    }

    public void onTCKResourceEventX3(TCKResourceEventX ev, ActivityContextInterface aci) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("stringValue", this.getStringValue());
            this.msgSender.sendCustomMessage(1027, map);
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
        }
    }

    public abstract void setStringValue(String var1);

    public abstract String getStringValue();

    public abstract void setSbbIDValue(String var1);

    public abstract String getSbbIDValue();
}

