/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.transactions.isolation;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class Test2004Test
extends AbstractSleeTCKTest {
    private static final String SERVICE1_DU_PATH_PARAM = "service1DUPath";
    private static final String SERVICE2_DU_PATH_PARAM = "service2DUPath";
    private static final String X2_FIRST_ACK_RECEIVED = "X2_FIRST_ACK_RECEIVED";
    private static final String X2_SECOND_ACK_RECEIVED = "X2_SECOND_ACK_RECEIVED";
    private static final String EVENT_ACK_PREFIX = "ACK_RECEIVED_FROM_";
    private static final String ROLLED_BACK_FLAG_PREFIX = "ROLLED_BACK_FOR_";
    private static final String STOP_BLOCKING_PREFIX = "STOP_BLOCKING_FOR_";
    private TCKActivityID activityA;
    private TCKActivityID activityB;
    private Object stateLock;
    private HashSet flags;
    private Exception sbbOrResourceException;
    private HashMap eventObjectIDs;
    private HashSet processedEvents;
    private Object[] responsesFromX2;
    private Object[] responsesFromY2;

    public void setUp() throws Exception {
        this.setResourceListener(new ResourceListenerImpl());
        this.setupService(SERVICE1_DU_PATH_PARAM, true);
        this.setupService(SERVICE2_DU_PATH_PARAM, true);
        this.stateLock = new Object();
        this.flags = new HashSet();
        this.eventObjectIDs = new HashMap();
        this.processedEvents = new HashSet();
        this.sbbOrResourceException = null;
        this.responsesFromX2 = null;
        this.responsesFromY2 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCKTestResult run() throws Exception {
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        this.activityA = resource.createActivity("Test2004ActivityA");
        this.activityB = resource.createActivity("Test2004ActivityB");
        try {
            this.initialiseResources();
            this.testCase1();
            this.testCase2();
        }
        finally {
            this.freeResources();
        }
        return TCKTestResult.passed();
    }

    private void initialiseResources() throws Exception {
        this.getLog().fine("firing X1 on activity A");
        this.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.activityA);
        this.getLog().fine("waiting for X1 processing to finish");
        this.waitForEventProcessing("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1");
        if (this.isRolledBack("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1")) {
            new TCKTestErrorException("The X1 event handler rolled back. The initial bindings will not have been committed, and the test cannot continue");
        }
        if (!this.isACKReceived("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1")) {
            throw new TCKTestErrorException("Indication of X1 completing processing before the ACK was received from the event handler");
        }
    }

    private void testCase1() throws Exception {
        this.getLog().info("Testing case 1: Access transactional state which was changed and committed in another transaction after the current transaction performed a read on the resource.");
        this.getLog().fine("firing X2 on activity A");
        this.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", this.activityA);
        this.getLog().fine("waiting for first X2 call (request to block)");
        this.waitForACK("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2");
        this.getLog().fine("firing Y1 on activity B while the X2 handler is blocked");
        this.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1", this.activityB);
        this.getLog().fine("waiting for Y1 processing to finish");
        try {
            this.waitForEventProcessing("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1");
        }
        catch (OperationTimedOutException toe) {
            this.getLog().warning("Timed out while waiting for Y1 to complete processing. This is acceptable, as the SLEE may be using single threaded event delivery, or pessimistic locking. Continuing...");
        }
        this.getLog().fine("unblocking the X2 handler");
        this.stopBlockingFor("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2");
        this.getLog().fine("waiting for X2 processing to finish");
        this.waitForEventProcessing("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2");
        this.diagnoseCase1Result();
        this.getLog().finer("waiting for Y1 to complete processing");
        try {
            this.waitForEventProcessing("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1");
        }
        catch (OperationTimedOutException toe) {
            throw new TCKTestErrorException("Timed out while waiting for Y1 to complete processing, after X2 processing was completed. As the Y1 event handler may still have locks for transaction resources, the test cannot continue.");
        }
        if (!this.isACKReceived("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1") && !this.isRolledBack("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1")) {
            throw new TCKTestErrorException("Indication of Y1 completing processing before an ACK or rolled back indication was received for the event handler");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void diagnoseCase1Result() throws Exception {
        if (this.getFlag(X2_SECOND_ACK_RECEIVED)) {
            Object responseForY1Binding = this.responsesFromX2[0];
            if (responseForY1Binding instanceof Exception) {
                this.getLog().warning("The attempt to lookup an ACI binding resulted in an Exception being thrown. Allow this, as the SLEE may be using pessimistic locking on the ActivityContextNamingFacility. Exception caught:");
                this.getLog().warning((Exception)responseForY1Binding);
                this.getLog().fine("Continuing...");
            } else {
                boolean wasY1BindingFound = (Boolean)responseForY1Binding;
                this.getLog().fine("wasY1BindingFound=" + wasY1BindingFound);
                if (wasY1BindingFound) {
                    throw new TCKTestFailureException(2004, "The ActivityContextNamingFacility binding set by the Y1 event handler in a concurrent transaction was visible from the X2 event handler. This indicates that transaction isolation was broken: after transaction A performed a read on the resource (another lookup in the naming facility), changes were made in transaction B, and those changes were visible from transaction A");
                }
                this.getLog().info("The changes made by the Y1 event handler in a concurrent transaction were not visible to the X2 event handler. This is the expected result. Continuing...");
            }
            Object responseForInitialBinding2 = this.responsesFromX2[1];
            if (responseForInitialBinding2 instanceof Exception) {
                this.getLog().warning("The attempt to lookup an ACI binding resulted in an Exception being thrown. Allow this, as the SLEE may be using pessimistic locking on the ActivityContextNamingFacility. Exception caught:");
                this.getLog().warning((Exception)responseForInitialBinding2);
                this.getLog().fine("Continuing...");
                return;
            } else {
                boolean wasInitialBinding2Found = (Boolean)responseForInitialBinding2;
                this.getLog().fine("wasInitialBinding2Found=" + wasInitialBinding2Found);
                if (wasInitialBinding2Found) {
                    this.getLog().info("The changes made by the Y1 event handler in a concurrent transaction were not visible to the X2 event handler. This is the expected result. Continuing...");
                    return;
                } else {
                    if (!this.isRolledBack("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2")) throw new TCKTestFailureException(2004, "The Y1 event handler removed a binding at Test2004NullActivity_Initial_Binding_2 in a concurrent transaction, and this change was visible from the X2 event handler. This indicates that transaction isolation was broken: after transaction A performed a read on the resource (another lookup in the naming facility), changes were made in transaction B, and those changes were visible from transaction A");
                    this.getLog().warning("The binding removed by the Y1 event handler at Test2004NullActivity_Initial_Binding_2 appeared to be effective the X2 event handler: the lookup returned null. This may indicate a break in transactional isolation, but the transaction was rolled back, so it may simply indicate the SLEE denying access to the binding because of concurrent access. This is an accepted result. Contining...");
                }
            }
            return;
        } else {
            if (!this.isRolledBack("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2")) throw new TCKTestErrorException("Indication of X2 completing processing before a second ACK was received from the event handler, or an sbbRolledBack() call");
            this.getLog().info("The second ACK was not received from the X2 event handler, and the transaction was rolled back. This is an accepted result. Contining...");
        }
    }

    private void testCase2() throws Exception {
        this.getLog().info("Testing case 2: Access transactional state which was changed but has not yet been committed in another transaction");
        this.getLog().fine("firing X3 on activity A");
        this.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X3", this.activityA);
        this.getLog().fine("waiting for X3 call (request to block)");
        this.waitForACK("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X3");
        this.getLog().fine("firing Y2 on activity B while blocking the X3 event handler");
        this.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y2", this.activityB);
        this.getLog().fine("waiting for Y2 processing to finish");
        try {
            this.waitForEventProcessing("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y2");
        }
        catch (OperationTimedOutException toe) {
            this.getLog().warning("Timed out while waiting for Y2 to complete processing. This is acceptable, as the SLEE may be using single threaded event delivery, or pessimistic locking. Continuing...");
        }
        this.diagnoseCase2Result();
        this.getLog().fine("unblocking the X3 handler");
        this.stopBlockingFor("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X3");
        this.getLog().fine("waiting for X3 processing to finish");
        this.waitForEventProcessing("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X3");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void diagnoseCase2Result() throws Exception {
        if (!this.isEventProcessingFinished("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y2")) return;
        if (this.isACKReceived("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y2")) {
            Object responseForX3Binding = this.responsesFromY2[0];
            if (responseForX3Binding instanceof Exception) {
                this.getLog().warning("The attempt to lookup an ACI binding resulted in an Exception being thrown. Allow this, as the SLEE may be using pessimistic locking on the ActivityContextNamingFacility. Exception caught:");
                this.getLog().warning((Exception)responseForX3Binding);
                this.getLog().fine("Continuing...");
            } else {
                boolean wasX3BindingFound = (Boolean)responseForX3Binding;
                this.getLog().fine("wasX3BindingFound=" + wasX3BindingFound);
                if (wasX3BindingFound) {
                    throw new TCKTestFailureException(2004, "The ActivityContextNamingFacility binding set by the X3 event handler in a concurrent transaction was visible from the Y2 event handler. This indicates that transaction isolation was broken: uncommitted changes to ActivityContextNamingFacility bindings in one transaction were visible to other transactions");
                }
                this.getLog().info("The changes made by the X3 event handler in a concurrent transaction were not visible to the Y2 event handler. This is the expected result. Continuing...");
            }
            Object responseForInitialBinding3 = this.responsesFromY2[1];
            if (responseForInitialBinding3 instanceof Exception) {
                this.getLog().warning("The attempt to lookup an ACI binding resulted in an Exception being thrown. Allow this, as the SLEE may be using pessimistic locking on the ActivityContextNamingFacility. Exception caught:");
                this.getLog().warning((Exception)responseForInitialBinding3);
                this.getLog().fine("Continuing...");
                return;
            } else {
                boolean wasInitialBinding3Found = (Boolean)responseForInitialBinding3;
                this.getLog().fine("wasInitialBinding3Found=" + wasInitialBinding3Found);
                if (wasInitialBinding3Found) {
                    this.getLog().info("The changes made by the X3 event handler in a concurrent transaction were not visible to the Y2 event handler. This is the expected result. Continuing...");
                    return;
                } else {
                    if (!this.isRolledBack("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y2")) throw new TCKTestFailureException(2004, "The X3 event handler removed a binding at Test2004NullActivity_Initial_Binding_3 in a concurrent transaction, and this change was visible from the Y2 event handler. This indicates that transaction isolation was broken: uncommitted changes to ActivityContextNamingFacility bindings in one transaction were visible to other transactions");
                    this.getLog().warning("The binding removed by the X3 event handler at Test2004NullActivity_Initial_Binding_3 appeared to be effective the Y2 event handler: the lookup returned null. This may indicate a break in transactional isolation, but the transaction was rolled back, so it may simply indicate the SLEE denying access to the binding because of concurrent access. This is an accepted result. Contining...");
                }
            }
            return;
        } else {
            if (!this.isRolledBack("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y2")) throw new TCKTestErrorException("Indication of Y2 completing processing before an ACK or rolled back indication was received for the event handler");
            this.getLog().info("The second ACK was not received from the Y2 event handler, and the transaction was rolled back. This is an accepted result. Contining...");
        }
    }

    private void freeResources() throws Exception {
        this.getLog().fine("Performing clean up tasks");
        this.getLog().fine("release all blocking methods");
        this.stopBlockingFor("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2");
        this.stopBlockingFor("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X3");
        this.getLog().fine("fire Y3 on activity A");
        this.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y3", this.activityA);
        this.getLog().fine("wait for Y3 processing to finish");
        this.waitForEventProcessing("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(String eventType, TCKActivityID activityID) throws TCKTestErrorException, RemoteException {
        this.getLog().info("Firing an " + eventType + " on activity " + activityID);
        long eventObjectID = this.utils().getResourceInterface().fireEvent(eventType, null, activityID, null);
        Object object = this.stateLock;
        synchronized (object) {
            this.eventObjectIDs.put(eventType, new Long(eventObjectID));
            this.stateLock.notifyAll();
        }
    }

    private void handleX1() {
    }

    private void handleX2(Object argument) {
        if (this.getFlag(X2_FIRST_ACK_RECEIVED)) {
            this.setFlag(X2_SECOND_ACK_RECEIVED);
            this.responsesFromX2 = (Object[])argument;
        } else {
            Boolean[] firstResponsesFromX2 = (Boolean[])argument;
            this.getLog().info("Before blocking, the X2 handler looked up ACI bindings.");
            Boolean wasBoundAtInitialName1 = firstResponsesFromX2[0];
            Boolean wasBoundAtInitialName2 = firstResponsesFromX2[1];
            this.getLog().info("Was bound at Test2004NullActivity_Initial_Binding_1?:" + wasBoundAtInitialName1);
            this.getLog().info("Was bound at Test2004NullActivity_Initial_Binding_2?:" + wasBoundAtInitialName2);
            if (!wasBoundAtInitialName1.booleanValue()) {
                this.sbbOrResourceException = new TCKTestErrorException("The ActivityContextInterface binding was not found at Test2004NullActivity_Initial_Binding_1. The test SBB needs to access this binding to continue. Aborting the test...");
            } else if (!wasBoundAtInitialName2.booleanValue()) {
                this.sbbOrResourceException = new TCKTestErrorException("The ActivityContextInterface binding was not found at Test2004NullActivity_Initial_Binding_2. The test SBB needs to access this binding to continue. Aborting the test...");
            } else {
                this.setFlag(X2_FIRST_ACK_RECEIVED);
                this.blockEventHandler("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2");
            }
        }
    }

    private void handleX3(Object argument) {
        Boolean[] responsesFromX3 = (Boolean[])argument;
        this.getLog().info("Before blocking, the X3 handler looked up ACI bindings.");
        Boolean wasBoundAtInitialName1 = responsesFromX3[0];
        Boolean wasBoundAtInitialName3 = responsesFromX3[1];
        this.getLog().info("Was bound at Test2004NullActivity_Initial_Binding_1?:" + wasBoundAtInitialName1);
        this.getLog().info("Was bound at Test2004NullActivity_Initial_Binding_3?:" + wasBoundAtInitialName3);
        if (!wasBoundAtInitialName1.booleanValue()) {
            this.sbbOrResourceException = new TCKTestErrorException("The ActivityContextInterface binding was not found at Test2004NullActivity_Initial_Binding_1. The test SBB needs to access this binding to continue. Aborting the test...");
        } else if (!wasBoundAtInitialName3.booleanValue()) {
            this.sbbOrResourceException = new TCKTestErrorException("The ActivityContextInterface binding was not found at Test2004NullActivity_Initial_Binding_3. The test SBB needs to access this binding to continue. Aborting the test...");
        } else {
            this.blockEventHandler("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X3");
        }
    }

    private void handleY1(Object argument) {
        if (argument != null) {
            Exception exceptionCaught = (Exception)argument;
            this.getLog().info("The Y1 event handler caught Exception which trying to alter the ActivityContextNamingFacility bindings:");
            this.getLog().info(exceptionCaught);
            this.getLog().info("Presumably this is because the SLEE chose to disallow access to the ActivityContextNamingFacility after read access from the X2 handler in another transaction.");
        }
    }

    private void handleY2(Object argument) {
        this.responsesFromY2 = (Object[])argument;
    }

    private void handleY3() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFlag(String flagName) {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.getFlag(flagName)) {
                this.getLog().fine("Setting flag: " + flagName);
                this.flags.add(flagName);
            }
            this.stateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getFlag(String flagName) {
        Object object = this.stateLock;
        synchronized (object) {
            return this.flags.contains(flagName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForFlag(String flagName) throws OperationTimedOutException, TCKTestErrorException {
        Object object = this.stateLock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            long timeoutAt = now + (long)this.utils().getTestTimeout();
            while (now < timeoutAt && !this.getFlag(flagName) && this.sbbOrResourceException == null) {
                try {
                    this.stateLock.wait(timeoutAt - now);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
            }
            if (this.sbbOrResourceException != null) {
                throw new TCKTestErrorException("Received an Exception from an SBB or TCK resource", this.sbbOrResourceException);
            }
            if (!this.getFlag(flagName)) {
                throw new OperationTimedOutException("Timed out waiting for flag to be set:" + flagName);
            }
        }
    }

    private void setACKReceived(String eventHandlerName) {
        this.setFlag(EVENT_ACK_PREFIX + eventHandlerName);
    }

    private boolean isACKReceived(String eventHandlerName) {
        return this.getFlag(EVENT_ACK_PREFIX + eventHandlerName);
    }

    private boolean isRolledBack(String eventHandlerName) {
        return this.getFlag(ROLLED_BACK_FLAG_PREFIX + eventHandlerName);
    }

    private void waitForACK(String eventHandlerName) throws OperationTimedOutException, TCKTestErrorException {
        this.waitForFlag(EVENT_ACK_PREFIX + eventHandlerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEventProcessingFinished(String eventType) {
        Object object = this.stateLock;
        synchronized (object) {
            Long eventObjectID = (Long)this.eventObjectIDs.get(eventType);
            if (eventObjectID != null) {
                return this.processedEvents.contains(eventObjectID);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEventProcessing(String eventType) throws OperationTimedOutException, TCKTestErrorException {
        Object object = this.stateLock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            long timeoutAt = now + (long)this.utils().getTestTimeout();
            while (now < timeoutAt && !this.isEventProcessingFinished(eventType) && this.sbbOrResourceException == null) {
                try {
                    this.stateLock.wait(timeoutAt - now);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
            }
            if (this.sbbOrResourceException != null) {
                throw new TCKTestErrorException("Received an Exception from an SBB or TCK resource", this.sbbOrResourceException);
            }
            if (!this.isEventProcessingFinished(eventType)) {
                throw new OperationTimedOutException("Timed out waiting for event to be processed:" + eventType);
            }
            this.getLog().fine("Event processing has finished for " + eventType + " event");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockEventHandler(String eventHandlerName) {
        Object object = this.stateLock;
        synchronized (object) {
            while (!this.getFlag(STOP_BLOCKING_PREFIX + eventHandlerName) && this.sbbOrResourceException == null) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void stopBlockingFor(String eventHandlerName) {
        this.setFlag(STOP_BLOCKING_PREFIX + eventHandlerName);
    }

    private class ResourceListenerImpl
    extends BaseTCKResourceListener {
        private ResourceListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object onSbbCall(Object argument) throws Exception {
            Object object = Test2004Test.this.stateLock;
            synchronized (object) {
                Map args = (Map)argument;
                String eventHandlerName = (String)args.get("handler");
                if (args.containsKey("SBB_ROLLED_BACK")) {
                    Test2004Test.this.setFlag(Test2004Test.ROLLED_BACK_FLAG_PREFIX + eventHandlerName);
                } else {
                    Test2004Test.this.setACKReceived(eventHandlerName);
                    Object value = args.get("value");
                    Test2004Test.this.getLog().fine("CALLTEST: " + eventHandlerName + " entering callback");
                    if (eventHandlerName.equals("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1")) {
                        Test2004Test.this.handleX1();
                    } else if (eventHandlerName.equals("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2")) {
                        Test2004Test.this.handleX2(value);
                    } else if (eventHandlerName.equals("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X3")) {
                        Test2004Test.this.handleX3(value);
                    } else if (eventHandlerName.equals("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1")) {
                        Test2004Test.this.handleY1(value);
                    } else if (eventHandlerName.equals("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y2")) {
                        Test2004Test.this.handleY2(value);
                    } else if (eventHandlerName.equals("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y3")) {
                        Test2004Test.this.handleY3();
                    }
                    Test2004Test.this.getLog().fine("CALLTEST: " + eventHandlerName + " exiting callback");
                }
                Test2004Test.this.stateLock.notifyAll();
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEventProcessingSuccessful(long eventObjectID) throws RemoteException {
            Test2004Test.this.getLog().fine("onEventProcessingSuccessful(): eventObjectID=" + eventObjectID);
            Object object = Test2004Test.this.stateLock;
            synchronized (object) {
                Test2004Test.this.processedEvents.add(new Long(eventObjectID));
                Test2004Test.this.stateLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEventProcessingFailed(long eventObjectID, String message, Exception exception) throws RemoteException {
            Test2004Test.this.getLog().warning("onEventProcessingFailed(): eventObjectID=" + eventObjectID + "; message=" + message);
            Test2004Test.this.getLog().warning(exception);
            Object object = Test2004Test.this.stateLock;
            synchronized (object) {
                Test2004Test.this.processedEvents.add(new Long(eventObjectID));
                StringBuffer buf = new StringBuffer("Received onEventProcessingFailed() callback for TCKResourceEvent with object ID=" + eventObjectID);
                if (message != null) {
                    buf.append(message);
                }
                this.onException(new TCKTestErrorException(buf.toString(), exception));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(Exception exception) throws RemoteException {
            Test2004Test.this.getLog().warning("Received an Exception via TCKResourceListener.onException():");
            Test2004Test.this.getLog().warning(exception);
            Object object = Test2004Test.this.stateLock;
            synchronized (object) {
                Test2004Test.this.sbbOrResourceException = exception;
                Test2004Test.this.stateLock.notifyAll();
            }
        }
    }
}

