/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.common;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.infra.jmx.NotificationBroadcasterProxyImpl;
import com.opencloud.sleetck.lib.testsuite.usage.common.UsageMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.MBeanFacade;
import com.opencloud.sleetck.lib.testutils.jmx.impl.EmptyArrays;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.slee.InvalidStateException;
import javax.slee.management.ManagementException;
import javax.slee.management.NotificationSource;
import javax.slee.usage.SampleStatistics;

public class UsageMBeanProxyImpl
extends NotificationBroadcasterProxyImpl
implements UsageMBeanProxy {
    private ObjectName objName;
    private MBeanFacade facade;

    public UsageMBeanProxyImpl(ObjectName objName, MBeanFacade facade) {
        super(objName, facade);
        this.objName = objName;
        this.facade = facade;
    }

    public void close() throws InvalidStateException, ManagementException, TCKTestErrorException {
        try {
            this.facade.invoke(this.objName, "close", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", re);
        }
        catch (RuntimeMBeanException rmbe) {
            throw rmbe.getTargetException();
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof InvalidStateException) {
                throw (InvalidStateException)((Object)enclosed);
            }
            if (enclosed instanceof ManagementException) {
                throw (ManagementException)((Object)enclosed);
            }
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught undeclared exception", enclosed);
        }
    }

    public String getUsageParameterSet() throws ManagementException, TCKTestErrorException {
        try {
            return (String)this.facade.invoke(this.objName, "getUsageParameterSet", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", re);
        }
        catch (RuntimeMBeanException rmbe) {
            throw rmbe.getTargetException();
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof ManagementException) {
                throw (ManagementException)((Object)enclosed);
            }
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught undeclared exception", enclosed);
        }
    }

    public ObjectName getUsageNotificationManagerMBean() throws ManagementException, TCKTestErrorException {
        try {
            return (ObjectName)this.facade.invoke(this.objName, "getUsageNotificationManagerMBean", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", re);
        }
        catch (RuntimeMBeanException rmbe) {
            throw rmbe.getTargetException();
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof ManagementException) {
                throw (ManagementException)((Object)enclosed);
            }
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught undeclared exception", enclosed);
        }
    }

    public NotificationSource getNotificationSource() throws ManagementException, TCKTestErrorException {
        try {
            return (NotificationSource)this.facade.invoke(this.objName, "getNotificationSource", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", re);
        }
        catch (RuntimeMBeanException rmbe) {
            throw rmbe.getTargetException();
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof ManagementException) {
                throw (ManagementException)((Object)enclosed);
            }
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught undeclared exception", enclosed);
        }
    }

    public void resetAllUsageParameters() throws ManagementException, TCKTestErrorException {
        try {
            this.facade.invoke(this.objName, "resetAllUsageParameters", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", re);
        }
        catch (RuntimeMBeanException rmbe) {
            throw rmbe.getTargetException();
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof ManagementException) {
                throw (ManagementException)((Object)enclosed);
            }
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught undeclared exception", enclosed);
        }
    }

    public long getFirstCount(boolean reset) throws ManagementException, TCKTestErrorException {
        try {
            Boolean b = reset;
            Long l = (Long)this.facade.invoke(this.objName, "getFirstCount", new Object[]{b}, new String[]{"boolean"});
            return l;
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", re);
        }
        catch (RuntimeMBeanException rmbe) {
            throw rmbe.getTargetException();
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof ManagementException) {
                throw (ManagementException)((Object)enclosed);
            }
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught undeclared exception", enclosed);
        }
    }

    public long getSecondCount(boolean reset) throws ManagementException, TCKTestErrorException {
        try {
            Boolean b = reset;
            Long l = (Long)this.facade.invoke(this.objName, "getSecondCount", new Object[]{b}, new String[]{"boolean"});
            return l;
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", re);
        }
        catch (RuntimeMBeanException rmbe) {
            throw rmbe.getTargetException();
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof ManagementException) {
                throw (ManagementException)((Object)enclosed);
            }
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught undeclared exception", enclosed);
        }
    }

    public SampleStatistics getTimeBetweenNewConnections(boolean reset) throws ManagementException, TCKTestErrorException {
        try {
            Boolean b = reset;
            return (SampleStatistics)this.facade.invoke(this.objName, "getTimeBetweenNewConnections", new Object[]{b}, new String[]{"boolean"});
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", re);
        }
        catch (RuntimeMBeanException rmbe) {
            throw rmbe.getTargetException();
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof ManagementException) {
                throw (ManagementException)((Object)enclosed);
            }
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught undeclared exception", enclosed);
        }
    }

    public SampleStatistics getTimeBetweenErrors(boolean reset) throws ManagementException, TCKTestErrorException {
        try {
            Boolean b = reset;
            return (SampleStatistics)this.facade.invoke(this.objName, "getTimeBetweenErrors", new Object[]{b}, new String[]{"boolean"});
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", re);
        }
        catch (RuntimeMBeanException rmbe) {
            throw rmbe.getTargetException();
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof ManagementException) {
                throw (ManagementException)((Object)enclosed);
            }
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught undeclared exception", enclosed);
        }
    }
}

