/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.sbb;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageSbbInstructions;
import com.opencloud.sleetck.lib.testsuite.usage.sbb.GenericUsageParameterInterface;
import javax.slee.ActivityContextInterface;
import javax.slee.usage.UnrecognizedUsageParameterSetNameException;

public abstract class GenericUsageSbb
extends BaseTCKSbb {
    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            GenericUsageSbbInstructions instructions = GenericUsageSbbInstructions.fromExported(event.getMessage());
            this.doUpdates(instructions);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void doUpdates(GenericUsageSbbInstructions instructions) {
        try {
            int i;
            long[] values;
            GenericUsageParameterInterface usageParameterInterface;
            String parameterSetName = instructions.getParameterSetName();
            this.getSbbContext().getTracer("GenericUsageSbb").fine("doUpdates(): received instructions: " + instructions);
            GenericUsageParameterInterface genericUsageParameterInterface = usageParameterInterface = parameterSetName == null ? this.getDefaultSbbUsageParameterSet() : this.getSbbUsageParameterSet(parameterSetName);
            if (instructions.getFirstCountIncrements() != null) {
                values = instructions.getFirstCountIncrements();
                for (i = 0; i < values.length; ++i) {
                    this.getSbbContext().getTracer("GenericUsageSbb").fine("doUpdates(): incrementing FirstCount by " + values[i]);
                    usageParameterInterface.incrementFirstCount(values[i]);
                }
            }
            if (instructions.getSecondCountIncrements() != null) {
                values = instructions.getSecondCountIncrements();
                for (i = 0; i < values.length; ++i) {
                    this.getSbbContext().getTracer("GenericUsageSbb").fine("doUpdates(): incrementing SecondCount by " + values[i]);
                    usageParameterInterface.incrementSecondCount(values[i]);
                }
            }
            if (instructions.getTimeBetweenNewConnectionsSamples() != null) {
                values = instructions.getTimeBetweenNewConnectionsSamples();
                for (i = 0; i < values.length; ++i) {
                    this.getSbbContext().getTracer("GenericUsageSbb").fine("doUpdates(): adding TimeBetweenNewConnections sample of " + values[i]);
                    usageParameterInterface.sampleTimeBetweenNewConnections(values[i]);
                }
            }
            if (instructions.getTimeBetweenErrorsSamples() != null) {
                values = instructions.getTimeBetweenErrorsSamples();
                for (i = 0; i < values.length; ++i) {
                    this.getSbbContext().getTracer("GenericUsageSbb").fine("doUpdates(): adding TimeBetweenErrors sample of " + values[i]);
                    usageParameterInterface.sampleTimeBetweenErrors(values[i]);
                }
            }
            this.getSbbContext().getTracer("GenericUsageSbb").fine("doUpdates(): replying to test");
            TCKSbbUtils.getResourceInterface().sendSbbMessage(instructions.toExported());
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public abstract GenericUsageParameterInterface getDefaultSbbUsageParameterSet();

    public abstract GenericUsageParameterInterface getSbbUsageParameterSet(String var1) throws UnrecognizedUsageParameterSetNameException;
}

