/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.sbb;

import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageSbbInstructions;
import com.opencloud.sleetck.lib.testsuite.usage.common.UsageMBeanProxy;
import com.opencloud.sleetck.lib.testsuite.usage.common.UsageMBeanProxyImpl;
import com.opencloud.sleetck.lib.testsuite.usage.sbb.BaseUsageTest;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.QueuingNotificationListener;
import com.opencloud.sleetck.lib.testutils.jmx.MBeanProxyFactory;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceUsageMBeanProxy;
import java.rmi.RemoteException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.usage.SampleStatistics;

public class Test1111056Test
extends BaseUsageTest {
    public static final int TEST_ID = 1111055;
    public static final String PARAM_SET_NAME = "Param set name";
    private TCKResourceListenerImpl resourceListener;
    private SbbID sbbid;
    private MBeanProxyFactory proxyFactory;
    private FutureResult result;
    private QueuingNotificationListener notificationListenerA;
    private QueuingNotificationListener notificationListenerB;

    public TCKTestResult run() throws Exception {
        Notification ntnB;
        Notification ntnA;
        TCKActivityID activityID = this.utils().getResourceInterface().createActivity("token activity");
        GenericUsageSbbInstructions instr = new GenericUsageSbbInstructions(null);
        instr.addSecondCountIncrement(1L);
        instr.addTimeBetweenNewConnectionsSamples(36L);
        this.getLog().info("firing event to Sbb");
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", instr.toExported(), activityID, null);
        try {
            ntnA = this.notificationListenerA.nextNotification();
            this.getLog().fine("Got notification: " + ntnA.toString());
            if (!"javax.slee.management.usage.sbb".equals(ntnA.getType())) {
                return TCKTestResult.failed(1111200, "Notification type is not a SbbNotification.");
            }
        }
        catch (OperationTimedOutException e) {
            return TCKTestResult.failed(1111054, "Did not receive notification A in time");
        }
        try {
            ntnB = this.notificationListenerB.nextNotification();
            this.getLog().fine("Got notification: " + ntnB.toString());
        }
        catch (OperationTimedOutException e) {
            return TCKTestResult.failed(1111054, "Did not receive notification B in time");
        }
        try {
            if (ntnA.equals(ntnB)) {
                return TCKTestResult.failed(1111054, "2 notifications from different Services are equal");
            }
        }
        catch (Exception e) {
            this.utils().getLog().error(e);
            return TCKTestResult.failed(new TCKTestFailureException(1111055, "Exception occurred comparing Notifications", e));
        }
        try {
            for (int i = 0; i < this.services.length; ++i) {
                UsageMBeanProxy usage = this.getSbbUsageMBean(this.services[i]);
                long stats = usage.getFirstCount(false);
                if (stats != 0L) {
                    return TCKTestResult.failed(1111055, "Usage parameter 'firstCount' had unexpected value.");
                }
                stats = usage.getSecondCount(false);
                if (stats != 1L) {
                    return TCKTestResult.failed(1111055, "Usage parameter 'secondCount' had unexpected value.");
                }
                SampleStatistics sample = usage.getTimeBetweenNewConnections(false);
                this.getLog().fine("timeBetweenNewConnections is: " + sample.getSampleCount());
                this.getLog().fine("timeBetweenNewConnections is: " + sample.getSampleCount());
                this.getLog().fine("timeBetweenNewConnections is: " + sample.getSampleCount());
                if (sample.getSampleCount() != 1L) {
                    return TCKTestResult.failed(1111055, "Usage parameter 'timeBetweenConnections' had unexpected value.");
                }
                sample = usage.getTimeBetweenErrors(false);
                this.getLog().fine("timeBetweenErrors is: " + sample.getSampleCount());
                if (sample.getSampleCount() == 0L) continue;
                return TCKTestResult.failed(1111055, "Usage parameter 'timeBetweenErrors' had unexpected value.");
            }
        }
        catch (Exception e) {
            this.utils().getLog().error(e);
            return TCKTestResult.failed(new TCKTestFailureException(1111055, "Exception occurred checking default usage parameters", e));
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.sbbid = new SbbID("GenericUsageSbb", "jain.slee.tck", "1.1");
        this.utils().getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils().getResourceInterface().setResourceListener(this.resourceListener);
        this.proxyFactory = this.utils().getMBeanProxyFactory();
        this.notificationListenerA = new QueuingNotificationListener(this.utils());
        this.notificationListenerB = new QueuingNotificationListener(this.utils());
        if (2 != this.services.length) {
            throw new TCKTestErrorException("There should be 2 services deployed.");
        }
        this.getSbbUsageMBean(this.services[0]).addNotificationListener(this.notificationListenerA, null, null);
        this.getSbbUsageMBean(this.services[1]).addNotificationListener(this.notificationListenerB, null, null);
    }

    public void tearDown() throws Exception {
        UsageMBeanProxy u = this.getSbbUsageMBean(this.services[0]);
        u.removeNotificationListener(this.notificationListenerA);
        u.close();
        u = this.getSbbUsageMBean(this.services[1]);
        u.removeNotificationListener(this.notificationListenerB);
        u.close();
        super.tearDown();
    }

    private UsageMBeanProxy getSbbUsageMBean(ServiceID serviceID) throws TCKTestErrorException {
        try {
            ObjectName n = this.utils().getServiceManagementMBeanProxy().getServiceUsageMBean(serviceID);
            ServiceUsageMBeanProxy serviceUsage = this.proxyFactory.createServiceUsageMBeanProxy(n);
            n = serviceUsage.getSbbUsageMBean(this.sbbid);
            return new UsageMBeanProxyImpl(n, this.utils().getMBeanFacade());
        }
        catch (Exception e) {
            throw new TCKTestErrorException("Failed to get SBB usage proxy.", e);
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID activity) throws RemoteException {
            Test1111056Test.this.utils().getLog().fine("Received message from SBB: " + message.getMessage().toString());
        }

        public void onException(Exception e) throws RemoteException {
            Test1111056Test.this.utils().getLog().warning("Received exception from SBB.");
            Test1111056Test.this.utils().getLog().warning(e);
            Test1111056Test.this.result.setError(e);
        }
    }
}

