/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.scope;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testsuite.usage.common.UsageMBeanLookup;
import com.opencloud.sleetck.lib.testutils.QueuingNotificationListener;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;

public class Test2243Test
extends AbstractSleeTCKTest {
    private static final int TEST_ID = 2243;
    private static final String PARAMETER_SET_NAME = "Test2243Test-ParameterSet";
    private UsageMBeanLookup mBeanLookupParent;
    private UsageMBeanLookup mBeanLookupChild;
    private QueuingResourceListener resourceListener;
    private QueuingNotificationListener notificationListenerParent;
    private QueuingNotificationListener notificationListenerChild;

    public TCKTestResult run() throws Exception {
        int i;
        TCKActivityID activityID = this.utils().getResourceInterface().createActivity("token activity");
        this.getLog().info("firing event to Sbb");
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", null, activityID, null);
        this.getLog().info("waiting for reply");
        this.resourceListener.nextMessage();
        this.getLog().info("received reply");
        this.getLog().info("waiting for 2 usage notifications for each Sbb");
        for (i = 0; i < 2; ++i) {
            this.notificationListenerParent.nextNotification();
        }
        for (i = 0; i < 2; ++i) {
            this.notificationListenerChild.nextNotification();
        }
        this.getLog().info("received all 4 usage notifications");
        this.getLog().info("checking that parameter updates to both Sbb were independent");
        long fooForParent = this.mBeanLookupParent.getNamedSbbUsageMBeanProxy(PARAMETER_SET_NAME).getCounterParameter("foo", false);
        long fooForChild = this.mBeanLookupChild.getNamedSbbUsageMBeanProxy(PARAMETER_SET_NAME).getCounterParameter("foo", false);
        double barMeanForParent = this.mBeanLookupParent.getNamedSbbUsageMBeanProxy(PARAMETER_SET_NAME).getSampleParameter("bar", false).getMean();
        double barMeanForChild = this.mBeanLookupChild.getNamedSbbUsageMBeanProxy(PARAMETER_SET_NAME).getSampleParameter("bar", false).getMean();
        String expectedValues = "fooForParent=1,fooForChild=3barMeanForParent=2barMeanForChild=4";
        String actualValues = "fooForParent=" + fooForParent + ",fooForChild=" + fooForChild + "barMeanForParent=" + barMeanForParent + "barMeanForChild=" + barMeanForChild;
        if (fooForParent == 4L || fooForChild == 4L) {
            return TCKTestResult.failed(2243, "Updates to foo usage parameter in different SBBs were combined -- the parameter sets should be independent.");
        }
        if (barMeanForParent == 3.0 || barMeanForChild == 3.0) {
            return TCKTestResult.failed(2243, "Updates to bar usage parameter in different parameter sets were combined -- the parameter sets should be independent.");
        }
        if (fooForParent != 1L || fooForChild != 3L || barMeanForParent != 2.0 || barMeanForChild != 4.0) {
            return TCKTestResult.failed(2243, "Usage parameter values were not set as expected. Expected values: " + expectedValues + ", actual values: " + actualValues);
        }
        this.getLog().info("parameter checks ok");
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.resourceListener = new QueuingResourceListener(this.utils());
        this.setResourceListener(this.resourceListener);
        this.mBeanLookupParent = new UsageMBeanLookup("Test2243Service", "Test2243Sbb", this.utils());
        this.mBeanLookupChild = new UsageMBeanLookup("Test2243Service", "Test2243SbbChild", this.utils());
        this.mBeanLookupParent.getServiceUsageMBeanProxy().createUsageParameterSet(this.mBeanLookupParent.getSbbID(), PARAMETER_SET_NAME);
        this.mBeanLookupChild.getServiceUsageMBeanProxy().createUsageParameterSet(this.mBeanLookupChild.getSbbID(), PARAMETER_SET_NAME);
        this.notificationListenerParent = new QueuingNotificationListener(this.utils());
        this.notificationListenerChild = new QueuingNotificationListener(this.utils());
        this.mBeanLookupParent.getNamedSbbUsageMBeanProxy(PARAMETER_SET_NAME).addNotificationListener(this.notificationListenerParent, null, null);
        this.mBeanLookupChild.getNamedSbbUsageMBeanProxy(PARAMETER_SET_NAME).addNotificationListener(this.notificationListenerChild, null, null);
    }

    public void tearDown() throws Exception {
        if (this.mBeanLookupParent != null && this.notificationListenerParent != null) {
            this.mBeanLookupParent.getNamedSbbUsageMBeanProxy(PARAMETER_SET_NAME).removeNotificationListener(this.notificationListenerParent);
        }
        if (this.mBeanLookupChild != null && this.notificationListenerChild != null) {
            this.mBeanLookupChild.getNamedSbbUsageMBeanProxy(PARAMETER_SET_NAME).removeNotificationListener(this.notificationListenerChild);
        }
        if (this.mBeanLookupParent != null) {
            this.mBeanLookupParent.closeAllMBeans();
        }
        if (this.mBeanLookupChild != null) {
            this.mBeanLookupChild.closeAllMBeans();
        }
        super.tearDown();
    }
}

