/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testutils;

import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import java.util.LinkedList;
import javax.management.Notification;
import javax.management.NotificationListener;

public class QueuingNotificationListener
implements NotificationListener {
    private final SleeTCKTestUtils utils;
    private final LinkedList queue = new LinkedList();

    public QueuingNotificationListener(SleeTCKTestUtils sleeTCKTestUtils) {
        this.utils = sleeTCKTestUtils;
    }

    public synchronized Notification nextNotification() throws OperationTimedOutException {
        long l = System.currentTimeMillis();
        long l2 = l + (long)this.utils.getTestTimeout();
        while (l < l2) {
            while (this.queue.isEmpty() && l < l2) {
                try {
                    this.wait(l2 - l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l = System.currentTimeMillis();
            }
            if (this.queue.isEmpty()) continue;
            return (Notification)this.queue.removeFirst();
        }
        throw new OperationTimedOutException("Timed out waiting for a Notification");
    }

    public final synchronized void handleNotification(Notification notification, Object object) {
        this.utils.getLog().info("Received Notification");
        this.queue.addLast(notification);
        this.notify();
    }
}

