/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testutils;

import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import com.opencloud.util.Future;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.slee.management.SleeState;
import javax.slee.management.SleeStateChangeNotification;

public class SleeStarter {
    private static final String SUCCESS = "SUCCESS";

    public static void startSlee(SleeManagementMBeanProxy sleeManagementMBeanProxy, long l) throws TCKTestErrorException {
        SleeStarter.startSlee(sleeManagementMBeanProxy, l, false);
    }

    public static void restartSlee(SleeManagementMBeanProxy sleeManagementMBeanProxy, long l) throws TCKTestErrorException {
        SleeStarter.startSlee(sleeManagementMBeanProxy, l, true);
    }

    private static void startSlee(SleeManagementMBeanProxy sleeManagementMBeanProxy, long l, boolean bl) throws TCKTestErrorException {
        Object object;
        SleeStateMachine sleeStateMachine;
        block19: {
            SleeState sleeState;
            Future future;
            block18: {
                future = new Future();
                sleeStateMachine = null;
                sleeState = sleeManagementMBeanProxy.getState();
                if (!sleeState.isRunning() || bl) break block18;
                try {
                    if (sleeStateMachine != null) {
                        sleeManagementMBeanProxy.removeNotificationListener(sleeStateMachine);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            sleeStateMachine = new SleeStateMachine(sleeManagementMBeanProxy, future);
            sleeManagementMBeanProxy.addNotificationListener(sleeStateMachine, null, null);
            if (sleeState.isRunning()) {
                sleeManagementMBeanProxy.stop();
            }
            sleeStateMachine.handleSleeState();
            object = future.getValue(l);
            if (object != SUCCESS) break block19;
            try {
                if (sleeStateMachine != null) {
                    sleeManagementMBeanProxy.removeNotificationListener(sleeStateMachine);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        try {
            try {
                throw (Exception)object;
            }
            catch (Future.TimeoutException timeoutException) {
                throw new OperationTimedOutException("Timed out while trying to start the Slee: " + timeoutException);
            }
            catch (TCKTestErrorException tCKTestErrorException) {
                throw tCKTestErrorException;
            }
            catch (Exception exception) {
                throw new TCKTestErrorException("Caught exception while trying to start the Slee: ", exception);
            }
        }
        catch (Throwable throwable) {
            try {
                if (sleeStateMachine != null) {
                    sleeManagementMBeanProxy.removeNotificationListener(sleeStateMachine);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static class SleeStateMachine
    implements NotificationListener {
        private final SleeManagementMBeanProxy mgmtProxy;
        private final Future result;
        private boolean sleeStarted = false;

        public SleeStateMachine(SleeManagementMBeanProxy sleeManagementMBeanProxy, Future future) {
            this.mgmtProxy = sleeManagementMBeanProxy;
            this.result = future;
        }

        public void handleNotification(Notification notification, Object object) {
            if (notification instanceof SleeStateChangeNotification) {
                this.handleSleeState();
            }
        }

        public synchronized void handleSleeState() {
            if (this.result.isSet()) {
                return;
            }
            try {
                SleeState sleeState = this.mgmtProxy.getState();
                if (sleeState.isRunning()) {
                    this.result.setValue(SleeStarter.SUCCESS);
                    return;
                }
                if (this.sleeStarted && (sleeState.isStopped() || sleeState.isStopping())) {
                    this.result.setValue(new TCKTestErrorException("Entered STOPPING state after STARTING state - the Slee failed to start."));
                }
                if (sleeState.isStopped()) {
                    this.mgmtProxy.start();
                    this.sleeStarted = true;
                    return;
                }
            }
            catch (Exception exception) {
                this.result.setValue(exception);
            }
        }
    }
}

