/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testutils.jmx.impl;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.testutils.jmx.MBeanFacade;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceUsageMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.EmptyArrays;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.slee.InvalidArgumentException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.UnrecognizedSbbException;
import javax.slee.management.ManagementException;
import javax.slee.management.UsageParameterSetNameAlreadyExistsException;
import javax.slee.usage.UnrecognizedUsageParameterSetNameException;

public class ServiceUsageMBeanProxyImpl
implements ServiceUsageMBeanProxy {
    private ObjectName objName;
    private MBeanFacade facade;

    public ServiceUsageMBeanProxyImpl(ObjectName objectName, MBeanFacade mBeanFacade) {
        this.objName = objectName;
        this.facade = mBeanFacade;
    }

    public ObjectName getSbbUsageMBean(SbbID sbbID) throws NullPointerException, UnrecognizedSbbException, InvalidArgumentException, ManagementException, TCKTestErrorException {
        try {
            return (ObjectName)this.facade.invoke(this.objName, "getSbbUsageMBean", new Object[]{sbbID}, new String[]{"javax.slee.SbbID"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof NullPointerException) {
                throw (NullPointerException)exception;
            }
            if (exception instanceof UnrecognizedSbbException) {
                throw (UnrecognizedSbbException)((Object)exception);
            }
            if (exception instanceof InvalidArgumentException) {
                throw (InvalidArgumentException)((Object)exception);
            }
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public void close() throws ManagementException, TCKTestErrorException {
        try {
            this.facade.invoke(this.objName, "close", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public ServiceID getService() throws ManagementException, TCKTestErrorException {
        try {
            return (ServiceID)this.facade.invoke(this.objName, "getService", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public void removeUsageParameterSet(SbbID sbbID, String string) throws NullPointerException, UnrecognizedSbbException, InvalidArgumentException, UnrecognizedUsageParameterSetNameException, ManagementException, TCKTestErrorException {
        try {
            this.facade.invoke(this.objName, "removeUsageParameterSet", new Object[]{sbbID, string}, new String[]{"javax.slee.SbbID", "java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof NullPointerException) {
                throw (NullPointerException)exception;
            }
            if (exception instanceof UnrecognizedSbbException) {
                throw (UnrecognizedSbbException)((Object)exception);
            }
            if (exception instanceof InvalidArgumentException) {
                throw (InvalidArgumentException)((Object)exception);
            }
            if (exception instanceof UnrecognizedUsageParameterSetNameException) {
                throw (UnrecognizedUsageParameterSetNameException)((Object)exception);
            }
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public void createUsageParameterSet(SbbID sbbID, String string) throws NullPointerException, UnrecognizedSbbException, InvalidArgumentException, UsageParameterSetNameAlreadyExistsException, ManagementException, TCKTestErrorException {
        try {
            this.facade.invoke(this.objName, "createUsageParameterSet", new Object[]{sbbID, string}, new String[]{"javax.slee.SbbID", "java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof NullPointerException) {
                throw (NullPointerException)exception;
            }
            if (exception instanceof UnrecognizedSbbException) {
                throw (UnrecognizedSbbException)((Object)exception);
            }
            if (exception instanceof InvalidArgumentException) {
                throw (InvalidArgumentException)((Object)exception);
            }
            if (exception instanceof UsageParameterSetNameAlreadyExistsException) {
                throw (UsageParameterSetNameAlreadyExistsException)((Object)exception);
            }
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public ObjectName getSbbUsageNotificationManagerMBean(SbbID sbbID) throws NullPointerException, UnrecognizedSbbException, InvalidArgumentException, ManagementException, TCKTestErrorException {
        try {
            return (ObjectName)this.facade.invoke(this.objName, "getSbbUsageNotificationManagerMBean", new Object[]{sbbID}, new String[]{"javax.slee.SbbID"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof NullPointerException) {
                throw (NullPointerException)exception;
            }
            if (exception instanceof UnrecognizedSbbException) {
                throw (UnrecognizedSbbException)((Object)exception);
            }
            if (exception instanceof InvalidArgumentException) {
                throw (InvalidArgumentException)((Object)exception);
            }
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public ObjectName getSbbUsageMBean(SbbID sbbID, String string) throws NullPointerException, UnrecognizedSbbException, InvalidArgumentException, UnrecognizedUsageParameterSetNameException, ManagementException, TCKTestErrorException {
        try {
            return (ObjectName)this.facade.invoke(this.objName, "getSbbUsageMBean", new Object[]{sbbID, string}, new String[]{"javax.slee.SbbID", "java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof NullPointerException) {
                throw (NullPointerException)exception;
            }
            if (exception instanceof UnrecognizedSbbException) {
                throw (UnrecognizedSbbException)((Object)exception);
            }
            if (exception instanceof InvalidArgumentException) {
                throw (InvalidArgumentException)((Object)exception);
            }
            if (exception instanceof UnrecognizedUsageParameterSetNameException) {
                throw (UnrecognizedUsageParameterSetNameException)((Object)exception);
            }
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public String[] getUsageParameterSets(SbbID sbbID) throws NullPointerException, UnrecognizedSbbException, InvalidArgumentException, ManagementException, TCKTestErrorException {
        try {
            return (String[])this.facade.invoke(this.objName, "getUsageParameterSets", new Object[]{sbbID}, new String[]{"javax.slee.SbbID"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof NullPointerException) {
                throw (NullPointerException)exception;
            }
            if (exception instanceof UnrecognizedSbbException) {
                throw (UnrecognizedSbbException)((Object)exception);
            }
            if (exception instanceof InvalidArgumentException) {
                throw (InvalidArgumentException)((Object)exception);
            }
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public void resetAllUsageParameters(SbbID sbbID) throws NullPointerException, UnrecognizedSbbException, InvalidArgumentException, ManagementException, TCKTestErrorException {
        try {
            this.facade.invoke(this.objName, "resetAllUsageParameters", new Object[]{sbbID}, new String[]{"javax.slee.SbbID"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof NullPointerException) {
                throw (NullPointerException)exception;
            }
            if (exception instanceof UnrecognizedSbbException) {
                throw (UnrecognizedSbbException)((Object)exception);
            }
            if (exception instanceof InvalidArgumentException) {
                throw (InvalidArgumentException)((Object)exception);
            }
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public void resetAllUsageParameters() throws ManagementException, TCKTestErrorException {
        try {
            this.facade.invoke(this.objName, "resetAllUsageParameters", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }
}

