/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testutils.jmx.impl;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.infra.jmx.NotificationBroadcasterProxyImpl;
import com.opencloud.sleetck.lib.testutils.jmx.MBeanFacade;
import com.opencloud.sleetck.lib.testutils.jmx.UsageMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.EmptyArrays;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.slee.InvalidStateException;
import javax.slee.management.ManagementException;
import javax.slee.management.NotificationSource;

public class UsageMBeanProxyImpl
extends NotificationBroadcasterProxyImpl
implements UsageMBeanProxy {
    private ObjectName objName;
    private MBeanFacade facade;

    public UsageMBeanProxyImpl(ObjectName objectName, MBeanFacade mBeanFacade) {
        super(objectName, mBeanFacade);
        this.objName = objectName;
        this.facade = mBeanFacade;
    }

    public void close() throws InvalidStateException, ManagementException, TCKTestErrorException {
        try {
            this.facade.invoke(this.objName, "close", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof InvalidStateException) {
                throw (InvalidStateException)((Object)exception);
            }
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public String getUsageParameterSet() throws ManagementException, TCKTestErrorException {
        try {
            return (String)this.facade.invoke(this.objName, "getUsageParameterSet", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public ObjectName getUsageNotificationManagerMBean() throws ManagementException, TCKTestErrorException {
        try {
            return (ObjectName)this.facade.invoke(this.objName, "getUsageNotificationManagerMBean", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public NotificationSource getNotificationSource() throws ManagementException, TCKTestErrorException {
        try {
            return (NotificationSource)this.facade.invoke(this.objName, "getNotificationSource", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }

    public void resetAllUsageParameters() throws ManagementException, TCKTestErrorException {
        try {
            this.facade.invoke(this.objName, "resetAllUsageParameters", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.invoke()", reflectionException);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TCKTestErrorException("Caught undeclared exception", exception);
        }
    }
}

