/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.propertyset.hibernate5;

import com.opensymphony.module.propertyset.hibernate5.HibernateConfigurationProvider;
import com.opensymphony.module.propertyset.hibernate5.HibernatePropertySetDAO;
import com.opensymphony.module.propertyset.hibernate5.HibernatePropertySetDAOImpl;
import com.opensymphony.module.propertyset.hibernate5.PropertySetItemImpl;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class DefaultHibernateConfigurationProvider
implements HibernateConfigurationProvider {
    private Configuration configuration;
    private HibernatePropertySetDAO propertySetDAO;
    private SessionFactory sessionFactory;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public HibernatePropertySetDAO getPropertySetDAO() {
        if (this.propertySetDAO == null) {
            this.propertySetDAO = new HibernatePropertySetDAOImpl(this.sessionFactory);
        }
        return this.propertySetDAO;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setupConfiguration(Map configurationProperties) {
        try {
            this.configuration = new Configuration().addClass(PropertySetItemImpl.class);
            for (String key : configurationProperties.keySet()) {
                if (!key.startsWith("hibernate4")) continue;
                this.configuration.setProperty(key, (String)configurationProperties.get(key));
            }
            this.sessionFactory = this.configuration.buildSessionFactory();
        }
        catch (HibernateException hibernateException) {
            // empty catch block
        }
    }
}

