/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.propertyset.hibernate5;

import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.hibernate5.HibernatePropertySetDAO;
import com.opensymphony.module.propertyset.hibernate5.HibernatePropertySetDAOUtils;
import com.opensymphony.module.propertyset.hibernate5.PropertySetItem;
import com.opensymphony.module.propertyset.hibernate5.PropertySetItemImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class HibernatePropertySetDAOImpl
implements HibernatePropertySetDAO {
    private final SessionFactory sessionFactory;

    public HibernatePropertySetDAOImpl(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setImpl(PropertySetItem item, boolean isUpdate) {
        try {
            Session session = this.sessionFactory.getCurrentSession();
            if (isUpdate) {
                session.update((Object)item);
            } else {
                session.save((Object)item);
            }
            session.flush();
        }
        catch (HibernateException he) {
            throw new PropertyException("Could not save key '" + item.getKey() + "':" + he.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getKeys(String entityName, Long entityId, String prefix, int type) {
        List list;
        Session session = this.sessionFactory.getCurrentSession();
        try {
            list = HibernatePropertySetDAOUtils.getKeysImpl(session, entityName, entityId, prefix, type);
        }
        catch (HibernateException ignored) {
            list = Collections.emptyList();
        }
        finally {
            try {
                session.flush();
            }
            catch (Exception exception) {}
        }
        return list;
    }

    public PropertySetItem create(String entityName, long entityId, String key) {
        return new PropertySetItemImpl(entityName, entityId, key);
    }

    public PropertySetItem findByKey(String entityName, Long entityId, String key) {
        PropertySetItem item;
        try {
            Session session = this.sessionFactory.getCurrentSession();
            item = HibernatePropertySetDAOUtils.getItem(session, entityName, entityId, key);
            session.flush();
        }
        catch (HibernateException ignored) {
            return null;
        }
        return item;
    }

    public void remove(String entityName, Long entityId) {
        try {
            Session session = this.sessionFactory.getCurrentSession();
            Collection keys = this.getKeys(entityName, entityId, null, 0);
            for (String key : keys) {
                session.delete((Object)HibernatePropertySetDAOUtils.getItem(session, entityName, entityId, key));
            }
            session.flush();
        }
        catch (HibernateException e) {
            throw new PropertyException("Could not remove all keys: " + e.getMessage());
        }
    }

    public void remove(String entityName, Long entityId, String key) {
        try {
            Session session = this.sessionFactory.getCurrentSession();
            session.delete((Object)HibernatePropertySetDAOUtils.getItem(session, entityName, entityId, key));
            session.flush();
        }
        catch (HibernateException e) {
            throw new PropertyException("Could not remove key '" + key + "': " + e.getMessage());
        }
    }
}

