/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.propertyset.hibernate5;

import com.opensymphony.module.propertyset.hibernate5.PropertySetItem;
import com.opensymphony.module.propertyset.hibernate5.PropertySetItemImpl;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class HibernatePropertySetDAOUtils {
    public static PropertySetItem getItem(Session session, String entityName, Long entityId, String key) throws HibernateException {
        return (PropertySetItem)session.get(PropertySetItemImpl.class, (Serializable)new PropertySetItemImpl(entityName, entityId, key));
    }

    public static List getKeysImpl(Session session, String entityName, Long entityId, String prefix, int type) throws HibernateException {
        Query query;
        if (prefix != null && type > 0) {
            query = session.getNamedQuery("all_keys_with_type_like");
            query.setString("like", prefix + '%');
            query.setInteger("type", type);
        } else if (prefix != null) {
            query = session.getNamedQuery("all_keys_like");
            query.setString("like", prefix + '%');
        } else if (type > 0) {
            query = session.getNamedQuery("all_keys_with_type");
            query.setInteger("type", type);
        } else {
            query = session.getNamedQuery("all_keys");
        }
        query.setString("entityName", entityName);
        query.setLong("entityId", entityId.longValue());
        return query.list();
    }
}

