/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config.impl;

import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.ExceptionMappingConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.util.WildcardHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionConfigMatcher
implements Serializable {
    private static final Log log = LogFactory.getLog(ActionConfigMatcher.class);
    private static final WildcardHelper wildcard = new WildcardHelper();
    private List compiledPaths = new ArrayList();

    public ActionConfigMatcher(Map<String, ActionConfig> configs) {
        this(configs, false);
    }

    public ActionConfigMatcher(Map<String, ActionConfig> configs, boolean looseMatch) {
        for (String name : configs.keySet()) {
            if (name == null || name.indexOf(42) <= -1) continue;
            if (name.length() > 0 && name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Compiling action config path '" + name + "'"));
            }
            int[] pattern = wildcard.compilePattern(name);
            this.compiledPaths.add(new Mapping(name, pattern, configs.get(name)));
            int lastStar = name.lastIndexOf(42);
            if (lastStar <= 1 || lastStar != name.length() - 1 || name.charAt(lastStar - 1) == '*') continue;
            pattern = wildcard.compilePattern(name.substring(0, lastStar - 1));
            this.compiledPaths.add(new Mapping(name, pattern, configs.get(name)));
        }
    }

    public ActionConfig match(String path) {
        ActionConfig config = null;
        if (this.compiledPaths.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attempting to match '" + path + "' to a wildcard pattern, " + this.compiledPaths.size() + " available"));
            }
            HashMap vars = new HashMap();
            for (Mapping m : this.compiledPaths) {
                if (!wildcard.match(vars, path, m.getPattern())) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Path matches pattern '" + m.getOriginal() + "'"));
                }
                config = this.convertActionConfig(path, m.getActionConfig(), vars);
                break;
            }
        }
        return config;
    }

    protected ActionConfig convertActionConfig(String path, ActionConfig orig, Map vars) {
        String className = this.convertParam(orig.getClassName(), vars);
        String methodName = this.convertParam(orig.getMethodName(), vars);
        String pkgName = this.convertParam(orig.getPackageName(), vars);
        Map<String, Object> params = this.replaceParameters(orig.getParams(), vars);
        LinkedHashMap<String, ResultConfig> results = new LinkedHashMap<String, ResultConfig>();
        for (String name : orig.getResults().keySet()) {
            ResultConfig result = orig.getResults().get(name);
            name = this.convertParam(name, vars);
            String resultClassName = this.convertParam(result.getClassName(), vars);
            Map<String, Object> resultParams = this.replaceParameters(result.getParams(), vars);
            ResultConfig r = new ResultConfig(name, resultClassName, resultParams);
            results.put(name, r);
        }
        ArrayList<ExceptionMappingConfig> exs = new ArrayList<ExceptionMappingConfig>();
        for (ExceptionMappingConfig ex : orig.getExceptionMappings()) {
            String name = this.convertParam(ex.getName(), vars);
            String exClassName = this.convertParam(ex.getExceptionClassName(), vars);
            String exResult = this.convertParam(ex.getResult(), vars);
            Map<String, Object> exParams = this.replaceParameters(ex.getParams(), vars);
            ExceptionMappingConfig e = new ExceptionMappingConfig(name, exClassName, exResult, exParams);
            exs.add(e);
        }
        ActionConfig config = new ActionConfig(methodName, className, pkgName, params, results, orig.getInterceptors(), exs);
        config.setLocation(orig.getLocation());
        return config;
    }

    protected Map<String, Object> replaceParameters(Map<String, Object> orig, Map vars) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : orig.keySet()) {
            map.put(key, this.convertParam(String.valueOf(orig.get(key)), vars));
        }
        return map;
    }

    protected String convertParam(String val, Map vars) {
        if (val == null) {
            return null;
        }
        int len = val.length();
        StringBuilder ret = new StringBuilder();
        for (int x = 0; x < len; ++x) {
            char c = val.charAt(x);
            if (x < len - 2 && c == '{' && '}' == val.charAt(x + 2)) {
                String varVal = (String)vars.get(String.valueOf(val.charAt(x + 1)));
                if (varVal != null) {
                    ret.append(varVal);
                }
                x += 2;
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    private class Mapping
    implements Serializable {
        private String original;
        private int[] pattern;
        private ActionConfig config;

        public Mapping(String original, int[] pattern, ActionConfig config) {
            this.original = original;
            this.pattern = pattern;
            this.config = config;
        }

        public int[] getPattern() {
            return this.pattern;
        }

        public ActionConfig getActionConfig() {
            return this.config;
        }

        public String getOriginal() {
            return this.original;
        }
    }
}

